/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.RequestAdapter;
import com.caucho.server.webapp.DispatchResponse;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class NamedDispatcherImpl
implements RequestDispatcher {
    private static final L10N L = new L10N(NamedDispatcherImpl.class);
    private WebApp _webApp;
    private FilterChain _includeFilterChain;
    private FilterChain _forwardFilterChain;
    private String _queryString;

    NamedDispatcherImpl(FilterChain includeFilterChain, FilterChain forwardFilterChain, String queryString, WebApp webApp) {
        this._includeFilterChain = includeFilterChain;
        this._forwardFilterChain = forwardFilterChain;
        this._queryString = queryString;
        this._webApp = webApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(ServletRequest topRequest, ServletResponse topResponse) throws IOException, ServletException {
        HttpServletResponse parentRes;
        HttpServletRequest parentReq;
        ServletRequestWrapper reqWrapper = null;
        if (topRequest instanceof ServletRequestWrapper) {
            ServletRequest request = topRequest;
            while (request instanceof ServletRequestWrapper) {
                reqWrapper = (ServletRequestWrapper)request;
                request = ((ServletRequestWrapper)request).getRequest();
            }
            parentReq = (HttpServletRequest)request;
        } else if (topRequest instanceof HttpServletRequest) {
            parentReq = (HttpServletRequest)topRequest;
        } else {
            throw new IllegalStateException(L.l("expected instance of ServletRequestWrapper at `{0}'", (Object)topResponse));
        }
        ServletResponseWrapper resWrapper = null;
        if (topResponse instanceof ServletResponseWrapper) {
            ServletResponse response = topResponse;
            while (response instanceof ServletResponseWrapper) {
                resWrapper = (ServletResponseWrapper)response;
                response = ((ServletResponseWrapper)response).getResponse();
            }
            parentRes = (HttpServletResponse)response;
        } else if (topResponse instanceof HttpServletResponse) {
            parentRes = (HttpServletResponse)topResponse;
        } else {
            throw new IllegalStateException(L.l("expected instance of ServletResponse at `{0}'", (Object)topResponse));
        }
        RequestAdapter subRequest = RequestAdapter.create();
        subRequest.init(parentReq, parentRes, this._webApp);
        DispatchResponse subResponse = new DispatchResponse();
        subResponse.init(parentRes);
        if (reqWrapper != null) {
            reqWrapper.setRequest(subRequest);
        } else {
            topRequest = subRequest;
        }
        if (resWrapper != null) {
            resWrapper.setResponse(subResponse);
        } else {
            topResponse = subResponse;
        }
        try {
            this._includeFilterChain.doFilter(topRequest, topResponse);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            subResponse.finish();
            RequestAdapter.free(subRequest);
            if (reqWrapper != null) {
                reqWrapper.setRequest(parentReq);
            }
            if (resWrapper != null) {
                resWrapper.setResponse(parentRes);
            }
            throw throwable;
        }
        subResponse.finish();
        RequestAdapter.free(subRequest);
        if (reqWrapper != null) {
            reqWrapper.setRequest(parentReq);
        }
        if (resWrapper != null) {
            resWrapper.setResponse(parentRes);
        }
    }

    public void forward(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        res.resetBuffer();
        res.setContentLength(-1);
        this._forwardFilterChain.doFilter(req, res);
        if (res instanceof CauchoResponse) {
            CauchoResponse cRes = (CauchoResponse)res;
            cRes.close();
        } else {
            try {
                ServletOutputStream os = res.getOutputStream();
                if (os != null) {
                    os.close();
                }
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            try {
                PrintWriter out = res.getWriter();
                if (out != null) {
                    out.close();
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._includeFilterChain + "]";
    }
}

