/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.server.dispatch.Invocation;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.server.http.HttpServletResponseImpl;
import com.caucho.server.webapp.AsyncRequest;
import com.caucho.server.webapp.DispatchRequest;
import com.caucho.server.webapp.ErrorRequest;
import com.caucho.server.webapp.ForwardRequest;
import com.caucho.server.webapp.ForwardResponse;
import com.caucho.server.webapp.IncludeRequest;
import com.caucho.server.webapp.IncludeResponse;
import com.caucho.server.webapp.LoginRequest;
import com.caucho.server.webapp.ResumeFilterChain;
import com.caucho.server.webapp.UnknownWebApp;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class RequestDispatcherImpl
implements RequestDispatcher {
    private static final Logger log = Logger.getLogger(RequestDispatcherImpl.class.getName());
    private static final L10N L = new L10N(RequestDispatcherImpl.class);
    static final int MAX_DEPTH = 64;
    private WebApp _webApp;
    private Invocation _includeInvocation;
    private Invocation _forwardInvocation;
    private Invocation _errorInvocation;
    private Invocation _dispatchInvocation;
    private Invocation _requestInvocation;
    private Invocation _asyncInvocation;
    private boolean _isLogin;

    RequestDispatcherImpl(Invocation includeInvocation, Invocation forwardInvocation, Invocation errorInvocation, Invocation dispatchInvocation, Invocation requestInvocation, WebApp webApp) {
        this._includeInvocation = includeInvocation;
        this._forwardInvocation = forwardInvocation;
        this._errorInvocation = errorInvocation;
        this._dispatchInvocation = dispatchInvocation;
        this._requestInvocation = requestInvocation;
        this._webApp = webApp;
    }

    public void setLogin(boolean isLogin) {
        this._isLogin = isLogin;
    }

    public boolean isModified() {
        return this._includeInvocation.isModified();
    }

    public Invocation getAsyncInvocation() {
        if (this._asyncInvocation == null) {
            Invocation invocation = new Invocation();
            invocation.copyFrom(this._dispatchInvocation);
            FilterChain chain = invocation.getFilterChain();
            chain = new ResumeFilterChain(chain, invocation.getWebApp());
            invocation.setFilterChain(chain);
            this._asyncInvocation = invocation;
        }
        return this._asyncInvocation;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.forward(request, response, null, this._forwardInvocation, DispatcherType.FORWARD);
    }

    public void dispatchResume(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.dispatchResume((HttpServletRequest)request, (HttpServletResponse)response, this.getAsyncInvocation());
    }

    public void error(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.forward(request, response, "error", this._errorInvocation, DispatcherType.ERROR);
    }

    public void dispatch(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (request.getServletContext() instanceof UnknownWebApp) {
            this._requestInvocation.getFilterChain().doFilter(request, response);
        } else {
            this.forward(request, response, "error", this._dispatchInvocation, DispatcherType.REQUEST);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forward(ServletRequest topRequest, ServletResponse topResponse, String method, Invocation invocation, DispatcherType type) throws ServletException, IOException {
        HttpServletResponse parentRes;
        HttpServletRequest parentReq;
        CauchoResponse cauchoRes = null;
        boolean allowForward = false;
        if (this._webApp != null) {
            allowForward = this._webApp.isAllowForwardAfterFlush();
        }
        if (topResponse instanceof CauchoResponse) {
            cauchoRes = (CauchoResponse)topResponse;
            cauchoRes.setForwardEnclosed(!allowForward);
        }
        if (topResponse.isCommitted() && method == null && !allowForward) {
            IllegalStateException exn = new IllegalStateException(L.l("forward() not allowed after buffer has committed."));
            if (cauchoRes == null || !cauchoRes.hasError()) {
                if (cauchoRes != null) {
                    cauchoRes.setHasError(true);
                }
                throw exn;
            }
            this._webApp.log(exn.getMessage(), exn);
            return;
        }
        if ("error".equals(method) || method == null) {
            topResponse.resetBuffer();
            if (cauchoRes != null) {
                ServletResponse resp = cauchoRes;
                while (!(resp == null || allowForward && resp instanceof IncludeResponse)) {
                    if (resp instanceof CauchoResponse) {
                        CauchoResponse cr = resp;
                        cr.resetBuffer();
                        resp = cr.getResponse();
                        continue;
                    }
                    resp.resetBuffer();
                    resp = null;
                }
            }
        }
        ServletRequestWrapper reqWrapper = null;
        if (topRequest instanceof ServletRequestWrapper) {
            ServletRequest request = topRequest;
            while (request instanceof ServletRequestWrapper) {
                reqWrapper = (ServletRequestWrapper)request;
                request = ((ServletRequestWrapper)request).getRequest();
            }
            parentReq = (HttpServletRequest)request;
        } else if (topRequest instanceof HttpServletRequest) {
            parentReq = (HttpServletRequest)topRequest;
        } else {
            throw new IllegalStateException(L.l("expected instance of ServletRequest at `{0}'", (Object)topRequest));
        }
        ServletResponseWrapper resWrapper = null;
        if (topResponse instanceof ServletResponseWrapper) {
            ServletResponse response = topResponse;
            while (response instanceof ServletResponseWrapper) {
                resWrapper = (ServletResponseWrapper)response;
                response = ((ServletResponseWrapper)response).getResponse();
            }
            parentRes = (HttpServletResponse)response;
        } else if (topResponse instanceof HttpServletResponse) {
            parentRes = (HttpServletResponse)topResponse;
        } else {
            throw new IllegalStateException(L.l("expected instance of ServletResponse at `{0}'", (Object)topResponse));
        }
        ForwardRequest subRequest = this._isLogin ? new LoginRequest(parentReq, parentRes, invocation) : (type == DispatcherType.ERROR ? new ErrorRequest(parentReq, parentRes, invocation) : (type == DispatcherType.REQUEST ? new DispatchRequest(parentReq, parentRes, invocation) : new ForwardRequest(parentReq, parentRes, invocation)));
        if (subRequest.getRequestDepth(0) > 64) {
            throw new ServletException(L.l("too many servlet forwards `{0}'", (Object)parentReq.getServletPath()));
        }
        ForwardResponse subResponse = subRequest.getResponse();
        if (reqWrapper != null) {
            reqWrapper.setRequest(subRequest);
        } else {
            topRequest = subRequest;
        }
        if (resWrapper != null) {
            resWrapper.setResponse(subResponse);
        } else {
            topResponse = subResponse;
        }
        boolean isValid = false;
        subRequest.startRequest();
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            if (this._webApp != null) {
                thread.setContextClassLoader(this._webApp.getClassLoader());
            }
            invocation.service(topRequest, topResponse);
            isValid = true;
        }
        finally {
            if (reqWrapper != null) {
                reqWrapper.setRequest(parentReq);
            }
            if (resWrapper != null) {
                resWrapper.setResponse(parentRes);
            }
            subRequest.finishRequest(isValid);
            if (isValid) {
                this.finishResponse(topResponse);
            }
            thread.setContextClassLoader(loader);
        }
    }

    private void finishResponse(ServletResponse res) throws ServletException, IOException {
        block8: {
            if (this._webApp.isAllowForwardAfterFlush()) break block8;
            if (res instanceof CauchoResponse) {
                CauchoResponse cauchoResponse = (CauchoResponse)res;
                cauchoResponse.close();
                ServletResponse resp = cauchoResponse.getResponse();
                while (resp != null) {
                    if (resp instanceof CauchoResponse) {
                        CauchoResponse cr = (CauchoResponse)resp;
                        cr.close();
                        resp = cr.getResponse();
                        continue;
                    }
                    resp = null;
                }
            } else {
                try {
                    ServletOutputStream os = res.getOutputStream();
                    os.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    PrintWriter out = res.getWriter();
                    out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.include(request, response, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(ServletRequest topRequest, ServletResponse topResponse, String method) throws ServletException, IOException {
        HttpServletResponse parentRes;
        HttpServletRequest parentReq;
        Invocation invocation = this._includeInvocation;
        ServletRequestWrapper reqWrapper = null;
        if (topRequest instanceof ServletRequestWrapper) {
            ServletRequest request = topRequest;
            while (request instanceof ServletRequestWrapper) {
                reqWrapper = (ServletRequestWrapper)request;
                request = ((ServletRequestWrapper)request).getRequest();
            }
            parentReq = (HttpServletRequest)request;
        } else if (topRequest instanceof HttpServletRequest) {
            parentReq = (HttpServletRequest)topRequest;
        } else {
            throw new IllegalStateException(L.l("expected instance of ServletRequestWrapper at `{0}'", (Object)topResponse));
        }
        ServletResponseWrapper resWrapper = null;
        if (topResponse instanceof ServletResponseWrapper) {
            ServletResponse response = topResponse;
            while (response instanceof ServletResponseWrapper) {
                resWrapper = (ServletResponseWrapper)response;
                response = ((ServletResponseWrapper)response).getResponse();
            }
            parentRes = (HttpServletResponse)response;
        } else if (topResponse instanceof HttpServletResponse) {
            parentRes = (HttpServletResponse)topResponse;
        } else {
            throw new IllegalStateException(L.l("expected instance of ServletResponse at '{0}'", (Object)topResponse));
        }
        IncludeRequest subRequest = new IncludeRequest(parentReq, parentRes, invocation);
        if (subRequest.getRequestDepth(0) > 64) {
            throw new ServletException(L.l("too many servlet includes '{0}'", (Object)parentReq.getServletPath()));
        }
        IncludeResponse subResponse = subRequest.getResponse();
        if (reqWrapper != null) {
            reqWrapper.setRequest(subRequest);
        } else {
            topRequest = subRequest;
        }
        if (resWrapper != null) {
            resWrapper.setResponse(subResponse);
        } else {
            topResponse = subResponse;
        }
        subRequest.startRequest();
        try {
            invocation.service(topRequest, topResponse);
        }
        finally {
            if (reqWrapper != null) {
                reqWrapper.setRequest(parentReq);
            }
            if (resWrapper != null) {
                resWrapper.setResponse(parentRes);
            }
            subRequest.finishRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchResume(HttpServletRequest request, HttpServletResponse response, Invocation invocation) throws ServletException, IOException {
        HttpServletRequestWrapper parentRequest = null;
        HttpServletRequestImpl bottomRequest = null;
        HttpServletResponseImpl bottomResponse = null;
        HttpServletRequest req = request;
        while (req != null && req instanceof HttpServletRequestWrapper) {
            parentRequest = (HttpServletRequestWrapper)req;
            req = (HttpServletRequest)parentRequest.getRequest();
        }
        if (!(req instanceof HttpServletRequestImpl)) {
            throw new IllegalStateException(L.l("Wrapped async requests must use HttpServletRequestWrapper around the original request"));
        }
        bottomRequest = (HttpServletRequestImpl)req;
        HttpServletResponse res = response;
        while (res != null && res instanceof HttpServletResponseWrapper) {
            HttpServletResponseWrapper parentResponse = (HttpServletResponseWrapper)res;
            res = (HttpServletResponse)parentResponse.getResponse();
        }
        if (!(res instanceof HttpServletResponseImpl)) {
            throw new IllegalStateException(L.l("Wrapped async requests must use HttpServletRequestWrapper around the original request"));
        }
        bottomResponse = (HttpServletResponseImpl)res;
        AsyncRequest asyncRequest = new AsyncRequest(bottomRequest, bottomResponse, invocation);
        if (parentRequest != null) {
            parentRequest.setRequest(asyncRequest);
        } else {
            request = asyncRequest;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            invocation.service(request, response);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._dispatchInvocation.getRawURI() + "]";
    }
}

