/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.ConfigException;
import com.caucho.config.types.RawString;
import com.caucho.env.deploy.DeployConfig;
import com.caucho.env.deploy.DeployMode;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WebAppConfig
extends DeployConfig {
    private static final L10N L = new L10N(WebAppConfig.class);
    private static final Logger log = Logger.getLogger(WebAppConfig.class.getName());
    private Pattern _urlRegexp;
    private ArrayList<Pattern> _aliasUrlRegexpList = new ArrayList();
    private String _contextPath;
    private WebAppConfig _prologue;

    public String getContextPath() {
        String cp = this._contextPath;
        if (cp == null) {
            cp = this.getId();
        }
        if (cp == null) {
            return null;
        }
        if (cp.endsWith("/")) {
            return cp.substring(0, cp.length() - 1);
        }
        return cp;
    }

    public void setContextPath(String path) throws ConfigException {
        if (!path.startsWith("/")) {
            throw new ConfigException(L.l("context-path '{0}' must start with '/'.", (Object)path));
        }
        this._contextPath = path;
    }

    public void setURLRegexp(String pattern) {
        if (!pattern.endsWith("$")) {
            pattern = pattern + "$";
        }
        if (!pattern.startsWith("^")) {
            pattern = "^" + pattern;
        }
        this._urlRegexp = CauchoSystem.isCaseInsensitive() ? Pattern.compile(pattern, 2) : Pattern.compile(pattern);
    }

    public Pattern getURLRegexp() {
        return this._urlRegexp;
    }

    public void addAliasUrlRegexp(String pattern) {
        if (!pattern.endsWith("$")) {
            pattern = pattern + "$";
        }
        if (!pattern.startsWith("^")) {
            pattern = "^" + pattern;
        }
        Pattern urlRegexp = CauchoSystem.isCaseInsensitive() ? Pattern.compile(pattern, 2) : Pattern.compile(pattern);
        this._aliasUrlRegexpList.add(urlRegexp);
    }

    boolean isUrlMatch(String url) {
        for (int i = this._aliasUrlRegexpList.size() - 1; i >= 0; --i) {
            Pattern regexp = this._aliasUrlRegexpList.get(i);
            if (!regexp.matcher(url).matches()) continue;
            return true;
        }
        return false;
    }

    public void setAppDir(RawString appDir) {
        this.setRootDirectory(appDir);
    }

    public void setDocumentDirectory(RawString dir) {
        this.setRootDirectory(dir);
    }

    public void setLazyInit(boolean isLazy) throws ConfigException {
        log.config(L.l("lazy-init is deprecated.  Use <startup-mode>lazy</startup-mode> instead."));
        if (isLazy) {
            this.setStartupMode(DeployMode.LAZY);
        } else {
            this.setStartupMode(DeployMode.AUTOMATIC);
        }
    }

    public void setPrologue(WebAppConfig prologue) {
        this._prologue = prologue;
    }

    public DeployConfig getPrologue() {
        return this._prologue;
    }

    public String getContextPath(String uri) {
        Pattern regexp = this.getURLRegexp();
        String contextPath = this.getContextPath(regexp, uri);
        if (contextPath != null) {
            return contextPath;
        }
        for (Pattern pattern : this._aliasUrlRegexpList) {
            contextPath = this.getContextPath(pattern, uri);
            if (contextPath == null) continue;
            return contextPath;
        }
        return null;
    }

    private String getContextPath(Pattern regexp, String uri) {
        if (regexp == null) {
            return null;
        }
        Matcher matcher = regexp.matcher(uri);
        int tail = 0;
        while (tail >= 0 && tail <= uri.length()) {
            String prefix = uri.substring(0, tail);
            matcher.reset(prefix);
            if (matcher.find() && matcher.start() == 0) {
                return uri.substring(0, matcher.end());
            }
            if (tail >= uri.length()) break;
            if ((tail = uri.indexOf(47, tail + 1)) >= 0) continue;
            tail = uri.length();
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._contextPath + "]";
    }
}

