/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.env.deploy.DeployContainer;
import com.caucho.env.deploy.DeployGenerator;
import com.caucho.server.e_app.EarDeployController;
import com.caucho.server.e_app.EarDeployGenerator;
import com.caucho.server.webapp.WebAppContainer;
import com.caucho.server.webapp.WebAppController;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppEarDeployGenerator
extends DeployGenerator<WebAppController> {
    private static final Logger log = Logger.getLogger(WebAppEarDeployGenerator.class.getName());
    private WebAppContainer _container;
    private String _urlPrefix = "";
    private ClassLoader _parentLoader;
    private DeployContainer<EarDeployController> _earContainer;
    private EarDeployGenerator _earDeploy;

    public WebAppEarDeployGenerator(DeployContainer<WebAppController> deployContainer, WebAppContainer container, EarDeployGenerator earDeploy) throws Exception {
        super(deployContainer);
        this.setContainer(container);
        this._earDeploy = earDeploy;
        this._earContainer = earDeploy.getDeployContainer();
    }

    public WebAppContainer getContainer() {
        return this._container;
    }

    public void setContainer(WebAppContainer container) {
        this._container = container;
        if (this._parentLoader == null) {
            this._parentLoader = container.getClassLoader();
        }
    }

    public void setParentClassLoader(ClassLoader loader) {
        this._parentLoader = loader;
    }

    public void setURLPrefix(String prefix) {
        while (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        this._urlPrefix = prefix;
    }

    public String getURLPrefix() {
        return this._urlPrefix;
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Override
    protected void startImpl() {
        super.startImpl();
        this._earContainer.start();
    }

    @Override
    public boolean isModified() {
        boolean isModified = this._earContainer.isModified();
        return isModified;
    }

    @Override
    public boolean logModified(Logger log) {
        return this._earContainer.logModified(log);
    }

    @Override
    public void update() {
        this._earContainer.update();
    }

    @Override
    public void generateController(String name, ArrayList<WebAppController> list) {
        if (this._earContainer.isModified()) {
            this._earContainer.update();
        }
        for (EarDeployController earController : (EarDeployController[])this._earContainer.getControllers()) {
            WebAppController webAppController = earController.findWebAppController(name);
            if (webAppController == null) continue;
            list.add(webAppController);
            return;
        }
    }

    @Override
    protected void stopImpl() {
        this._earContainer.stop();
        super.stopImpl();
    }

    @Override
    protected void destroyImpl() {
        this._earContainer.destroy();
        super.destroyImpl();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._earDeploy + "]";
    }
}

