/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets;

import com.caucho.env.service.ResinSystem;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.HttpServletResponseImpl;
import com.caucho.server.util.CauchoSystem;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.util.QDate;
import com.caucho.util.RandomUtil;
import com.caucho.vfs.CaseInsensitive;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.GenericServlet;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileServlet
extends GenericServlet {
    private static final L10N L = new L10N(FileServlet.class);
    private static final Logger log = Logger.getLogger(FileServlet.class.getName());
    private static final EnvironmentLocal<LruCache<String, Cache>> _pathCacheLocal = new EnvironmentLocal();
    private final LruCache<String, Cache> _pathCache;
    private final LruCache<String, Cache> _localCache = new LruCache(16384);
    private Path _context;
    private WebApp _app;
    private RequestDispatcher _dir;
    private boolean _isCaseInsensitive;
    private boolean _isEnableRange = true;
    private boolean _isGenerateSession;
    private String _characterEncoding;

    public FileServlet() {
        ResinSystem resin = ResinSystem.getCurrent();
        LruCache<String, Cache> pathCache = _pathCacheLocal.get(resin.getClassLoader());
        if (pathCache == null) {
            pathCache = new LruCache(262144);
            _pathCacheLocal.set(pathCache, resin.getClassLoader());
        }
        this._pathCache = pathCache;
        this._isCaseInsensitive = CaseInsensitive.isCaseInsensitive();
    }

    public void setCharacterEncoding(String encoding) {
        this._characterEncoding = encoding;
    }

    public void setEnableRange(boolean isEnable) {
        this._isEnableRange = isEnable;
    }

    public void setGenerateSession(boolean isGenerateSession) {
        this._isGenerateSession = isGenerateSession;
    }

    public void removeCacheEntry(String uri) {
        this._pathCache.remove(uri);
    }

    public void init(ServletConfig conf) throws ServletException {
        String encoding;
        super.init(conf);
        this._app = (WebApp)this.getServletContext();
        this._context = this._app.getRootDirectory();
        try {
            this._dir = this._app.getNamedDispatcher("directory");
        }
        catch (Exception e) {
            log.log(Level.ALL, e.toString(), e);
        }
        String enable = this.getInitParameter("enable-range");
        if (enable != null && enable.equals("false")) {
            this._isEnableRange = false;
        }
        if ((encoding = this.getInitParameter("character-encoding")) != null && !"".equals(encoding)) {
            this._characterEncoding = encoding;
        }
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String ifRange;
        String range;
        String mime;
        HttpServletRequest req;
        CauchoRequest cauchoReq = null;
        if (request instanceof CauchoRequest) {
            cauchoReq = (CauchoRequest)request;
            req = cauchoReq;
        } else {
            req = (HttpServletRequest)request;
        }
        HttpServletResponse res = (HttpServletResponse)response;
        boolean isInclude = false;
        String uri = (String)req.getAttribute("javax.servlet.include.request_uri");
        if (uri != null) {
            isInclude = true;
        } else {
            uri = req.getRequestURI();
        }
        Cache cache = this._localCache.get(uri);
        String filename = null;
        String cacheUrl = null;
        if (cache == null && (cache = this._pathCache.get(cacheUrl = this.getCacheUrl(req, uri))) != null) {
            this._localCache.put(uri, cache);
        }
        if (cache == null) {
            String pathInfo;
            CharBuffer cb = new CharBuffer();
            String servletPath = cauchoReq != null ? cauchoReq.getPageServletPath() : (isInclude ? (String)req.getAttribute("javax.servlet.include.servlet_path") : req.getServletPath());
            if (servletPath != null) {
                cb.append(servletPath);
            }
            if ((pathInfo = cauchoReq != null ? cauchoReq.getPagePathInfo() : (isInclude ? (String)req.getAttribute("javax.servlet.include.path_info") : req.getPathInfo())) != null) {
                cb.append(pathInfo);
            }
            String relPath = cb.toString();
            if (this._isCaseInsensitive) {
                relPath = relPath.toLowerCase(Locale.ENGLISH);
            }
            filename = this.getServletContext().getRealPath(relPath);
            Path path = this._context.lookupNative(filename);
            if (cauchoReq != null && cauchoReq.getRequestDepth(0) == 0) {
                if (relPath.regionMatches(true, 0, "/web-inf", 0, 8) && (relPath.length() == 8 || !Character.isLetterOrDigit(relPath.charAt(8)))) {
                    res.sendError(404);
                    return;
                }
                if (relPath.regionMatches(true, 0, "/meta-inf", 0, 9) && (relPath.length() == 9 || !Character.isLetterOrDigit(relPath.charAt(9)))) {
                    res.sendError(404);
                    return;
                }
            }
            if (relPath.endsWith(".DS_store")) {
                res.sendError(404);
                return;
            }
            if (CauchoSystem.isWindows() && relPath.length() != 0 && !path.isDirectory() && path.isWindowsInsecure()) {
                res.sendError(404);
                return;
            }
            for (int i = relPath.length() - 1; i >= 0; --i) {
                char ch = relPath.charAt(i);
                if (ch != '\u0000') continue;
                res.sendError(404);
                return;
            }
            ServletContext webApp = this.getServletContext();
            String mimeType = webApp.getMimeType(relPath);
            boolean isPathReadable = path.canRead();
            Path jarPath = null;
            if (!isPathReadable) {
                String resource = "META-INF/resources" + relPath;
                URL url = webApp.getClassLoader().getResource(resource);
                if (url != null) {
                    jarPath = Vfs.lookup(url);
                }
            }
            cache = new Cache(path, jarPath, relPath, mimeType);
            this._localCache.put(uri, cache);
            this._pathCache.put(cacheUrl, cache);
        } else if (cache.isModified()) {
            cache = new Cache(cache.getFilePath(), cache.getJarPath(), cache.getRelPath(), cache.getMimeType());
            cacheUrl = this.getCacheUrl(req, uri);
            this._pathCache.put(cacheUrl, cache);
            this._localCache.put(uri, cache);
        }
        if (this._isGenerateSession) {
            req.getSession(true);
        }
        if (cache.isDirectory()) {
            if (!uri.endsWith("/")) {
                String queryString = req.getQueryString();
                if (queryString != null) {
                    this.sendRedirect(res, uri + "/?" + queryString);
                } else {
                    this.sendRedirect(res, uri + "/");
                }
            } else if (this._dir != null) {
                this._dir.forward(req, res);
            } else {
                res.sendError(404);
            }
            return;
        }
        if (!cache.canRead()) {
            if (isInclude) {
                throw new FileNotFoundException(uri);
            }
            res.sendError(404);
            return;
        }
        String method = req.getMethod();
        if (!(method.equalsIgnoreCase("GET") || method.equalsIgnoreCase("HEAD") || method.equalsIgnoreCase("POST"))) {
            res.sendError(501, "Method not implemented");
            return;
        }
        String ifMatch = req.getHeader("If-None-Match");
        String etag = cache.getEtag();
        if (ifMatch != null && ifMatch.equals(etag)) {
            res.addHeader("ETag", etag);
            res.sendError(304);
            return;
        }
        String lastModified = cache.getLastModifiedString();
        if (ifMatch == null) {
            String ifModified = req.getHeader("If-Modified-Since");
            boolean isModified = true;
            if (ifModified != null) {
                if (ifModified.equals(lastModified)) {
                    isModified = false;
                } else {
                    long ifModifiedTime;
                    QDate date = QDate.allocateLocalDate();
                    try {
                        ifModifiedTime = date.parseDate(ifModified);
                    }
                    catch (Exception e) {
                        log.log(Level.FINER, e.toString(), e);
                        ifModifiedTime = 0L;
                    }
                    QDate.freeLocalDate(date);
                    boolean bl = isModified = ifModifiedTime == 0L || ifModifiedTime != cache.getLastModified();
                }
            }
            if (!isModified) {
                if (etag != null) {
                    res.addHeader("ETag", etag);
                }
                res.sendError(304);
                return;
            }
        }
        res.addHeader("ETag", etag);
        res.addHeader("Last-Modified", lastModified);
        if (this._isEnableRange && cauchoReq != null && cauchoReq.isTop()) {
            res.addHeader("Accept-Ranges", "bytes");
        }
        if (this._characterEncoding != null) {
            res.setCharacterEncoding(this._characterEncoding);
        }
        if ((mime = cache.getMimeType()) != null) {
            res.setContentType(mime);
        }
        if (method.equalsIgnoreCase("HEAD")) {
            if (res instanceof CauchoResponse) {
                CauchoResponse cRes = (CauchoResponse)res;
                cRes.setContentLength(cache.getLength());
            } else if (cache.getLength() <= Integer.MAX_VALUE) {
                res.setContentLength((int)cache.getLength());
            }
            return;
        }
        if (this._isEnableRange && (range = req.getHeader("Range")) != null && ((ifRange = req.getHeader("If-Range")) == null || ifRange.equals(etag)) && this.handleRange(req, res, cache, range, mime)) {
            return;
        }
        if (res instanceof CauchoResponse) {
            CauchoResponse cRes = (CauchoResponse)res;
            cRes.setContentLength(cache.getLength());
            cRes.getResponseStream().sendFile(cache.getPath(), 0L, cache.getLength());
        } else {
            long length = cache.getLength();
            if (length >= 0L && length < Integer.MAX_VALUE) {
                res.setContentLength((int)length);
            }
            ServletOutputStream os = res.getOutputStream();
            cache.getPath().writeToStream(os);
        }
    }

    private String getCacheUrl(HttpServletRequest req, String uri) {
        WebApp webApp = (WebApp)req.getServletContext();
        return webApp.getId() + "|" + uri;
    }

    private void sendRedirect(HttpServletResponse res, String url) throws IOException {
        String encUrl;
        HttpServletResponseImpl resImpl = null;
        if (res instanceof HttpServletResponseImpl) {
            resImpl = (HttpServletResponseImpl)res;
            encUrl = resImpl.encodeAbsoluteRedirect(url);
        } else {
            encUrl = res.encodeRedirectURL(url);
        }
        try {
            res.reset();
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
        res.setStatus(301);
        res.setHeader("Location", encUrl);
        res.setContentType("text/html; charset=utf-8");
        PrintWriter out = res.getWriter();
        out.println("The URL has moved <a href=\"" + encUrl + "\">here</a>");
        if (resImpl != null) {
            resImpl.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleRange(HttpServletRequest req, HttpServletResponse res, Cache cache, String range, String mime) throws IOException {
        int length = range.length();
        boolean hasMore = range.indexOf(44) > 0;
        long cacheLength = cache.getLength();
        long bytesMax = 2L * cacheLength;
        long bytesWritten = 0L;
        int head = 0;
        boolean isFirstChunk = true;
        String boundary = null;
        int off = range.indexOf("bytes=", head);
        ServletOutputStream os = null;
        if (off < 0) {
            return false;
        }
        off += 6;
        while (off > 0 && off < length) {
            Object var30_24;
            boolean hasFirst = false;
            long first = 0L;
            boolean hasLast = false;
            long last = 0L;
            int ch = -1;
            while (off < length) {
                char c = range.charAt(off);
                ch = c;
                if (c != ' ') break;
                ++off;
            }
            while (off < length) {
                char c = range.charAt(off);
                ch = c;
                if (c < '0' || ch > 57) break;
                first = 10L * first + (long)ch - 48L;
                hasFirst = true;
                ++off;
            }
            if (length <= off && !isFirstChunk) break;
            if (ch != 45) {
                return false;
            }
            ++off;
            while (off < length) {
                char c = range.charAt(off);
                ch = c;
                if (c < '0' || ch > 57) break;
                last = 10L * last + (long)ch - 48L;
                hasLast = true;
                ++off;
            }
            if (off < length && ch != 32 && ch != 44) {
                return false;
            }
            while (off < length) {
                char c = range.charAt(off);
                ch = c;
                if (c != ' ') break;
                ++off;
            }
            head = off;
            if (!hasLast) {
                if (first == 0L) {
                    return false;
                }
                last = cacheLength - 1L;
            }
            if (!hasFirst) {
                first = cacheLength - last;
                last = cacheLength - 1L;
            }
            if (last < first || cacheLength <= last) break;
            res.setStatus(206);
            StringBuilder cb = new StringBuilder();
            cb.append("bytes ");
            cb.append(first);
            cb.append('-');
            cb.append(last);
            cb.append('/');
            cb.append(cacheLength);
            String chunkRange = cb.toString();
            if (bytesMax <= (bytesWritten += last - first + 1L)) {
                String msg = L.l("{0} too many range bytes requested {1} for uri={2} IP={3}", (Object)this, (Object)bytesWritten, (Object)req.getRequestURL(), (Object)req.getRemoteAddr());
                log.warning(msg);
                if (msg != null) {
                    throw new IOException(msg);
                }
            }
            if (hasMore) {
                if (isFirstChunk) {
                    StringBuilder cb1 = new StringBuilder();
                    cb1.append("--");
                    Base64.encode(cb1, RandomUtil.getRandomLong());
                    boundary = cb1.toString();
                    res.setContentType("multipart/byteranges; boundary=" + boundary);
                    os = res.getOutputStream();
                } else {
                    os.write(13);
                    os.write(10);
                }
                isFirstChunk = false;
                os.write(45);
                os.write(45);
                os.print(boundary);
                os.print("\r\nContent-Type: ");
                os.print(mime);
                os.print("\r\nContent-Range: ");
                os.print(chunkRange);
                os.write(13);
                os.write(10);
                os.write(13);
                os.write(10);
            } else {
                if (res instanceof CauchoResponse) {
                    CauchoResponse cRes = (CauchoResponse)res;
                    cRes.setContentLength(last - first + 1L);
                } else {
                    res.setContentLength((int)(last - first + 1L));
                }
                res.addHeader("Content-Range", chunkRange);
            }
            ReadStream is = null;
            try {
                is = cache.getPath().openRead();
                is.skip(first);
                os = res.getOutputStream();
                is.writeToStream(os, (int)(last - first + 1L));
                var30_24 = null;
                if (is != null) {
                    is.close();
                }
            }
            catch (Throwable throwable) {
                var30_24 = null;
                if (is != null) {
                    is.close();
                }
                throw throwable;
            }
            --off;
            while (off < length && range.charAt(off) != ',') {
                ++off;
            }
            ++off;
        }
        if (hasMore) {
            os = res.getOutputStream();
            os.write(13);
            os.write(10);
            os.write(45);
            os.write(45);
            os.print(boundary);
            os.write(45);
            os.write(45);
            os.write(13);
            os.write(10);
        }
        return true;
    }

    static class Cache {
        private Path _path;
        private Path _jarPath;
        private Path _pathResolved;
        private boolean _isDirectory;
        private boolean _canRead;
        private long _length;
        private long _lastModified = -2401057700593545203L;
        private String _relPath;
        private String _etag;
        private String _lastModifiedString;
        private String _mimeType;

        Cache(Path path, Path jarPath, String relPath, String mimeType) {
            this._path = path;
            this._jarPath = jarPath;
            this._relPath = relPath;
            this._mimeType = mimeType;
            this.fillData();
        }

        Path getPath() {
            return this._pathResolved;
        }

        Path getFilePath() {
            return this._path;
        }

        Path getJarPath() {
            return this._jarPath;
        }

        boolean canRead() {
            return this._canRead;
        }

        boolean isDirectory() {
            return this._isDirectory;
        }

        long getLength() {
            return this._length;
        }

        String getRelPath() {
            return this._relPath;
        }

        String getEtag() {
            return this._etag;
        }

        long getLastModified() {
            return this._lastModified;
        }

        String getLastModifiedString() {
            return this._lastModifiedString;
        }

        String getMimeType() {
            return this._mimeType;
        }

        boolean isModified() {
            long lastModified = this._pathResolved.getLastModified();
            long length = this._pathResolved.getLength();
            if (this._path != this._pathResolved && this._path.canRead()) {
                return true;
            }
            return lastModified != this._lastModified || length != this._length;
        }

        private void fillData() {
            this._pathResolved = this._path;
            if (this._jarPath != null && !this._path.canRead()) {
                this._pathResolved = this._jarPath;
            }
            long lastModified = this._pathResolved.getLastModified();
            long length = this._pathResolved.getLength();
            this._lastModified = lastModified;
            this._length = length;
            this._canRead = this._pathResolved.canRead();
            this._isDirectory = this._pathResolved.isDirectory();
            StringBuilder sb = new StringBuilder();
            sb.append('\"');
            Base64.encode(sb, this._pathResolved.getCrc64());
            sb.append('\"');
            this._etag = sb.toString();
            QDate cal = QDate.allocateGmtDate();
            cal.setGMTTime(lastModified);
            this._lastModifiedString = cal.printDate();
            QDate.freeGmtDate(cal);
            if (lastModified == 0L) {
                this._canRead = false;
                this._isDirectory = false;
            }
        }
    }
}

