/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets.webdav;

import com.caucho.server.webapp.WebApp;
import com.caucho.servlets.webdav.ApplicationPath;
import com.caucho.servlets.webdav.AttributeName;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlApplicationPath
extends ApplicationPath {
    private Path _root;
    private HashMap _map = new HashMap();

    public void setRoot(Path path) {
        this._root = path;
    }

    public Path getRoot() {
        return this._root;
    }

    public boolean remove(String path, HttpServletRequest request, ServletContext app) throws IOException {
        this.removeAttributes(path);
        return super.remove(path, request, app);
    }

    public Iterator getAttributeNames(String path, HttpServletRequest request, ServletContext app) throws IOException {
        FileAttributes attrs = this.getAttributes(path);
        if (attrs != null) {
            return attrs.getAttributeNames();
        }
        return null;
    }

    public String getAttribute(AttributeName name, String path, HttpServletRequest request, ServletContext app) throws IOException {
        FileAttributes attrs = this.getAttributes(path);
        if (attrs != null) {
            return attrs.getAttribute(name);
        }
        return null;
    }

    public boolean setAttribute(AttributeName name, String value, String path, HttpServletRequest request, ServletContext app) throws IOException {
        FileAttributes attrs = this.getAttributes(path);
        if (attrs != null) {
            return attrs.setAttribute(name, value);
        }
        return false;
    }

    public boolean removeAttribute(AttributeName name, String path, HttpServletRequest request, ServletContext app) throws IOException {
        FileAttributes attrs = this.getAttributes(path);
        if (attrs != null) {
            attrs.removeAttribute(name);
        }
        return true;
    }

    protected FileAttributes getAttributes(String path) {
        FileAttributes attrs = (FileAttributes)this._map.get(path);
        if (attrs == null) {
            attrs = new FileAttributes();
            this._map.put(path, attrs);
        }
        return attrs;
    }

    protected void removeAttributes(String path) {
        this._map.remove(path);
    }

    public String[] list(String path, HttpServletRequest request, ServletContext app) throws IOException {
        ArrayList<String> filteredList = new ArrayList<String>();
        String[] names = this.getPath(path, request, app).list();
        for (int i = 0; i < names.length; ++i) {
            if (names[i].startsWith(".")) continue;
            filteredList.add(names[i]);
        }
        return filteredList.toArray(new String[filteredList.size()]);
    }

    protected Path getPath(String path, HttpServletRequest request, ServletContext app) throws IOException {
        Path filePath;
        String tail;
        Path appDir = ((WebApp)app).getRootDirectory();
        if (this._root != null) {
            appDir = this._root;
        }
        if ((tail = (filePath = appDir.lookup("./" + path)).getTail()).startsWith(".")) {
            return filePath.getParent().lookup(".bogus");
        }
        return filePath;
    }

    static class AttributeHandler
    extends DefaultHandler {
        HashMap fileMap = new HashMap();
        AttributeName attributeName;
        String fileName;
        CharBuffer value;
        boolean inHref;
        FileAttributes fileAttributes;

        AttributeHandler() {
        }

        HashMap getFileMap() {
            return this.fileMap;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (localName.equals("file")) {
                this.fileName = null;
                this.fileAttributes = new FileAttributes();
            } else if (localName.equals("href")) {
                this.inHref = true;
                this.value = CharBuffer.allocate();
            } else if (this.attributeName == null) {
                this.attributeName = new AttributeName(uri, localName, qName);
                this.value = CharBuffer.allocate();
            }
        }

        public void characters(char[] buffer, int offset, int length) {
            if (this.value != null) {
                this.value.append(buffer, offset, length);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equals("file")) {
                if (this.fileName != null) {
                    this.fileMap.put(this.fileName, this.fileAttributes);
                }
                this.fileName = null;
                this.fileAttributes = null;
            } else if (localName.equals("href")) {
                this.fileName = this.value.close();
                this.value = null;
            } else if (this.attributeName != null && localName.equals(this.attributeName.getLocal()) && uri.equals(this.attributeName.getNamespace())) {
                this.fileAttributes.setAttribute(this.attributeName, this.value.close());
                this.value = null;
                this.attributeName = null;
            }
        }
    }

    public static class FileAttributes {
        HashMap attributes = new HashMap();

        public Iterator getAttributeNames() throws IOException {
            return this.attributes.keySet().iterator();
        }

        public String getAttribute(AttributeName name) throws IOException {
            return (String)this.attributes.get(name);
        }

        public boolean setAttribute(AttributeName name, String value) {
            this.attributes.put(name, value);
            return true;
        }

        public void removeAttribute(AttributeName name) throws IOException {
            this.attributes.remove(name);
        }
    }
}

