/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.util.L10N;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class ConnectionPoolAdapter
implements ConnectionPoolDataSource {
    private static final L10N L = new L10N(ConnectionPoolAdapter.class);
    private DataSource _dataSource;

    public ConnectionPoolAdapter(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public int getLoginTimeout() throws SQLException {
        return this._dataSource.getLoginTimeout();
    }

    public void setLoginTimeout(int loginTimeout) throws SQLException {
        this._dataSource.setLoginTimeout(loginTimeout);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this._dataSource.getLogWriter();
    }

    public void setLogWriter(PrintWriter log) throws SQLException {
        this._dataSource.setLogWriter(log);
    }

    public PooledConnection getPooledConnection() throws SQLException {
        return new PooledConnectionAdapter(this._dataSource.getConnection());
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        Connection conn = this._dataSource.getConnection(user, password);
        return new PooledConnectionAdapter(conn);
    }

    public Logger getParentLogger() {
        return null;
    }

    static class PooledConnectionAdapter
    implements PooledConnection {
        private Connection _conn;

        PooledConnectionAdapter(Connection conn) {
            this._conn = conn;
        }

        public Connection getConnection() throws SQLException {
            if (this._conn != null) {
                return this._conn;
            }
            throw new SQLException(L.l("connection is not available because it has been closed."));
        }

        public void addConnectionEventListener(ConnectionEventListener listener) {
        }

        public void removeConnectionEventListener(ConnectionEventListener listener) {
        }

        public void addStatementEventListener(StatementEventListener listener) {
        }

        public void removeStatementEventListener(StatementEventListener listener) {
        }

        public void close() throws SQLException {
            Connection conn = this._conn;
            this._conn = null;
            if (conn != null) {
                conn.close();
            }
        }

        public Logger getParentLogger() {
            return null;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._conn + "]";
        }
    }
}

