/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.config.ConfigException;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.sql.DBPool;
import com.caucho.sql.DriverConfig;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.net.URL;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DatabaseManager {
    protected static final Logger log = Logger.getLogger(DatabaseManager.class.getName());
    private static final L10N L = new L10N(DatabaseManager.class);
    private static final EnvironmentLocal<DatabaseManager> _localManager = new EnvironmentLocal();
    private final HashMap<String, DBPool> _databaseMap = new HashMap();
    private final ArrayList<Driver> _driverList = new ArrayList();
    private int _gId;

    private DatabaseManager() {
        this.initDriverList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DatabaseManager getLocalManager() {
        EnvironmentLocal<DatabaseManager> environmentLocal = _localManager;
        synchronized (environmentLocal) {
            DatabaseManager manager = _localManager.getLevel();
            if (manager == null) {
                manager = new DatabaseManager();
                _localManager.set(manager);
            }
            return manager;
        }
    }

    public static DataSource findDatabase(String url) throws SQLException {
        String driver = DatabaseManager.findDriverByUrl(url);
        return DatabaseManager.getLocalManager().findDatabaseImpl(url, url, driver);
    }

    public static DataSource findDatabase(String url, String driver) throws SQLException {
        return DatabaseManager.getLocalManager().findDatabaseImpl(url, url, driver);
    }

    public static DataSource findDatabase(String id, String url, String driver) throws SQLException {
        return DatabaseManager.getLocalManager().findDatabaseImpl(id, url, driver);
    }

    public static void closeDatabase(DataSource ds) {
        DatabaseManager.getLocalManager().closeImpl(ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSource findDatabaseImpl(String id, String url, String driverName) throws SQLException {
        try {
            HashMap<String, DBPool> hashMap = this._databaseMap;
            synchronized (hashMap) {
                DBPool db = this._databaseMap.get(url);
                if (db == null) {
                    db = new DBPool();
                    db.setVar(id + "-" + this._gId++);
                    DriverConfig driver = db.createDriver();
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    Class<?> driverClass = Class.forName(driverName, false, loader);
                    driver.setType(driverClass);
                    driver.setURL(url);
                    db.init();
                    this._databaseMap.put(url, db);
                }
                return db;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeImpl(DataSource dataSource) {
        DBPool db = (DBPool)dataSource;
        if (db == null) {
            return;
        }
        try {
            String key = null;
            HashMap<String, DBPool> hashMap = this._databaseMap;
            synchronized (hashMap) {
                for (Map.Entry<String, DBPool> entry : this._databaseMap.entrySet()) {
                    if (entry.getValue() != db) continue;
                    key = entry.getKey();
                }
                if (key == null) {
                    return;
                }
                this._databaseMap.remove(key);
            }
            db.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public static String findDriverByUrl(String url) {
        return DatabaseManager.getLocalManager().findDriverByUrlImpl(url);
    }

    private String findDriverByUrlImpl(String url) {
        for (int i = 0; i < this._driverList.size(); ++i) {
            try {
                Driver driver = this._driverList.get(i);
                if (!driver.acceptsURL(url)) continue;
                return driver.getClass().getName();
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initDriverList() {
        try {
            Thread thread = Thread.currentThread();
            ClassLoader loader = thread.getContextClassLoader();
            Enumeration<URL> iter = loader.getResources("META-INF/services/java.sql.Driver");
            while (iter.hasMoreElements()) {
                Object var11_13;
                URL url = iter.nextElement();
                ReadStream is = null;
                try {
                    try {
                        String filename;
                        is = Vfs.lookup(url.toString()).openRead();
                        while ((filename = is.readLine()) != null) {
                            int p = filename.indexOf(35);
                            if (p >= 0) {
                                filename = filename.substring(0, p);
                            }
                            if ((filename = filename.trim()).length() == 0) continue;
                            try {
                                Class<?> cl = Class.forName(filename, false, loader);
                                Driver driver = null;
                                if (Driver.class.isAssignableFrom(cl)) {
                                    driver = (Driver)cl.newInstance();
                                }
                                if (driver == null) continue;
                                log.fine(L.l("DatabaseManager adding driver '{0}'", (Object)driver.getClass().getName()));
                                this._driverList.add(driver);
                            }
                            catch (Exception e) {
                                log.log(Level.FINE, e.toString(), e);
                            }
                        }
                        var11_13 = null;
                        if (is == null) continue;
                        is.close();
                    }
                    catch (Exception e) {
                        log.log(Level.FINE, e.toString(), e);
                        var11_13 = null;
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (Throwable throwable) {
                    var11_13 = null;
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                    return;
                }
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    static class DatabaseKey {
        private String _url;
        private String _catalog;

        DatabaseKey(String url, String catalog) {
            this._url = url;
            this._catalog = catalog;
        }

        public int hashCode() {
            int hash = 37;
            hash = 65521 * hash + this._url.hashCode();
            if (this._catalog != null) {
                hash = 65521 * hash + this._catalog.hashCode();
            }
            return hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DatabaseKey)) {
                return false;
            }
            DatabaseKey key = (DatabaseKey)o;
            if (!this._url.equals(key._url)) {
                return false;
            }
            return this._catalog == key._catalog || this._catalog != null && this._catalog.equals(key._catalog);
        }
    }
}

