/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FreeList<T> {
    private final int _size;
    private final AtomicReferenceArray<T> _freeStack;
    private final AtomicInteger _top = new AtomicInteger();

    public FreeList(int size) {
        this._size = size;
        this._freeStack = new AtomicReferenceArray(size);
    }

    public T allocate() {
        int top = this._top.get();
        if (top > 0 && this._top.compareAndSet(top, top - 1)) {
            return this._freeStack.getAndSet(top - 1, null);
        }
        return null;
    }

    public boolean free(T obj) {
        int top = this._top.get();
        if (top < this._size) {
            boolean isFree = this._freeStack.compareAndSet(top, null, obj);
            this._top.compareAndSet(top, top + 1);
            return isFree;
        }
        return false;
    }

    public boolean freeCareful(T obj) {
        if (this.checkDuplicate(obj)) {
            throw new IllegalStateException("tried to free object twice: " + obj);
        }
        return this.free(obj);
    }

    public boolean checkDuplicate(T obj) {
        int top = this._top.get();
        for (int i = top - 1; i >= 0; --i) {
            if (this._freeStack.get(i) != obj) continue;
            return true;
        }
        return false;
    }
}

