/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import java.io.Serializable;

public class HashKey
implements Serializable {
    private final byte[] _hash;

    public HashKey(byte[] hash) {
        if (hash == null) {
            throw new NullPointerException();
        }
        this._hash = hash;
    }

    public static HashKey create(byte[] hash) {
        if (hash != null) {
            return new HashKey(hash);
        }
        return null;
    }

    public static byte[] getHash(HashKey testValue) {
        return testValue != null ? testValue.getHash() : null;
    }

    public byte[] getHash() {
        return this._hash;
    }

    public boolean isNull() {
        byte[] hash = this._hash;
        int length = hash.length;
        for (int i = length - 1; i >= 0; --i) {
            if (hash[i] == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isAny() {
        byte[] hash = this._hash;
        int length = hash.length;
        for (int i = length - 1; i >= 0; --i) {
            if (hash[i] == -1) continue;
            return false;
        }
        return true;
    }

    public static String toString(byte[] hash) {
        if (hash == null) {
            return "null";
        }
        return HashKey.toString(hash, hash.length);
    }

    public static String toString(byte[] hash, int len) {
        if (hash == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int d1 = hash[i] >> 4 & 0xF;
            int d2 = hash[i] & 0xF;
            if (d1 < 10) {
                sb.append((char)(48 + d1));
            } else {
                sb.append((char)(97 + d1 - 10));
            }
            if (d2 < 10) {
                sb.append((char)(48 + d2));
                continue;
            }
            sb.append((char)(97 + d2 - 10));
        }
        return sb.toString();
    }

    public int hashCode() {
        byte[] buf = this._hash;
        return (buf[0] << 24) + (buf[1] << 16) + (buf[2] << 8) + buf[3];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HashKey)) {
            return false;
        }
        HashKey key = (HashKey)o;
        byte[] hashA = this._hash;
        int len = hashA.length;
        byte[] hashB = key._hash;
        if (len != hashB.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (hashA[i] == hashB[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] hashA, byte[] hashB) {
        if (hashA == hashB) {
            return true;
        }
        if (hashA == null || hashB == null) {
            return false;
        }
        int len = hashA.length;
        if (len != hashB.length) {
            return false;
        }
        for (int i = len - 1; i >= 0; --i) {
            if (hashA[i] == hashB[i]) continue;
            return false;
        }
        return true;
    }

    public int compareTo(HashKey key) {
        if (key == null) {
            return 1;
        }
        byte[] hashA = this._hash;
        byte[] hashB = key._hash;
        int len = hashA.length;
        for (int i = 0; i < len; ++i) {
            int delta = hashA[i] - hashB[i];
            if (delta == 0) continue;
            return delta;
        }
        return 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + HashKey.toString(this._hash, 4) + "]";
    }
}

