/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import java.util.Iterator;

public class IdentityIntMap {
    public static final int NULL = Integer.MIN_VALUE;
    private static int DELETED = 1;
    private Object[] keys = new Object[16];
    private int nullValue;
    private int[] values = new int[16];
    private byte[] flags = new byte[16];
    private int size = 0;
    private int mask = this.keys.length - 1;

    public IdentityIntMap() {
        this.nullValue = Integer.MIN_VALUE;
    }

    public void clear() {
        this.nullValue = Integer.MIN_VALUE;
        for (int i = 0; i < this.values.length; ++i) {
            this.keys[i] = null;
            this.flags[i] = 0;
            this.values[i] = 0;
        }
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public int get(Object key) {
        if (key == null) {
            return this.nullValue;
        }
        int hash = System.identityHashCode(key) & this.mask;
        Object mapKey;
        while ((mapKey = this.keys[hash]) != key) {
            if (mapKey == null) {
                if ((this.flags[hash] & DELETED) == 0) {
                    return Integer.MIN_VALUE;
                }
            } else if (mapKey.equals(key)) {
                return this.values[hash];
            }
            hash = hash + 1 & this.mask;
        }
        return this.values[hash];
    }

    private void resize(int newSize) {
        Object[] newKeys = new Object[newSize];
        int[] newValues = new int[newSize];
        byte[] newFlags = new byte[newSize];
        this.mask = newKeys.length - 1;
        block0: for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null || (this.flags[i] & DELETED) != 0) continue;
            int hash = System.identityHashCode(this.keys[i]) & this.mask;
            while (true) {
                if (newKeys[hash] == null) {
                    newKeys[hash] = this.keys[i];
                    newValues[hash] = this.values[i];
                    newFlags[hash] = this.flags[i];
                    continue block0;
                }
                hash = hash + 1 & this.mask;
            }
        }
        this.keys = newKeys;
        this.values = newValues;
        this.flags = newFlags;
    }

    public int put(Object key, int value) {
        if (key == null) {
            int old = this.nullValue;
            this.nullValue = value;
            return old;
        }
        int hash = System.identityHashCode(key) & this.mask;
        while (true) {
            Object testKey;
            if ((testKey = this.keys[hash]) == null || (this.flags[hash] & DELETED) != 0) {
                this.keys[hash] = key;
                this.values[hash] = value;
                this.flags[hash] = 0;
                ++this.size;
                if (this.keys.length <= 2 * this.size) {
                    this.resize(2 * this.keys.length);
                }
                return Integer.MIN_VALUE;
            }
            if (key == testKey || testKey.equals(key)) break;
            hash = hash + 1 & this.mask;
        }
        int old = this.values[hash];
        this.values[hash] = value;
        return old;
    }

    public int remove(Object key) {
        if (key == null) {
            int old = this.nullValue;
            this.nullValue = Integer.MIN_VALUE;
            return old;
        }
        int hash = System.identityHashCode(key) & this.mask;
        Object mapKey;
        while ((mapKey = this.keys[hash]) != null) {
            if (mapKey.equals(key)) {
                int n = hash;
                this.flags[n] = (byte)(this.flags[n] | DELETED);
                --this.size;
                this.keys[hash] = null;
                return this.values[hash];
            }
            hash = hash + 1 & this.mask;
        }
        return Integer.MIN_VALUE;
    }

    public Iterator iterator() {
        return new IntMapIterator();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("IntMap[");
        boolean isFirst = true;
        for (int i = 0; i <= this.mask; ++i) {
            if ((this.flags[i] & DELETED) != 0 || this.keys[i] == null) continue;
            if (!isFirst) {
                sbuf.append(", ");
            }
            isFirst = false;
            sbuf.append(this.keys[i]);
            sbuf.append(":");
            sbuf.append(this.values[i]);
        }
        sbuf.append("]");
        return sbuf.toString();
    }

    class IntMapIterator
    implements Iterator {
        int index;

        IntMapIterator() {
        }

        public boolean hasNext() {
            while (this.index < IdentityIntMap.this.keys.length) {
                if (IdentityIntMap.this.keys[this.index] != null && (IdentityIntMap.this.flags[this.index] & DELETED) == 0) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        public Object next() {
            while (this.index < IdentityIntMap.this.keys.length) {
                if (IdentityIntMap.this.keys[this.index] != null && (IdentityIntMap.this.flags[this.index] & DELETED) == 0) {
                    return IdentityIntMap.this.keys[this.index++];
                }
                ++this.index;
            }
            return null;
        }

        public void remove() {
            throw new RuntimeException();
        }
    }
}

