/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

public class IntQueue {
    private int _start;
    private int _end;
    private int _size;
    private int _capacity;
    private int[] _queue;

    public IntQueue() {
        this(32);
    }

    public IntQueue(int initialCapacity) {
        this._queue = new int[initialCapacity];
        this._capacity = initialCapacity;
    }

    public void add(int value) {
        if (this._size == this._capacity) {
            this.expand(this._capacity * 2);
        }
        this._queue[this._end] = value;
        this._end = (this._end + 1) % this._capacity;
        ++this._size;
    }

    public int remove() {
        if (this._size == 0) {
            throw new RuntimeException("queue is empty");
        }
        int value = this._queue[this._start];
        this._start = (this._start + 1) % this._capacity;
        --this._size;
        return value;
    }

    public int size() {
        return this._size;
    }

    public int capacity() {
        return this._capacity;
    }

    private void expand(int capacity) {
        int[] newQueue = new int[capacity];
        if (this._start < this._end) {
            System.arraycopy(this._queue, this._start, newQueue, 0, this._size);
        } else {
            int partSize = this._capacity - this._start;
            System.arraycopy(this._queue, this._start, newQueue, 0, partSize);
            System.arraycopy(this._queue, 0, newQueue, partSize, this._end);
        }
        this._queue = newQueue;
        this._capacity = capacity;
        this._start = 0;
        this._end = this._size;
    }
}

