/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.DatastorePath;
import java.io.IOException;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Enumerated;
import javax.persistence.Transient;

@Entity
public class DatastoreFile {
    private String _pathname;
    private int _blockSize;
    private int _fileSize;
    @Enumerated
    private byte[] _block = new byte[0x400000];
    @Transient
    DatastorePath _path;

    public DatastoreFile(String pathname) {
        this._pathname = pathname;
    }

    public String getPathname() {
        return this._pathname;
    }

    public long getLength() throws IOException {
        return this._fileSize;
    }

    public void setPath(DatastorePath path) {
        this._path = path;
    }

    public DatastorePath getPath() {
        return this._path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(byte[] buffer, int off, int len) throws IOException {
        EntityManager em = this._path.getEntityManager();
        em.getTransaction().begin();
        try {
            try {
                System.arraycopy(buffer, off, this._block, this._fileSize, len);
                this._fileSize += len;
            }
            catch (Exception e) {
                e.printStackTrace();
                Object var7_6 = null;
                em.merge(this);
                em.getTransaction().commit();
                return;
            }
            Object var7_5 = null;
            em.merge(this);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            em.merge(this);
            em.getTransaction().commit();
            throw throwable;
        }
        em.getTransaction().commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(int position, byte[] buffer, int off, int len) throws IOException {
        EntityManager em = this._path.getEntityManager();
        em.getTransaction().begin();
        try {
            block4: {
                try {
                    System.arraycopy(buffer, off, this._block, position, len);
                    if (this._fileSize >= position + len) break block4;
                    this._fileSize = position + len;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Object var8_7 = null;
                    em.merge(this);
                    em.getTransaction().commit();
                    return;
                }
            }
            Object var8_6 = null;
            em.merge(this);
            em.getTransaction().commit();
            return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            em.merge(this);
            em.getTransaction().commit();
            throw throwable;
        }
    }

    public int read(int position, byte[] buffer, int off, int len) throws IOException {
        if ((len = Math.min(this._fileSize - position, len)) <= 0) {
            return 0;
        }
        System.arraycopy(this._block, position, buffer, off, len);
        return len;
    }
}

