/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.vfs.GoogleInode;
import com.caucho.vfs.GooglePath;
import com.caucho.vfs.StreamImpl;
import com.google.appengine.api.files.FileWriteChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

class GoogleWriteStream
extends StreamImpl {
    private static final L10N L = new L10N(GoogleWriteStream.class);
    private final GooglePath _path;
    private FileWriteChannel _os;
    private final ByteBuffer _buf = ByteBuffer.allocate(8192);
    private GoogleInode _inode;
    private long _length;

    GoogleWriteStream(GooglePath path, FileWriteChannel os, GoogleInode inode) {
        this._path = path;
        this._os = os;
        this._inode = inode;
    }

    public boolean canWrite() {
        return true;
    }

    public void write(byte[] buffer, int offset, int length, boolean isEnd) throws IOException {
        while (length > 0) {
            int sublen = Math.min(this._buf.capacity(), length);
            this._buf.clear();
            this._buf.put(buffer, offset, sublen);
            this._buf.flip();
            sublen = this._os.write(this._buf);
            if (sublen <= 0) {
                throw new IOException(L.l("{0}: Unable to write", (Object)this));
            }
            length -= sublen;
            offset += sublen;
            this._length += (long)sublen;
        }
    }

    public void close() throws IOException {
        FileWriteChannel os = this._os;
        this._os = null;
        if (os != null) {
            os.closeFinally();
            GoogleInode inode = this._inode;
            if (inode == null || !inode.isDirectory()) {
                long time = CurrentTime.getCurrentTime();
                if (inode != null) {
                    inode.setLastModified(time);
                }
                this._inode = inode = new GoogleInode(this._path.getTail(), GoogleInode.FileType.FILE, this._length, time);
            }
            this._path.writeInode(inode);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._path.getNativePath() + "," + this._os + "]";
    }
}

