/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.QSocket;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TcpPath;
import com.caucho.vfs.TcpsPath;
import com.caucho.vfs.net.NetworkSystem;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

class TcpStream
extends StreamImpl {
    private static final Logger log = Logger.getLogger(TcpStream.class.getName());
    private QSocket _s;
    private StreamImpl _stream;

    private TcpStream(TcpPath path, long connectTimeout, long socketTimeout, boolean isNoDelay) throws IOException {
        this.setPath(path);
        NetworkSystem network = NetworkSystem.getCurrent();
        InetSocketAddress addr = (InetSocketAddress)path.getSocketAddress();
        this._s = network.connect(addr.getAddress(), addr.getPort(), connectTimeout);
        if (socketTimeout < 0L) {
            socketTimeout = 120000L;
        }
        this._s.setSoTimeout((int)socketTimeout);
        if (isNoDelay) {
            this._s.setTcpNoDelay(true);
        }
        try {
            if (path instanceof TcpsPath) {
                SSLContext context = SSLContext.getInstance("TLS");
                X509TrustManager tm = new X509TrustManager(){

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    public void checkClientTrusted(X509Certificate[] cert, String foo) {
                    }

                    public void checkServerTrusted(X509Certificate[] cert, String foo) {
                    }
                };
                context.init(null, new TrustManager[]{tm}, null);
                SSLSocketFactory factory = context.getSocketFactory();
                Socket socket = this._s.getSocket();
                socket = factory.createSocket(socket, path.getHost(), path.getPort(), true);
                this._s.setSocket(socket);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(e);
        }
        this._stream = this._s.getStream();
    }

    public void setAttribute(String name, Object value) {
        block9: {
            if (name.equals("timeout")) {
                try {
                    if (value instanceof Number) {
                        this._s.setSoTimeout(((Number)value).intValue());
                        break block9;
                    }
                    this._s.setSoTimeout(Integer.parseInt(String.valueOf(value)));
                }
                catch (SocketException e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            } else if (name.equals("no-delay")) {
                try {
                    if (Boolean.TRUE.equals(value)) {
                        this._s.setTcpNoDelay(true);
                    }
                }
                catch (SocketException e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
        }
    }

    static TcpStream openRead(TcpPath path, long connectTimeout, long socketTimeout, boolean isNoDelay) throws IOException {
        return new TcpStream(path, connectTimeout, socketTimeout, isNoDelay);
    }

    static TcpStream openReadWrite(TcpPath path, long connectTimeout, long socketTimeout, boolean isNoDelay) throws IOException {
        return new TcpStream(path, connectTimeout, socketTimeout, isNoDelay);
    }

    public boolean canWrite() {
        return this._stream != null && this._stream.canWrite();
    }

    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        StreamImpl stream = this._stream;
        if (stream != null) {
            stream.write(buf, offset, length, isEnd);
        }
    }

    public boolean canRead() {
        StreamImpl stream = this._stream;
        return stream != null && stream.canRead();
    }

    public int getAvailable() throws IOException {
        StreamImpl stream = this._stream;
        if (stream != null) {
            return stream.getAvailable();
        }
        return -1;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        StreamImpl stream = this._stream;
        if (stream != null) {
            int len;
            try {
                len = stream.read(buf, offset, length);
            }
            catch (SocketException e) {
                log.log(Level.FINER, e.toString(), e);
                len = -1;
            }
            if (len < 0) {
                this.close();
            }
            return len;
        }
        return -1;
    }

    public void closeWrite() throws IOException {
        StreamImpl stream = this._stream;
        this._stream = null;
        if (stream != null) {
            stream.closeWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws IOException {
        StreamImpl stream = this._stream;
        this._stream = null;
        QSocket s = this._s;
        this._s = null;
        try {
            if (stream != null) {
                stream.close();
            }
            Object var4_3 = null;
            if (s == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (s == null) throw throwable;
            s.close();
            throw throwable;
        }
        s.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._s + "]";
    }
}

