/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.util.CharBuffer;
import com.caucho.xml.QName;
import org.xml.sax.Attributes;

class QAttributes
implements Attributes {
    QName[] names = new QName[32];
    String[] values = new String[32];
    int size;

    QAttributes() {
    }

    void clear() {
        this.size = 0;
    }

    void add(QName name, String value) {
        if (this.size == this.names.length) {
            QName[] newNames = new QName[2 * this.names.length];
            String[] newValues = new String[2 * this.names.length];
            System.arraycopy(this.names, 0, newNames, 0, this.names.length);
            System.arraycopy(this.values, 0, newValues, 0, this.names.length);
            this.names = newNames;
            this.values = newValues;
        }
        this.names[this.size] = name;
        this.values[this.size] = value;
        ++this.size;
    }

    public int getLength() {
        return this.size;
    }

    public QName getName(int i) {
        return this.names[i];
    }

    public String getQName(int i) {
        return this.names[i].getName();
    }

    public String getURI(int i) {
        String uri = this.names[i].getNamespaceURI();
        if (uri != null) {
            return uri;
        }
        return "";
    }

    public String getLocalName(int i) {
        String name = this.names[i].getLocalName();
        if (name != null) {
            return name;
        }
        return "";
    }

    public String getValue(int i) {
        return this.values[i];
    }

    public String getValue(String qName) {
        for (int i = 0; i < this.size; ++i) {
            if (!qName.equals(this.names[i].getName())) continue;
            return this.values[i];
        }
        return null;
    }

    public String getValue(String uri, String localName) {
        for (int i = 0; i < this.size; ++i) {
            String testURI = this.names[i].getNamespaceURI();
            if (testURI == null) {
                testURI = "";
            }
            if (!uri.equals(testURI) || !localName.equals(this.names[i].getLocalName())) continue;
            return this.values[i];
        }
        return null;
    }

    public int getIndex(String qName) {
        for (int i = 0; i < this.size; ++i) {
            if (!qName.equals(this.names[i].getName())) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(String uri, String localName) {
        for (int i = 0; i < this.size; ++i) {
            if (!uri.equals(this.names[i].getNamespaceURI()) || !localName.equals(this.names[i].getLocalName())) continue;
            return i;
        }
        return -1;
    }

    public String getType(int i) {
        return "CDATA";
    }

    public String getType(String uri, String localName) {
        return "CDATA";
    }

    public String getType(String qName) {
        return "CDATA";
    }

    public String toString() {
        CharBuffer cb = CharBuffer.allocate();
        cb.append("[QAttributes");
        for (int i = 0; i < this.size; ++i) {
            cb.append(" ");
            cb.append(this.names[i]);
            cb.append("=\"");
            cb.append(this.values[i]);
            cb.append("\"");
        }
        cb.append("]");
        return cb.close();
    }
}

