/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.util.L10N;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.xml.Xml;
import com.caucho.xml.XmlPrinter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import org.w3c.dom.Node;

public class SerializedXml
implements Externalizable {
    protected static L10N L = new L10N(SerializedXml.class);
    private Node _node;

    public SerializedXml() {
    }

    public SerializedXml(Node node) {
        this._node = node;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        XmlPrinter printer = new XmlPrinter(new OutputStreamWrapper(out));
        printer.printXml(this._node);
        out.writeByte(239);
        out.writeByte(191);
        out.writeByte(191);
    }

    public void readExternal(ObjectInput in) throws IOException {
        Xml parser = Xml.create();
        try {
            ReadStream is = Vfs.openRead(new InputStreamWrapper(in));
            this._node = parser.parseDocument(is);
            is.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(e);
        }
        parser.free();
    }

    private Object readResolve() {
        return this._node;
    }

    static class OutputStreamWrapper
    extends OutputStream {
        private ObjectOutput _out;

        OutputStreamWrapper(ObjectOutput out) {
            this._out = out;
        }

        public void write(int ch) throws IOException {
            this._out.write(ch);
        }

        public void write(byte[] buf, int off, int len) throws IOException {
            this._out.write(buf, off, len);
        }
    }

    static class InputStreamWrapper
    extends InputStream {
        private ObjectInput _in;

        InputStreamWrapper(ObjectInput in) {
            this._in = in;
        }

        public int read() throws IOException {
            int ch = this._in.readByte() & 0xFF;
            return ch;
        }

        public int read(byte[] buffer, int off, int length) throws IOException {
            buffer[off] = this._in.readByte();
            return 1;
        }
    }
}

