/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.stream.events;

import com.caucho.xml.stream.events.XMLEventImpl;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.ProcessingInstruction;

public class ProcessingInstructionImpl
extends XMLEventImpl
implements ProcessingInstruction {
    private final String _target;
    private final String _data;

    public ProcessingInstructionImpl(String target, String data) {
        this._target = target;
        this._data = data;
    }

    public String getData() {
        return this._data;
    }

    public String getTarget() {
        return this._target;
    }

    public int getEventType() {
        return 3;
    }

    public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
        try {
            writer.write("<?" + this._target);
            if (this._data != null && !"".equals(this._data)) {
                writer.write(" " + this._data);
            }
            writer.write("?>");
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof ProcessingInstruction)) {
            return false;
        }
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        ProcessingInstruction instruction = (ProcessingInstruction)o;
        return this.getData().equals(instruction.getData()) && this.getTarget().equals(instruction.getTarget());
    }
}

