/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xml.XmlUtil;
import com.caucho.xpath.Env;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.Axis;
import org.w3c.dom.Node;

public class FromAncestors
extends Axis {
    private boolean _self;

    public FromAncestors(AbstractPattern parent, boolean self) {
        super(parent);
        this._self = self;
        if (parent == null) {
            throw new RuntimeException();
        }
    }

    public boolean match(Node node, ExprEnvironment env) throws XPathException {
        if (node == null) {
            return false;
        }
        Node lastNode = this.lastDescendantNode(node);
        if (!this._self) {
            node = XmlUtil.getNext(node);
        }
        while (node != null && node != lastNode) {
            if (this._parent.match(node, env)) {
                return true;
            }
            node = XmlUtil.getNext(node);
        }
        return false;
    }

    public boolean isAscending() {
        return false;
    }

    public Node firstNode(Node node, ExprEnvironment env) {
        if (this._self) {
            return node;
        }
        return node.getParentNode();
    }

    public Node nextNode(Node node, Node last) {
        return node == null ? null : node.getParentNode();
    }

    public int position(Node node, Env env, AbstractPattern pattern) throws XPathException {
        Node axis;
        Node lastNode = this.lastDescendantNode(node);
        Node node2 = axis = this._self ? node : XmlUtil.getNext(node);
        for (int index = env.getPositionIndex(); index >= 0; --index) {
            while (axis != lastNode && axis != null && !this._parent.match(axis, env)) {
                axis = XmlUtil.getNext(axis);
            }
            if (index <= 0) continue;
            axis = XmlUtil.getNext(axis);
        }
        if (axis == lastNode) {
            return 0;
        }
        Node next = XmlUtil.getNext(axis);
        while (next != lastNode) {
            if (this._parent.match(next, env)) {
                env.setMorePositions(true);
                break;
            }
            next = XmlUtil.getNext(next);
        }
        Node a1 = axis;
        if (!this._self && axis != null) {
            axis = axis.getParentNode();
        }
        int count = 0;
        while (axis != null) {
            if (pattern.match(axis, env)) {
                ++count;
            }
            if (node == axis) break;
            axis = axis.getParentNode();
        }
        return count;
    }

    private Node lastDescendantNode(Node node) {
        Node last;
        for (last = node; last != null && last.getNextSibling() == null; last = last.getParentNode()) {
        }
        return last != null ? last.getNextSibling() : null;
    }

    public int count(Node node, Env env, AbstractPattern pattern) {
        throw new RuntimeException();
    }

    public String toString() {
        return this.getPrefix() + (this._self ? "ancestor-or-self::" : "ancestor::");
    }
}

