/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xml.XmlUtil;
import com.caucho.xpath.Env;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.Axis;
import org.w3c.dom.Node;

public class FromNext
extends Axis {
    public FromNext(AbstractPattern parent) {
        super(parent);
        if (parent == null) {
            throw new RuntimeException();
        }
    }

    public boolean match(Node node, ExprEnvironment env) throws XPathException {
        if (node == null) {
            return false;
        }
        return this.getAxisContext(node, env) != null;
    }

    public boolean isStrictlyAscending() {
        if (this._parent == null) {
            return true;
        }
        return this._parent.isSingleSelect();
    }

    public Node firstNode(Node node, ExprEnvironment env) {
        while (node != null) {
            if (node.getNextSibling() != null) {
                return node.getNextSibling();
            }
            node = node.getParentNode();
        }
        return null;
    }

    public Node nextNode(Node node, Node lastNode) {
        return XmlUtil.getNext(node);
    }

    public int position(Node node, Env env, AbstractPattern pattern) throws XPathException {
        int index = env.getPositionIndex();
        int count = 1;
        Node ptr = XmlUtil.getPrevious(node);
        while (ptr != null) {
            if (this._parent.match(ptr, env)) {
                boolean isParent = false;
                for (Node n = node; n != null; n = n.getParentNode()) {
                    if (n != ptr) continue;
                    isParent = true;
                    break;
                }
                if (!isParent && --index < 0) {
                    while (ptr != null) {
                        if (this._parent.match(ptr, env)) {
                            env.setMorePositions(true);
                            break;
                        }
                        ptr = XmlUtil.getPrevious(ptr);
                    }
                    return count;
                }
            }
            if (pattern.match(ptr, env)) {
                ++count;
            }
            ptr = XmlUtil.getPrevious(ptr);
        }
        return count;
    }

    private Node getAxisContext(Node node, ExprEnvironment env) throws XPathException {
        if (node == null) {
            return null;
        }
        Node prev = node;
        while (prev != null) {
            if (!this.isDescendant(node, prev) && this._parent.match(prev, env)) {
                return prev;
            }
            prev = XmlUtil.getPrevious(prev);
        }
        return null;
    }

    private boolean isDescendant(Node descendant, Node node) {
        while (descendant != node && descendant != null) {
            descendant = descendant.getParentNode();
        }
        return descendant != null;
    }

    public String toString() {
        return this.getPrefix() + "following::";
    }
}

