/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl.java;

import com.caucho.java.JavaWriter;
import com.caucho.xml.QName;
import com.caucho.xsl.XslParseException;
import com.caucho.xsl.java.XslAttributeNode;
import com.caucho.xsl.java.XslNamespaceNode;
import com.caucho.xsl.java.XslNode;
import com.caucho.xsl.java.XslUseAttributeSets;

public class XslElementNode
extends XslNode {
    private static final QName _useAttributeSets = new QName("xsl", "use-attribute-sets", "http://www.w3.org/1999/XSL/Transform");
    private QName _name;

    public XslElementNode(QName name) {
        this._name = name;
    }

    public String getTagName() {
        return this._name.getName();
    }

    public void addAttribute(QName name, String value) throws XslParseException {
        if (_useAttributeSets.equals(name)) {
            XslUseAttributeSets attr = new XslUseAttributeSets(value);
            attr.setGenerator(this._gen);
            this.addChild(attr);
        } else if (name.getName().startsWith("xmlns")) {
            super.addAttribute(name, value);
            if (!"http://www.w3.org/1999/XSL/Transform".equals(value) && !"http://www.caucho.com/XTP/1.0".equals(value)) {
                XslNamespaceNode attr = new XslNamespaceNode(name, value);
                attr.setParent(this);
                attr.setGenerator(this._gen);
                this.addChild(attr);
            }
        } else if (!"http://www.w3.org/1999/XSL/Transform".equals(name.getNamespaceURI()) && !"http://www.caucho.com/XTP/1.0".equals(name.getNamespaceURI())) {
            XslAttributeNode attr = new XslAttributeNode(name, value);
            attr.setParent(this);
            attr.setGenerator(this._gen);
            this.addChild(attr);
        }
    }

    public void generate(JavaWriter out) throws Exception {
        String namespace = this._name.getNamespaceURI();
        String prefix = this._name.getPrefix();
        String local = this._name.getLocalName();
        String name = this._name.getName();
        this._gen.printLocation(this._systemId, this._filename, this._startLine);
        String[] postPrefix = this._gen.getNamespaceAlias(namespace);
        if (postPrefix != null) {
            prefix = postPrefix[0];
            namespace = postPrefix[1];
            name = prefix == null || prefix.equals("") ? local : prefix + ":" + local;
        }
        out.print("out.pushElement(");
        out.print(namespace == null ? "\"\"" : "\"" + namespace + "\"");
        out.print(prefix == null ? ", null" : ", \"" + prefix + "\"");
        out.print(local == null ? ", null" : ", \"" + local + "\"");
        out.print(name == null ? ", null" : ", \"" + name + "\"");
        out.println(");");
        this.generateChildren(out);
        out.println("out.popElement();");
    }
}

