/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators;

import javax.script.ScriptException;
import javax.validation.ConstraintDeclarationException;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.hibernate.validator.constraints.ScriptAssert;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.logging.Messages;
import org.hibernate.validator.internal.util.scriptengine.ScriptEvaluator;
import org.hibernate.validator.internal.util.scriptengine.ScriptEvaluatorFactory;

public class ScriptAssertValidator
implements ConstraintValidator<ScriptAssert, Object> {
    private static final Log log = LoggerFactory.make();
    private String script;
    private String languageName;
    private String alias;

    public void initialize(ScriptAssert constraintAnnotation) {
        this.validateParameters(constraintAnnotation);
        this.script = constraintAnnotation.script();
        this.languageName = constraintAnnotation.lang();
        this.alias = constraintAnnotation.alias();
    }

    public boolean isValid(Object value, ConstraintValidatorContext constraintValidatorContext) {
        Object evaluationResult;
        ScriptEvaluator scriptEvaluator;
        try {
            ScriptEvaluatorFactory evaluatorFactory = ScriptEvaluatorFactory.getInstance();
            scriptEvaluator = evaluatorFactory.getScriptEvaluatorByLanguageName(this.languageName);
        }
        catch (ScriptException e) {
            throw new ConstraintDeclarationException((Throwable)e);
        }
        try {
            evaluationResult = scriptEvaluator.evaluate(this.script, value, this.alias);
        }
        catch (ScriptException e) {
            throw log.getErrorDuringScriptExecutionException(this.script, e);
        }
        if (evaluationResult == null) {
            throw log.getScriptMustReturnTrueOrFalseException(this.script);
        }
        if (!(evaluationResult instanceof Boolean)) {
            throw log.getScriptMustReturnTrueOrFalseException(this.script, evaluationResult, evaluationResult.getClass().getCanonicalName());
        }
        return Boolean.TRUE.equals(evaluationResult);
    }

    private void validateParameters(ScriptAssert constraintAnnotation) {
        Contracts.assertNotEmpty(constraintAnnotation.script(), Messages.MESSAGES.parameterMustNotBeEmpty("script"));
        Contracts.assertNotEmpty(constraintAnnotation.lang(), Messages.MESSAGES.parameterMustNotBeEmpty("lang"));
        Contracts.assertNotEmpty(constraintAnnotation.alias(), Messages.MESSAGES.parameterMustNotBeEmpty("alias"));
    }
}

