<?php

require_once "WEB-INF/php/inc.php";

$title = "Resin Admin Login";

display_header("login.php", $title, null);

if ($GLOBAL["error"]) {
  echo "<h3 class='fail'>Error: $error</h3>";
}

?>
<h2><?= gettext('Login')?></h2>

<form method="POST" action="j_security_check?j_uri=index.php">
<table border='0'>
<tr>
  <th><label for="j_username"><?= gettext('Username')?></label>: </th>
  <td>
    <input id="j_username" name="j_username" width="40"/>
  </td>
</tr>
<tr>
  <th><label for="j_password"><?= gettext('Password')?></label>: </th>
  <td>
    <input id="j_password" name="j_password" width="40" type="password"/>
  </td>
</tr>
<tr>
  <td>
    <input type="submit" value="<?= gettext('Submit')?>"/>
  </td>
  <td></td>
</tr>
</table>
</form>
&nbsp<br/>

<?php

$digest_username = null;

$auth = java_bean("resin-admin-authenticator");

if (! $auth || ! $auth->isComplete()) {
  include "digest.php";
}

if (! empty($digest)) {
  admin_init();
  
  $conf = $g_resin->getConfigFile();
  $conf_dir = $g_resin->getConfigDirectory();
  $root_dir = $g_resin->getRootDirectory();
  
  // generate temporary config file
  try {
    $old_reporting_level = error_reporting(0);
    
    $password_file = realpath("{$conf_dir}/admin-users.xml.generated");
    $file = fopen($password_file, "w");
    if (! $file) {
      $password_file = realpath("{$root_dir}/admin-users.xml.generated");
      $file = fopen($password_file, "w");
    }
    
    error_reporting($old_reporting_level);

    if ($file) {
      fwrite($file, <<<EOF
<!-- Automatically generated by Resin Admin -->
<!-- move to {$conf_dir}/admin-users.xml to install -->
<resin:AdminAuthenticator xmlns="http://caucho.com/ns/resin"
                          xmlns:resin="urn:java:com.caucho.resin">
  <user name="$digest_username" password="$digest"/>
</resin:AdminAuthenticator>

EOF
);
      fclose($file);
    }
  } catch(Exception $e) {
  }  
?>

<ol>

<?php if ($digest_username) {?>
<li><?= gettext('To add the admin user, copy and paste the following into')?> 
<code><?= $conf_dir ?>/resin.properties</code>:
<div class="example">
admin_user     : <?= $digest_username ?><br/>
admin_password : <?= $digest ?><br/>
</div>
<?php if ($file) {?>
<?= gettext('Or a file has been written to')?>  
<code><?= $password_file ?></code>. <?= gettext('Simply rename this file to')?>  
<code><?= $conf_dir ?>/admin-users.xml</code> <?= gettext('to install your login.')?>
<br/>&nbsp;</li>
<?php } else { ?>
<?= gettext('Or copy and paste the following into')?> 
<code><?= $conf_dir ?>/admin-users.xml</code>:
<div class="example">
&lt;resin:AdminAuthenticator xmlns="http://caucho.com/ns/resin" xmlns:resin="urn:java:com.caucho.resin"><br/>
&nbsp;&nbsp;&lt;user name="<?= $digest_username ?>" password="<?= $digest ?>"/><br/>
&lt;/resin:AdminAuthenticator><br/>
</div>
<?php } // file?>
</li>
<?php } // digest_username?>

<li>
<?= gettext('By default, access to the administration application is limited to the local network. To enable access to clients other than local network, add to') ?> 
<code><?= $conf_dir ?>/resin.properties</code>:
<div class="example">
admin_external : true<br/>
admin_secure   : true<br/>
</div>

<?= gettext('Or modify directly')?> 
<code><?= $conf ?></code>:

<div class="example">
&lt;resin:set var="resin_admin_external" value="true"/&gt;
</div>
<br/>
</li>

<li>
<?php
$prompt = gettext('Once the file has been saved, you can <a href=\'$login_uri\'>continue to the administration area</a>. This will trigger a server restart, so just refresh your browser until you see the login page again.');
$prompt = preg_replace('/\$login_uri/', $login_uri, $prompt);
echo $prompt;
?>
<br/>&nbsp;</li>

<li>
<?= gettext('When prompted, use the username and password you provided.')?>
<br/></li>

</ol>

<?php } ?>

<br/>
<br/>

<?php display_footer("login.php"); ?>

