var verticalDropdownMenu = {
	"show": {
		"animate": true,
		"duration": {$showAnimationDuration},
		"before": {
			"filter": "alpha(opacity=0)",
			"opacity": "0"
		},
		"properties": {
			"filter": "alpha(opacity=100)",
			"opacity": "1"
		},
		"after": {
			"width": "initial",
			"height": "initial",
			"overflow": "visible"
		}
	},
	"hide": {
		"animate": true,
		"duration": {$hideAnimationDuration},
		"properties": {
			"filter": "alpha(opacity=0)",
			"opacity": "0"
		},
		"after": {
			"display": "none"
		}
	},
	"items": {
		"content" : {
			"hover_in": {
				"animate": true,
				"duration": {$hoverInAnimationDuration},
				"child:0": {
					"properties" : {
						{$backgroundHoverProperties}
					}
				},
				"child:1": {
					"tag": "span",
					"properties" : {
						{$textHoverProperties}
					}
				}
			},
			"hover_out": {
				"animate": true,
				"duration": {$hoverOutAnimationDuration},
				"child:0": {
					"properties" : {
						{$backgroundNormalProperties}
					}
				},
				"child:1": {
					"tag": "span",
					"properties" : {
						{$textNormalProperties}
					}
				}
			}
		},
		"hover_in": {
			"content": {
				"event": "hover_in"
			},
			"submenu": {
				"event": "show",
				"delay": {$hoverInAnimationDelay}
			}
		},
		"hover_out": {
			"content": {
				"event": "hover_out",
				"delay": {$hoverOutAnimationDelay}
			},
			"submenu": {
				"event": "hide"
			}
		}
	}
};

registerMenuClass('{$menuClass}', verticalDropdownMenu);