/*
 * Decompiled with CFR 0.152.
 */
package com.diamondpants.spritecraft;

import com.diamondpants.spritecraft.Blueprint;
import com.diamondpants.spritecraft.MaterialSet;
import com.diamondpants.spritecraft.Utils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class Generator {
    private MaterialSet materialSet;
    private DitherOption dither = DitherOption.Auto;
    private boolean sideView = true;
    private int maxHeight = 0;
    private int maxWidth = 0;

    public Generator() throws IOException {
        this.materialSet = new MaterialSet();
    }

    public DitherOption getDither() {
        return this.dither;
    }

    public void setDither(DitherOption dither) {
        this.dither = dither;
    }

    public boolean getSideView() {
        return this.sideView;
    }

    public void setSideView(boolean sideView) {
        this.sideView = sideView;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public MaterialSet getMaterialSet() {
        return this.materialSet;
    }

    public Blueprint run(BufferedImage image) throws IOException {
        image = Generator.resizeImage(image, this.maxWidth, this.maxHeight);
        int w = image.getWidth();
        int h = image.getHeight();
        boolean doDither = this.dither == DitherOption.On || this.dither == DitherOption.Auto && w >= 120 && h >= 120;
        int[][] ditherData = null;
        if (doDither) {
            ditherData = new int[2][w * 3];
        }
        byte[][] usedMaterials = new byte[h][w];
        int i = 0;
        while (i < h) {
            if (doDither) {
                ditherData[0] = ditherData[1];
                ditherData[1] = new int[w * 3];
            }
            int j = 0;
            while (j < w) {
                int rgb = image.getRGB(j, i);
                if ((rgb >> 24 & 0xFF) != 0) {
                    int r = rgb >> 16 & 0xFF;
                    int g = rgb >> 8 & 0xFF;
                    int b = rgb & 0xFF;
                    if (doDither) {
                        g += ditherData[0][j * 3 + 1];
                        int n = (r += ditherData[0][j * 3 + 0]) < 0 ? 0 : (r = r > 255 ? 255 : r);
                        int n2 = g < 0 ? 0 : (g = g > 255 ? 255 : g);
                        b = b < 0 ? 0 : (b > 255 ? 255 : (b += ditherData[0][j * 3 + 2]));
                    }
                    usedMaterials[i][j] = this.materialSet.findBestMatch(r, g, b, this.sideView);
                    if (doDither) {
                        Color closestMatch = this.materialSet.getMaterials().get(usedMaterials[i][j]).getAvgColor(this.sideView);
                        int rDiff = r - closestMatch.getRed();
                        int gDiff = g - closestMatch.getGreen();
                        int bDiff = b - closestMatch.getBlue();
                        int[] tempXs = new int[]{j + 1, j - 1, j, j + 1};
                        int[] nArray = new int[4];
                        nArray[1] = 1;
                        nArray[2] = 1;
                        nArray[3] = 1;
                        int[] tempYs = nArray;
                        double[] multipliers = new double[]{0.4375, 0.1875, 0.3125, 0.0625};
                        int k = 0;
                        while (k < tempXs.length) {
                            int tempY = tempYs[k];
                            int tempX = tempXs[k];
                            if (tempY < h && tempX < w && tempX > 0) {
                                int[] nArray2 = ditherData[tempY];
                                int n = tempX * 3 + 0;
                                nArray2[n] = (int)((double)nArray2[n] + multipliers[k] * (double)rDiff);
                                int[] nArray3 = ditherData[tempY];
                                int n3 = tempX * 3 + 1;
                                nArray3[n3] = (int)((double)nArray3[n3] + multipliers[k] * (double)gDiff);
                                int[] nArray4 = ditherData[tempY];
                                int n4 = tempX * 3 + 2;
                                nArray4[n4] = (int)((double)nArray4[n4] + multipliers[k] * (double)bDiff);
                            }
                            ++k;
                        }
                    }
                } else {
                    usedMaterials[i][j] = -1;
                }
                ++j;
            }
            ++i;
        }
        return new Blueprint(usedMaterials, this.materialSet, this.sideView);
    }

    private static Dimension getNewImageSize(BufferedImage image, int maxWidth, int maxHeight) {
        int h = image.getHeight();
        int w = image.getWidth();
        if (maxHeight > 0 && h > maxHeight) {
            w = Math.round((float)w * ((float)maxHeight / (float)h));
            h = maxHeight;
        }
        if (maxWidth > 0 && w > maxWidth) {
            h = Math.round((float)h * ((float)maxWidth / (float)w));
            w = maxWidth;
        }
        return new Dimension(w, h);
    }

    private static BufferedImage resizeImage(BufferedImage image, int maxWidth, int maxHeight) {
        Dimension dim = Generator.getNewImageSize(image, maxWidth, maxHeight);
        int h = dim.height;
        int w = dim.width;
        if (h != image.getHeight() || w != image.getWidth()) {
            return Utils.resizeImage(image, w, h);
        }
        return image;
    }

    public static enum DitherOption {
        Off,
        On,
        Auto;

    }
}

