/*
 * Decompiled with CFR 0.152.
 */
package com.diamondpants.spritecraft;

import com.diamondpants.spritecraft.Generator;
import com.diamondpants.spritecraft.Utils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Material {
    private String name;
    private MaterialType type;
    private boolean useByDefault;
    private int blockID;
    private int blockData;
    private boolean use;
    private String imageName;
    private boolean hasTop;
    private String topImageName;
    private BufferedImage origSideImage;
    private BufferedImage origTopImage;
    private BufferedImage resizedSideImage;
    private BufferedImage resizedTopImage;
    private Color avgSideColor;
    private Color avgTopColor;
    private static final String RESOURCEPATH = "/com/diamondpants/spritecraft/images/textures/blocks/";

    public Material(String name, MaterialType type, int blockID, int blockData, boolean useByDefault, String blockImage, boolean hasTopImage, String topImageName) {
        if (blockData < 0) {
            blockData = 0;
        }
        this.name = name;
        this.type = type;
        this.blockID = blockID;
        this.blockData = blockData;
        this.useByDefault = useByDefault;
        this.use = useByDefault;
        this.imageName = blockImage;
        this.hasTop = hasTopImage;
        this.topImageName = topImageName;
    }

    public void reloadImages(String resourcePackFolder) throws IOException {
        BufferedImage origSide = this.getResourceImage(resourcePackFolder, this.imageName);
        BufferedImage origTop = this.hasTop ? this.getResourceImage(resourcePackFolder, this.topImageName) : null;
        this.origSideImage = new BufferedImage(origSide.getWidth(), origSide.getHeight(), 5);
        this.origTopImage = this.hasTop ? new BufferedImage(origTop.getWidth(), origTop.getHeight(), 5) : null;
        this.avgSideColor = Material.computeAvgColorAndCopy(origSide, this.origSideImage);
        this.avgTopColor = this.hasTop ? Material.computeAvgColorAndCopy(origTop, this.origTopImage) : null;
        this.resizedSideImage = this.origSideImage;
        this.resizedTopImage = this.origTopImage;
    }

    private BufferedImage getResourceImage(String resourcePackFolder, String imageName) throws IOException {
        if (resourcePackFolder != null) {
            File imageFile = new File(String.valueOf(resourcePackFolder) + File.separator + imageName);
            if (imageFile.exists()) {
                return ImageIO.read(imageFile);
            }
            System.out.println("No resource pack image found for " + imageName + ", using the default instead.");
        }
        return ImageIO.read(Generator.class.getResource(RESOURCEPATH + imageName));
    }

    private BufferedImage resizeIfNecessary(BufferedImage origFullSize, BufferedImage origResized, int maxWidth) {
        if (origFullSize.getWidth() == maxWidth && origFullSize.getHeight() == maxWidth) {
            return origFullSize;
        }
        if (origResized.getWidth() == maxWidth && origResized.getHeight() == maxWidth) {
            return origResized;
        }
        return Utils.resizeImage(origFullSize, maxWidth, maxWidth);
    }

    public boolean getUse() {
        return this.use;
    }

    public void setUse(boolean use) {
        this.use = use;
    }

    public String getName() {
        return this.name;
    }

    public MaterialType getType() {
        return this.type;
    }

    public boolean getUseByDefault() {
        return this.useByDefault;
    }

    public int getBlockID() {
        return this.blockID;
    }

    public int getBlockData() {
        return this.blockData;
    }

    public String getImageName() {
        return this.imageName;
    }

    public boolean getHasTop() {
        return this.hasTop;
    }

    public String getTopImageName() {
        return this.topImageName;
    }

    public BufferedImage getImage(boolean side) {
        return this.getImage(side, 0);
    }

    public BufferedImage getImage(boolean side, int squareWidth) {
        if (squareWidth > 0) {
            if (side || !this.hasTop) {
                this.resizedSideImage = this.resizeIfNecessary(this.origSideImage, this.resizedSideImage, squareWidth);
                return this.resizedSideImage;
            }
            this.resizedTopImage = this.resizeIfNecessary(this.origTopImage, this.resizedTopImage, squareWidth);
            return this.resizedTopImage;
        }
        if (side || !this.hasTop) {
            return this.origSideImage;
        }
        return this.origTopImage;
    }

    public BufferedImage getResizedImage(boolean side) {
        if (side || !this.hasTop) {
            return this.resizedSideImage;
        }
        return this.resizedTopImage;
    }

    public int getOrigSquareWidth(boolean side) {
        if (side || !this.hasTop) {
            return Math.min(this.origSideImage.getWidth(), this.origSideImage.getHeight());
        }
        return Math.min(this.origTopImage.getWidth(), this.origTopImage.getHeight());
    }

    public Color getAvgColor(boolean side) {
        if (this.hasTop) {
            return side ? this.avgSideColor : this.avgTopColor;
        }
        return this.avgSideColor;
    }

    public static Color computeAvgColorAndCopy(BufferedImage orig, BufferedImage copyTo) {
        int w = orig.getWidth();
        int h = orig.getHeight();
        long rTotal = 0L;
        long gTotal = 0L;
        long bTotal = 0L;
        int total = 0;
        int i = 0;
        while (i < h) {
            int j = 0;
            while (j < w) {
                int rgb = orig.getRGB(j, i);
                copyTo.setRGB(j, i, rgb);
                if ((rgb >> 24 & 0xFF) != 0) {
                    rTotal += (long)(rgb >> 16 & 0xFF);
                    gTotal += (long)(rgb >> 8 & 0xFF);
                    bTotal += (long)(rgb & 0xFF);
                    ++total;
                }
                ++j;
            }
            ++i;
        }
        int r = (int)Math.round((double)rTotal / (double)total);
        int g = (int)Math.round((double)gTotal / (double)total);
        int b = (int)Math.round((double)bTotal / (double)total);
        return new Color(r, g, b);
    }

    public static enum MaterialType {
        Common,
        Rare,
        Wool,
        Clay,
        Unusual,
        Special;

    }
}

