/*
 * Decompiled with CFR 0.152.
 */
package com.diamondpants.spritecraft;

import com.diamondpants.spritecraft.Material;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;

public class MaterialSet {
    private Vector<Material> materials = new Vector();
    private String resourcePackPath = null;
    private static final String TEXTUREPATH = String.valueOf(File.separator) + "assets" + File.separator + "minecraft" + File.separator + "textures" + File.separator + "blocks" + File.separator;

    public MaterialSet() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/com/diamondpants/spritecraft/Materials.txt")));
        String line = reader.readLine();
        while (line != null) {
            String[] lineSplit = line.split(",");
            int blockID = Integer.parseInt(lineSplit[3]);
            int blockData = Integer.parseInt(lineSplit[4]);
            String blockImage = lineSplit[5];
            boolean hasTopImage = Boolean.parseBoolean(lineSplit[6]);
            String topImage = hasTopImage ? lineSplit[7] : null;
            this.materials.add(new Material(lineSplit[0], Material.MaterialType.valueOf(lineSplit[1]), blockID, blockData, Boolean.parseBoolean(lineSplit[2]), blockImage, hasTopImage, topImage));
            line = reader.readLine();
        }
        reader.close();
        this.refreshMaterials();
    }

    private void refreshMaterials() throws IOException {
        for (Material material : this.materials) {
            material.reloadImages(this.resourcePackPath);
        }
    }

    public Vector<Material> getMaterials() {
        return this.materials;
    }

    public Material getMaterialByName(String name) {
        for (Material material : this.materials) {
            if (!material.getName().equals(name)) continue;
            return material;
        }
        return null;
    }

    public void setTerrainURL(String terrainURL) {
        this.resourcePackPath = String.valueOf(terrainURL) + TEXTUREPATH;
        try {
            this.refreshMaterials();
        }
        catch (Exception e) {
            System.out.println("Tried my best to refresh the MaterialSet to the new resource pack... honest I did!");
            e.printStackTrace();
            this.resourcePackPath = null;
            try {
                this.refreshMaterials();
            }
            catch (Exception e2) {
                System.out.println("Okay that should have been impossible... uh... monkeys!");
                e2.printStackTrace();
            }
        }
    }

    public int getUsedMaterialCount() {
        int count = 0;
        int i = 0;
        while (i < this.materials.size()) {
            if (this.materials.get(i).getUse()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public byte findBestMatch(int r, int g, int b, boolean sideView) {
        int bestMatchIndex = -1;
        int bestDiff = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.materials.size()) {
            Color c;
            int diff;
            Material material = this.materials.get(i);
            if (material.getUse() && (diff = Math.abs((c = material.getAvgColor(sideView)).getRed() - r) * Math.abs(c.getRed() - r) + Math.abs(c.getGreen() - g) * Math.abs(c.getGreen() - g) + Math.abs(c.getBlue() - b) * Math.abs(c.getBlue() - b)) < bestDiff) {
                bestMatchIndex = i;
                bestDiff = diff;
            }
            i = (byte)(i + 1);
        }
        return (byte)bestMatchIndex;
    }

    public void setDefaults() {
        this.setAll(true);
    }

    public void setAll() {
        this.setAll(false);
    }

    private void setAll(boolean defaults) {
        for (Material material : this.materials) {
            material.setUse(defaults ? material.getUseByDefault() : true);
        }
    }
}

