/*
 * Decompiled with CFR 0.152.
 */
package com.diamondpants.spritecraft.frontend;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class CheckBoxedBorder
implements Border {
    private JCheckBox checkBox;
    private Border etchedBorder;
    private Container container;
    private Rectangle rect;
    private int offset = 5;
    private int xInset = 8;
    private int yInset;

    public CheckBoxedBorder(String title, Container container) {
        this.checkBox = new JCheckBox(title);
        this.container = container;
        this.etchedBorder = BorderFactory.createTitledBorder("");
        container.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent me) {
                CheckBoxedBorder.this.doMouseEvent(me);
            }

            @Override
            public void mouseEntered(MouseEvent me) {
                CheckBoxedBorder.this.doMouseEvent(me);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                CheckBoxedBorder.this.doMouseEvent(me);
            }

            @Override
            public void mousePressed(MouseEvent me) {
                CheckBoxedBorder.this.doMouseEvent(me);
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                CheckBoxedBorder.this.doMouseEvent(me);
            }
        });
        this.yInset = this.checkBox.getPreferredSize().height + 2;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.yInset, this.xInset, this.yInset, this.xInset);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.etchedBorder.paintBorder(c, g, x + this.xInset / 2, y + this.yInset / 2, width - this.xInset, height - this.yInset);
        Dimension size = this.checkBox.getPreferredSize();
        this.rect = new Rectangle(this.xInset / 2 + this.offset, this.yInset / 2 - size.height / 2, size.width, size.height);
        SwingUtilities.paintComponent(g, this.checkBox, (Container)c, this.rect);
    }

    private void doMouseEvent(MouseEvent me) {
        if (this.rect != null && this.rect.contains(me.getX(), me.getY())) {
            Point pt = me.getPoint();
            pt.translate(-this.offset, 0);
            this.checkBox.setBounds(this.rect);
            this.checkBox.dispatchEvent(new MouseEvent(this.checkBox, me.getID(), me.getWhen(), me.getModifiers(), pt.x, pt.y, me.getClickCount(), me.isPopupTrigger(), me.getButton()));
            this.container.repaint();
        }
    }

    public void addActionListener(ActionListener al) {
        this.checkBox.addActionListener(al);
    }

    public boolean isSelected() {
        return this.checkBox.isSelected();
    }

    public void setSelected(boolean selected) {
        this.checkBox.setSelected(selected);
        this.container.repaint();
    }
}

