/*
 * Decompiled with CFR 0.152.
 */
package com.diamondpants.spritecraft.frontend;

import com.diamondpants.spritecraft.Blueprint;
import com.diamondpants.spritecraft.Generator;
import com.diamondpants.spritecraft.ticators.Imageticator;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class CommandLineGuy {
    public static void runSpritecraftCommandLine(String[] args) {
        try {
            File inputFile = CommandLineGuy.getInputFile(args);
            File outputFile = CommandLineGuy.getOutputFile(args);
            Generator gen = CommandLineGuy.getGenerator(args);
            boolean allowOverwrite = CommandLineGuy.getAllowOverwrite(args);
            if (CommandLineGuy.isValid(inputFile, outputFile, gen, allowOverwrite)) {
                System.out.println("Generating image...");
                Blueprint blueprint = gen.run(ImageIO.read(inputFile));
                BufferedImage image = Imageticator.imageticate(blueprint, false);
                ImageIO.write((RenderedImage)image, "png", outputFile);
                System.out.println("Finished!");
                return;
            }
            CommandLineGuy.displayUsageInfo();
        }
        catch (Exception ex) {
            CommandLineGuy.displayUsageInfo();
            System.out.println("Error: " + ex.getMessage());
        }
    }

    private static File getInputFile(String[] args) {
        if (args.length > 1) {
            return CommandLineGuy.getFileFromCommandLineInput(args[args.length - 2]);
        }
        return null;
    }

    private static File getOutputFile(String[] args) {
        if (args.length > 0) {
            return CommandLineGuy.getFileFromCommandLineInput(args[args.length - 1]);
        }
        return null;
    }

    private static File getFileFromCommandLineInput(String input) {
        if (input.startsWith("\"") && input.endsWith("\"")) {
            input = input.substring(1, input.length() - 1);
        }
        return new File(input);
    }

    private static Generator getGenerator(String[] args) throws IOException {
        Generator gen = new Generator();
        gen.setDither(CommandLineGuy.getDither(args));
        gen.setMaxHeight(CommandLineGuy.getMaxHeight(args, gen));
        gen.setMaxWidth(CommandLineGuy.getMaxWidth(args, gen));
        gen.setSideView(CommandLineGuy.getSideView(args));
        return gen;
    }

    private static Generator.DitherOption getDither(String[] args) {
        int i = 0;
        while (i < args.length - 2) {
            if (args[i].startsWith("-d")) {
                int value = Integer.parseInt(args[i].substring(2));
                if (value == 1) {
                    return Generator.DitherOption.On;
                }
                if (value == 2) {
                    return Generator.DitherOption.Off;
                }
                return Generator.DitherOption.Auto;
            }
            ++i;
        }
        return Generator.DitherOption.Auto;
    }

    private static int getMaxHeight(String[] args, Generator gen) {
        int i = 0;
        while (i < args.length - 2) {
            if (args[i].startsWith("-h")) {
                return Integer.parseInt(args[i].substring(2));
            }
            ++i;
        }
        return gen.getMaxHeight();
    }

    private static int getMaxWidth(String[] args, Generator gen) {
        int i = 0;
        while (i < args.length - 2) {
            if (args[i].startsWith("-w")) {
                return Integer.parseInt(args[i].substring(2));
            }
            ++i;
        }
        return gen.getMaxWidth();
    }

    private static boolean getSideView(String[] args) {
        int i = 0;
        while (i < args.length - 2) {
            if (args[i].equals("-s")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean getAllowOverwrite(String[] args) {
        int i = 0;
        while (i < args.length - 2) {
            if (args[i].equals("-o")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isValid(File inputFile, File outputFile, Generator gen, boolean allowOverwrite) {
        return inputFile != null && inputFile.exists() && outputFile != null && (!outputFile.exists() || allowOverwrite);
    }

    private static void displayUsageInfo() {
        String jarName = "SpritecraftFull.jar";
        System.out.println();
        System.out.println();
        System.out.println("Usage:");
        System.out.println(" java -jar -Xmx1024m " + jarName + " [-o] [-d] [-h] [-w] [-s] \"pathToInputFile\" \"pathToOutputFile\" ");
        System.out.println();
        System.out.println("  -o: Automatically overwrite the output file.");
        System.out.println("  -d: Use to set dither to Auto (-d0), On (-d1), or Off (-d2).");
        System.out.println("  -h: Use to set the max height. Ex: -h1000 means max height of 1000 pixels.");
        System.out.println("  -w: Use to set the max width. Ex: -h1000 means max width of 1000 pixels.");
        System.out.println("  -s: Use side view instead of top view.");
    }
}

