/*
 * Decompiled with CFR 0.152.
 */
package com.diamondpants.spritecraft.frontend;

import com.diamondpants.spritecraft.Utils;
import com.diamondpants.spritecraft.frontend.ImageManager;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private static final long serialVersionUID = -3811340292101949463L;
    private BufferedImage image;
    private Vector<BufferedImage> smallerImages;
    private double maxZoomLevel = 30.0;
    private double minZoomLevel = 0.0;
    private double zoomLevel = 1.0;
    private boolean fitToSize = true;
    private int imageX;
    private int imageY;
    private Point initialDragPoint;
    private int initialImageX;
    private int initialImageY;
    private boolean optimizeForLargeImages;
    private int smallImageDivideSize = 2;

    public ImagePanel(boolean optimizeForLargeImages) {
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createLineBorder(Color.gray));
        com.diamondpants.helpfulstuff.Utils.setCursorFromImage(ImageManager.getHandOpen().getImage(), this);
        this.optimizeForLargeImages = optimizeForLargeImages;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                com.diamondpants.helpfulstuff.Utils.setCursorFromImage(ImageManager.getHandOpen().getImage(), ImagePanel.this);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ImagePanel.this.initialDragPoint = e.getPoint();
                ImagePanel.this.initialImageX = ImagePanel.this.imageX;
                ImagePanel.this.initialImageY = ImagePanel.this.imageY;
                com.diamondpants.helpfulstuff.Utils.setCursorFromImage(ImageManager.getHandClosed().getImage(), ImagePanel.this);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int notches = e.getWheelRotation();
                ImagePanel.this.fitToSize = false;
                Point panelPoint = e.getPoint();
                Point imagePoint = ImagePanel.this.getPointOnImage(panelPoint, EstimateProp.Round);
                if (notches < 0) {
                    ImagePanel imagePanel = ImagePanel.this;
                    imagePanel.zoomLevel = imagePanel.zoomLevel * (1.0 - (double)notches * 0.2);
                } else {
                    ImagePanel imagePanel = ImagePanel.this;
                    imagePanel.zoomLevel = imagePanel.zoomLevel / (1.0 + (double)notches * 0.2);
                }
                ImagePanel.this.restrictZoom();
                ImagePanel.this.imageX = (int)Math.round((double)panelPoint.x - (double)imagePoint.x * ImagePanel.this.zoomLevel);
                ImagePanel.this.imageY = (int)Math.round((double)panelPoint.y - (double)imagePoint.y * ImagePanel.this.zoomLevel);
                ImagePanel.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                ImagePanel.this.fitToSize = false;
                Point point = e.getPoint();
                ImagePanel.this.imageX = ImagePanel.this.initialImageX - (((ImagePanel)ImagePanel.this).initialDragPoint.x - point.x);
                ImagePanel.this.imageY = ImagePanel.this.initialImageY - (((ImagePanel)ImagePanel.this).initialDragPoint.y - point.y);
                ImagePanel.this.repaint();
            }
        });
    }

    private void restrictZoom() {
        this.zoomLevel = this.zoomLevel > this.maxZoomLevel ? this.maxZoomLevel : (this.zoomLevel < this.minZoomLevel ? this.minZoomLevel : this.zoomLevel);
    }

    private Point getPointOnImage(Point pointOnPanel, EstimateProp prop) {
        if (prop == EstimateProp.Ceil) {
            return new Point((int)Math.ceil((double)(pointOnPanel.x - this.imageX) / this.zoomLevel), (int)Math.ceil((double)(pointOnPanel.y - this.imageY) / this.zoomLevel));
        }
        if (prop == EstimateProp.Floor) {
            return new Point((int)Math.floor((double)(pointOnPanel.x - this.imageX) / this.zoomLevel), (int)Math.floor((double)(pointOnPanel.y - this.imageY) / this.zoomLevel));
        }
        return new Point((int)Math.round((double)(pointOnPanel.x - this.imageX) / this.zoomLevel), (int)Math.round((double)(pointOnPanel.y - this.imageY) / this.zoomLevel));
    }

    private Point getPointOnPanel(Point pointOnImage) {
        return new Point((int)Math.round((double)pointOnImage.x * this.zoomLevel + (double)this.imageX), (int)Math.round((double)pointOnImage.y * this.zoomLevel + (double)this.imageY));
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        if (this.optimizeForLargeImages) {
            this.smallerImages = new Vector();
            BufferedImage current = image;
            while (current.getWidth() * current.getHeight() > 100000) {
                current = Utils.resizeImage(current, Math.round((float)current.getWidth() / (float)this.smallImageDivideSize), Math.round((float)current.getHeight() / (float)this.smallImageDivideSize));
                this.smallerImages.add(current);
            }
        }
        int numICareAbout = Math.max(image.getWidth(), image.getHeight());
        this.minZoomLevel = 100.0 / (double)numICareAbout;
        if (this.minZoomLevel > 1.0) {
            this.minZoomLevel = 1.0;
        }
        this.fitToSize = true;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        double origW = this.image.getWidth(null);
        double origH = this.image.getHeight(null);
        if (this.fitToSize) {
            double wRatio = (double)this.getWidth() / origW;
            double hRatio = (double)this.getHeight() / origH;
            this.zoomLevel = hRatio < wRatio ? hRatio : wRatio;
            this.restrictZoom();
            int tempW = (int)(origW * this.zoomLevel);
            int tempH = (int)(origH * this.zoomLevel);
            this.imageX = (this.getWidth() - tempW) / 2;
            this.imageY = (this.getHeight() - tempH) / 2;
        }
        int w = (int)(origW * this.zoomLevel);
        int h = (int)(origH * this.zoomLevel);
        if (this.optimizeForLargeImages) {
            Point showingStart = this.getPointOnImage(new Point(0, 0), EstimateProp.Floor);
            showingStart.x = showingStart.x < 0 ? 0 : showingStart.x;
            showingStart.y = showingStart.y < 0 ? 0 : showingStart.y;
            Point showingEnd = this.getPointOnImage(new Point(this.getWidth(), this.getHeight()), EstimateProp.Ceil);
            showingEnd.x = (double)showingEnd.x > origW ? (int)origW : showingEnd.x;
            int n = showingEnd.y = (double)showingEnd.y > origH ? (int)origH : showingEnd.y;
            if (!((double)showingStart.x >= origW) && !((double)showingStart.y >= origH) && showingEnd.x > 0 && showingEnd.y > 0) {
                BufferedImage toUse = this.image;
                int divideAmount = 1;
                int i = 0;
                while (this.zoomLevel <= 1.0 / (double)divideAmount / (double)this.smallImageDivideSize && i < this.smallerImages.size()) {
                    toUse = this.smallerImages.get(i);
                    divideAmount *= this.smallImageDivideSize;
                    ++i;
                }
                BufferedImage subImage = toUse.getSubimage(showingStart.x / divideAmount, showingStart.y / divideAmount, (showingEnd.x - showingStart.x) / divideAmount, (showingEnd.y - showingStart.y) / divideAmount);
                Point drawStart = this.getPointOnPanel(showingStart);
                Point drawEnd = this.getPointOnPanel(showingEnd);
                if (i != 0 || this.zoomLevel < 1.0) {
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                g.drawImage(subImage, drawStart.x, drawStart.y, drawEnd.x - drawStart.x, drawEnd.y - drawStart.y, null);
            }
        } else {
            if (this.zoomLevel < 1.0) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            g.drawImage(this.image, this.imageX, this.imageY, w, h, null);
        }
    }

    private static enum EstimateProp {
        Floor,
        Ceil,
        Round;

    }
}

