/*
 * Decompiled with CFR 0.152.
 */
package com.diamondpants.spritecraft.frontend;

import com.diamondpants.helpfulstuff.Utils;
import com.diamondpants.spritecraft.Blueprint;
import com.diamondpants.spritecraft.Generator;
import com.diamondpants.spritecraft.Material;
import com.diamondpants.spritecraft.frontend.HelpLabel;
import com.diamondpants.spritecraft.frontend.ImageFilter;
import com.diamondpants.spritecraft.frontend.ImageManager;
import com.diamondpants.spritecraft.frontend.ImagePanel;
import com.diamondpants.spritecraft.frontend.NewVersionPopupDialog;
import com.diamondpants.spritecraft.frontend.OptionsFrame;
import com.diamondpants.spritecraft.frontend.PreviewDialog;
import com.diamondpants.spritecraft.frontend.SizeRememberingFrame;
import com.diamondpants.spritecraft.frontend.StateKeeper;
import com.diamondpants.spritecraft.frontend.UpdateChecker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MainFrame
extends SizeRememberingFrame {
    private static final long serialVersionUID = -7570948954820807188L;
    private ImagePanel imagePanel;
    private JLabel imageNameLabel;
    private JSpinner maxWidthSpinner;
    private JCheckBox noMaxWidthCheckBox;
    private JSpinner maxHeightSpinner;
    private JCheckBox noMaxHeightCheckBox;
    private JComboBox<String> maxHeightComboBox;
    private Generator gen;
    private OptionsFrame optionsFrame;
    public static boolean TESTIMAGEMODE = false;
    private int majorVerNum = 1;
    private int minorVerNum = 1;
    private int revNum = 4;

    public MainFrame() throws IOException {
        super("MainFrame", new Dimension(640, 480));
        if (UpdateChecker.checkHasUpdate(this.majorVerNum, this.minorVerNum, this.revNum)) {
            NewVersionPopupDialog.showDialog();
        }
        this.setTitle("Spritecraft v" + this.majorVerNum + "." + this.minorVerNum + "." + this.revNum + " " + "Full Version");
        this.setIconImage(ImageManager.getIcon().getImage());
        this.gen = new Generator();
        this.setValuesFromPreferences();
        JLabel headerLabel = new JLabel("Select an image to create a Minecraft blueprint!");
        headerLabel.setFont(new Font(headerLabel.getFont().getName(), headerLabel.getFont().getStyle(), headerLabel.getFont().getSize() + 6));
        JButton optionsButton = new JButton("Options");
        optionsButton.setEnabled(true);
        optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (MainFrame.this.optionsFrame == null) {
                    MainFrame.this.optionsFrame = new OptionsFrame(MainFrame.this, MainFrame.this.gen);
                }
                MainFrame.this.optionsFrame.setVisible(true);
            }
        });
        JLabel saysImageLabel = new JLabel("Image:");
        saysImageLabel.setFont(new Font(saysImageLabel.getFont().getName(), 1, saysImageLabel.getFont().getSize()));
        this.imageNameLabel = new JLabel();
        JButton imageBrowseButton = new JButton("Browse");
        imageBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JFileChooser chooser = new JFileChooser();
                ImageFilter filter = new ImageFilter();
                chooser.addChoosableFileFilter(filter);
                chooser.setFileFilter(filter);
                chooser.setMultiSelectionEnabled(false);
                if (StateKeeper.getLastImageDir() != null) {
                    chooser.setCurrentDirectory(new File(StateKeeper.getLastImageDir()));
                }
                if (chooser.showOpenDialog(MainFrame.this) == 0) {
                    File file = chooser.getSelectedFile();
                    StateKeeper.setLastImageDir(file.getParentFile().getAbsolutePath());
                    try {
                        BufferedImage image = ImageIO.read(file);
                        MainFrame.this.setImage(file.getName(), image);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(MainFrame.this, "Whoops... uh, sorry, but something bad just happened: " + ex.getMessage(), "Whoops!", 0);
                    }
                }
            }
        });
        this.imagePanel = new ImagePanel(false);
        JPanel maximumsPanel = this.setupMaxHeightAndWidthPanel();
        JButton createButton = new JButton("Create Minecraft Blueprint!");
        createButton.setFont(new Font(createButton.getFont().getName(), createButton.getFont().getStyle(), createButton.getFont().getSize() + 7));
        createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    if (MainFrame.this.gen.getMaterialSet().getUsedMaterialCount() == 0) {
                        JOptionPane.showMessageDialog(MainFrame.this, "No materials selected (click \"Options\" to add some)", "No Materials", 0);
                    } else {
                        Blueprint blueprint = MainFrame.this.gen.run(MainFrame.this.imagePanel.getImage());
                        PreviewDialog dialog = new PreviewDialog(blueprint, MainFrame.this);
                        dialog.setModal(true);
                        dialog.setVisible(true);
                        Runtime.getRuntime().gc();
                    }
                }
                catch (OutOfMemoryError ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(MainFrame.this, "Uh-oh, out of memory error!", "Out of Memory", 0);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(MainFrame.this, "Whoops... uh, sorry, but something bad just happened: " + ex.getMessage(), "Whoops!", 0);
                }
            }
        });
        JPanel headerPanel = new JPanel(new FlowLayout(0));
        headerPanel.add(headerLabel);
        JPanel optionsButtonPanel = new JPanel(new FlowLayout(2));
        if (TESTIMAGEMODE) {
            optionsButtonPanel.add(this.createImageTestButton());
        }
        optionsButtonPanel.add(optionsButton);
        JPanel headerAndOptionsPanel = new JPanel(new BorderLayout());
        headerAndOptionsPanel.add((Component)headerPanel, "West");
        headerAndOptionsPanel.add((Component)optionsButtonPanel, "East");
        JPanel imageSelectionPanel = new JPanel(new FlowLayout(0));
        imageSelectionPanel.add(saysImageLabel);
        imageSelectionPanel.add(this.imageNameLabel);
        imageSelectionPanel.add(imageBrowseButton);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)headerAndOptionsPanel, "North");
        topPanel.add((Component)imageSelectionPanel, "South");
        JPanel maxWrapperPanel = new JPanel(new BorderLayout());
        maxWrapperPanel.add((Component)maximumsPanel, "West");
        maxWrapperPanel.add((Component)new JPanel(), "Center");
        JPanel createButtonPanel = new JPanel(new FlowLayout(1));
        createButtonPanel.add(createButton);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)maxWrapperPanel, "North");
        bottomPanel.add((Component)createButtonPanel, "South");
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)topPanel, "North");
        mainPanel.add((Component)this.imagePanel, "Center");
        mainPanel.add((Component)bottomPanel, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)mainPanel, "Center");
        this.getContentPane().add((Component)Utils.createFillerPanel(5, 0), "East");
        this.getContentPane().add((Component)Utils.createFillerPanel(5, 0), "West");
        this.getContentPane().add((Component)Utils.createFillerPanel(0, 5), "South");
        try {
            this.setImage("spritecraftlogo.png", ImageIO.read(MainFrame.class.getResource("/com/diamondpants/spritecraft/frontend/images/spritecraftlogo.png")));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private JButton createImageTestButton() {
        JButton imageTestButton = new JButton("Gen Test Image");
        imageTestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.loadTestImage();
            }
        });
        return imageTestButton;
    }

    private void loadTestImage() {
        try {
            this.setImage("testimage.png", this.createTestImage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Whoops... uh, sorry, but something bad just happened: " + ex.getMessage(), "Whoops!", 0);
        }
    }

    private BufferedImage createTestImage() {
        Vector<Material> materials = this.getActiveMaterials();
        int width = (int)Math.ceil(Math.sqrt(materials.size()));
        BufferedImage image = new BufferedImage(width, (int)Math.ceil((double)materials.size() / (double)width), 6);
        int i = 0;
        while (i < materials.size()) {
            image.setRGB(i % width, i / width, materials.get(i).getAvgColor(this.gen.getSideView()).getRGB());
            ++i;
        }
        return image;
    }

    private Vector<Material> getActiveMaterials() {
        Vector<Material> materials = this.gen.getMaterialSet().getMaterials();
        Vector<Material> activeMaterials = new Vector<Material>();
        System.out.println("======  MATERIALS LIST BEFORE START  ======");
        for (Material material : materials) {
            if (!material.getUse()) continue;
            activeMaterials.add(material);
            System.out.println(material.getName());
        }
        System.out.println("====== MATERIALS LIST BEFORE IS DONE ======");
        return activeMaterials;
    }

    private JPanel setupMaxHeightAndWidthPanel() {
        return this.setupNormalMaxHeightAndWidthPanel();
    }

    private JPanel setupReducedFeatureMaxHeightAndWidthPanel() {
        this.maxHeightComboBox = new JComboBox<String>(new String[]{"30", "60"});
        if (this.gen.getMaxHeight() == 60) {
            this.maxHeightComboBox.setSelectedIndex(1);
        } else {
            this.maxHeightComboBox.setSelectedIndex(0);
        }
        this.maxHeightComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.gen.setMaxHeight(MainFrame.this.maxHeightComboBox.getSelectedIndex() == 0 ? 30 : 60);
                StateKeeper.setMaxHeight(MainFrame.this.gen.getMaxHeight());
            }
        });
        JLabel saysMaxHeightLabel = new JLabel("Max Height:");
        saysMaxHeightLabel.setFont(new Font(saysMaxHeightLabel.getFont().getName(), 1, saysMaxHeightLabel.getFont().getSize()));
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(saysMaxHeightLabel);
        panel.add(this.maxHeightComboBox);
        return panel;
    }

    private JPanel setupNormalMaxHeightAndWidthPanel() {
        int maxWidth = this.gen.getMaxWidth();
        int maxHeight = this.gen.getMaxHeight();
        boolean anyWidth = maxWidth <= 0;
        boolean anyHeight = maxHeight <= 0;
        JLabel saysMaxWidthLabel = new JLabel("Max Width:");
        saysMaxWidthLabel.setFont(new Font(saysMaxWidthLabel.getFont().getName(), 1, saysMaxWidthLabel.getFont().getSize()));
        this.maxWidthSpinner = new JSpinner(new SpinnerNumberModel(30, 1, 10000, 1));
        this.maxWidthSpinner.setValue(new Integer(anyWidth ? 30 : maxWidth));
        this.maxWidthSpinner.setEnabled(!anyWidth);
        this.maxWidthSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MainFrame.this.setMaxWidthFromUI();
            }
        });
        this.noMaxWidthCheckBox = new JCheckBox("No max width");
        this.noMaxWidthCheckBox.setSelected(anyWidth);
        this.noMaxWidthCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.setMaxWidthFromUI();
            }
        });
        HelpLabel maxWidthHelpLabel = new HelpLabel("<html>Set the maximum number of blocks to use. I mean... you aren't<br/><i>really</i> going to build that 500 by 500 block creation, right?</html>");
        JLabel saysMaxHeightLabel = new JLabel("Max Height:");
        saysMaxHeightLabel.setFont(new Font(saysMaxHeightLabel.getFont().getName(), 1, saysMaxHeightLabel.getFont().getSize()));
        this.maxHeightSpinner = new JSpinner(new SpinnerNumberModel(30, 1, 10000, 1));
        this.maxHeightSpinner.setValue(new Integer(anyHeight ? 30 : maxHeight));
        this.maxHeightSpinner.setEnabled(!anyHeight);
        this.maxHeightSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MainFrame.this.setMaxHeightFromUI();
            }
        });
        this.noMaxHeightCheckBox = new JCheckBox("No max height");
        this.noMaxHeightCheckBox.setSelected(anyHeight);
        this.noMaxHeightCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.setMaxHeightFromUI();
            }
        });
        HelpLabel maxHeightHelpLabel = new HelpLabel("<html>Set the maximum number of blocks to use. I mean... you aren't<br/><i>really</i> going to build that 500 by 500 block creation, right?</html>");
        JPanel maximumsPanel = new JPanel(new SpringLayout());
        maximumsPanel.add(saysMaxWidthLabel);
        maximumsPanel.add(this.maxWidthSpinner);
        maximumsPanel.add(this.noMaxWidthCheckBox);
        maximumsPanel.add(maxWidthHelpLabel);
        maximumsPanel.add(saysMaxHeightLabel);
        maximumsPanel.add(this.maxHeightSpinner);
        maximumsPanel.add(this.noMaxHeightCheckBox);
        maximumsPanel.add(maxHeightHelpLabel);
        Utils.makeCompactGrid(maximumsPanel, 2, 4, 5, 5, 5, 5);
        return maximumsPanel;
    }

    private void setMaxHeightFromUI() {
        this.gen.setMaxHeight(this.noMaxHeightCheckBox.isSelected() ? 0 : (Integer)this.maxHeightSpinner.getValue());
        this.maxHeightSpinner.setEnabled(!this.noMaxHeightCheckBox.isSelected());
        StateKeeper.setMaxHeight(this.gen.getMaxHeight());
    }

    private void setMaxWidthFromUI() {
        this.gen.setMaxWidth(this.noMaxWidthCheckBox.isSelected() ? 0 : (Integer)this.maxWidthSpinner.getValue());
        this.maxWidthSpinner.setEnabled(!this.noMaxWidthCheckBox.isSelected());
        StateKeeper.setMaxWidth(this.gen.getMaxWidth());
    }

    private void setValuesFromPreferences() {
        this.setValuesFromPreferencesNormalMode();
    }

    private void setValuesFromPreferencesReducedFeatureMode() {
        this.gen.setMaxHeight(StateKeeper.getMaxHeight() == 30 ? 30 : 60);
        this.gen.setMaxWidth(0);
    }

    private void setValuesFromPreferencesNormalMode() {
        this.gen.setSideView(StateKeeper.getSideView());
        if (StateKeeper.getDither() != null) {
            this.gen.setDither(Generator.DitherOption.valueOf(StateKeeper.getDither()));
        }
        for (Material material : this.gen.getMaterialSet().getMaterials()) {
            String materialString = StateKeeper.getUseMaterial(material.getName());
            if (materialString == null) continue;
            material.setUse(Boolean.parseBoolean(materialString));
        }
        this.gen.setMaxWidth(StateKeeper.getMaxWidth());
        this.gen.setMaxHeight(StateKeeper.getMaxHeight());
    }

    private void setImage(String name, BufferedImage image) {
        this.imagePanel.setImage(image);
        this.imageNameLabel.setText(name);
        this.repaint();
    }
}

