/*
 * Decompiled with CFR 0.152.
 */
package com.diamondpants.spritecraft.frontend;

import com.diamondpants.spritecraft.Material;
import com.diamondpants.spritecraft.frontend.IconPanel;
import com.diamondpants.spritecraft.frontend.StateKeeper;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class MaterialCheckBox
extends JPanel {
    private static final long serialVersionUID = 2417160019087607234L;
    private JCheckBox checkBox;
    private Material material;
    private IconPanel iconPanel;

    public MaterialCheckBox(Material material, boolean sideView) {
        this.material = material;
        this.checkBox = new JCheckBox(material.getName());
        this.checkBox.setSelected(material.getUse());
        this.checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MaterialCheckBox.this.setUsed();
            }
        });
        this.iconPanel = new IconPanel(material.getImage(sideView));
        this.setLayout(new FlowLayout(0));
        this.add(this.iconPanel);
        this.add(this.checkBox);
    }

    public boolean isSelected() {
        return this.checkBox.isSelected();
    }

    public void setSelected(boolean selected) {
        this.checkBox.setSelected(selected);
        this.setUsed();
    }

    private void setUsed() {
        this.material.setUse(this.checkBox.isSelected());
        this.persistUse();
    }

    public void refresh(boolean sideView) {
        if (this.material.getImage(sideView) != null) {
            this.iconPanel.setImage(this.material.getImage(sideView));
        }
        this.checkBox.setSelected(this.material.getUse());
    }

    public void persistUse() {
        StateKeeper.setUseMaterial(this.material.getUse(), this.material.getName());
    }

    public Material.MaterialType getMaterialType() {
        return this.material.getType();
    }

    public void addActionListener(ActionListener al) {
        this.checkBox.addActionListener(al);
    }
}

