/*
 * Decompiled with CFR 0.152.
 */
package com.diamondpants.spritecraft.frontend;

import com.diamondpants.spritecraft.Generator;
import com.diamondpants.spritecraft.Material;
import com.diamondpants.spritecraft.frontend.CheckBoxedBorder;
import com.diamondpants.spritecraft.frontend.MaterialCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class MaterialsPanel
extends JPanel {
    private static final long serialVersionUID = 3392843909371664076L;
    private Generator generator;
    private LinkedList<MaterialCheckBox> materialCheckBoxes;
    private LinkedList<ActionListener> actionListeners;
    private CheckBoxedBorder checkBoxedBorder;
    private JPanel innerPanel;

    public MaterialsPanel(Generator generator, Material.MaterialType materialType) {
        this.generator = generator;
        this.materialCheckBoxes = new LinkedList();
        this.actionListeners = new LinkedList();
        this.innerPanel = new JPanel();
        this.innerPanel.setLayout(new BoxLayout(this.innerPanel, 1));
        this.checkBoxedBorder = new CheckBoxedBorder(this.getMaterialTypeName(materialType), this.innerPanel);
        this.checkBoxedBorder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MaterialsPanel.this.setSelected(MaterialsPanel.this.checkBoxedBorder.isSelected());
                MaterialsPanel.this.fireActionPerformed();
            }
        });
        this.innerPanel.setBorder(this.checkBoxedBorder);
        for (Material material : generator.getMaterialSet().getMaterials()) {
            if (material.getType() != materialType) continue;
            MaterialCheckBox checkBox = new MaterialCheckBox(material, generator.getSideView());
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    MaterialsPanel.this.updateAllCheckBox();
                    MaterialsPanel.this.fireActionPerformed();
                }
            });
            this.materialCheckBoxes.add(checkBox);
            this.innerPanel.add(checkBox);
        }
        this.updateAllCheckBox();
        this.setLayout(new BorderLayout());
        this.add((Component)this.innerPanel, "North");
    }

    public boolean isSelected() {
        return this.checkBoxedBorder.isSelected();
    }

    public void setSelected(boolean select) {
        this.checkBoxedBorder.setSelected(select);
        for (MaterialCheckBox checkBox : this.materialCheckBoxes) {
            checkBox.setSelected(select);
        }
    }

    public void persistUse() {
        for (MaterialCheckBox checkBox : this.materialCheckBoxes) {
            checkBox.persistUse();
        }
    }

    public void refresh() {
        for (MaterialCheckBox checkBox : this.materialCheckBoxes) {
            checkBox.refresh(this.generator.getSideView());
        }
    }

    public void addActionListener(ActionListener al) {
        this.actionListeners.add(al);
    }

    private void updateAllCheckBox() {
        boolean allChecked = true;
        for (MaterialCheckBox materialCheckBox : this.materialCheckBoxes) {
            if (materialCheckBox.isSelected()) continue;
            allChecked = false;
            break;
        }
        this.checkBoxedBorder.setSelected(allChecked);
    }

    private void fireActionPerformed() {
        for (ActionListener al : this.actionListeners) {
            al.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    private String getMaterialTypeName(Material.MaterialType materialType) {
        switch (materialType) {
            case Common: {
                return "Common";
            }
            case Rare: {
                return "Rare";
            }
            case Wool: {
                return "Wool";
            }
            case Clay: {
                return "Clay";
            }
            case Unusual: {
                return "Unusual";
            }
            case Special: {
                return "Special";
            }
        }
        return "Unknown Material Type";
    }
}

