/*
 * Decompiled with CFR 0.152.
 */
package com.diamondpants.spritecraft.frontend;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class NewVersionPopupDialog
extends JDialog {
    private static final long serialVersionUID = -7809164037733915701L;

    private NewVersionPopupDialog() {
        this.setModal(true);
        this.setResizable(false);
        this.setTitle("There is a newer version of spritecraft available");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getInfoIconLabel(), "West");
        this.getContentPane().add((Component)this.getMessageLabel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(this.getAwesomeEnoughButton());
        buttonPanel.add(this.getIWantItNowButton());
        return buttonPanel;
    }

    private JLabel getInfoIconLabel() {
        JLabel infoIconLabel = new JLabel(UIManager.getIcon("OptionPane.informationIcon"));
        this.addEmptyBorder(infoIconLabel, 10);
        return infoIconLabel;
    }

    private JLabel getMessageLabel() {
        JLabel messageLabel = new JLabel("<html>A newer version of <b>Spritecraft</b> is available. It might even have new features! You should totally go get it!</html>");
        this.addEmptyBorder(messageLabel, 10);
        return messageLabel;
    }

    private JButton getIWantItNowButton() {
        JButton iWantItButton = new JButton("I Must Have It Now!");
        iWantItButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewVersionPopupDialog.this.iWantItNowButtonPressed();
            }
        });
        return iWantItButton;
    }

    private JButton getAwesomeEnoughButton() {
        JButton awesomeEnoughButton = new JButton("This Version is Already Awesome Enough");
        awesomeEnoughButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewVersionPopupDialog.this.awesomeEnoughButtonPressed();
            }
        });
        return awesomeEnoughButton;
    }

    private void iWantItNowButtonPressed() {
        try {
            String url = "http://www.diamondpants.com/spritecraft";
            Desktop.getDesktop().browse(URI.create(url));
            System.exit(0);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Encountered an error trying to open the web page: " + ex.getMessage());
            this.setVisible(false);
        }
    }

    private void awesomeEnoughButtonPressed() {
        this.setVisible(false);
    }

    private void addEmptyBorder(JComponent component, int amount) {
        component.setBorder(BorderFactory.createEmptyBorder(amount, amount, amount, amount));
    }

    public static void showDialog() {
        NewVersionPopupDialog dialog = new NewVersionPopupDialog();
        dialog.setVisible(true);
    }
}

