/*
 * Decompiled with CFR 0.152.
 */
package com.diamondpants.spritecraft.frontend;

import com.diamondpants.helpfulstuff.Utils;
import com.diamondpants.spritecraft.Generator;
import com.diamondpants.spritecraft.Material;
import com.diamondpants.spritecraft.frontend.CheckBoxedBorder;
import com.diamondpants.spritecraft.frontend.HelpLabel;
import com.diamondpants.spritecraft.frontend.IconPanel;
import com.diamondpants.spritecraft.frontend.ImageManager;
import com.diamondpants.spritecraft.frontend.MaterialsPanel;
import com.diamondpants.spritecraft.frontend.SizeRememberingFrame;
import com.diamondpants.spritecraft.frontend.StateKeeper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;

public class OptionsFrame
extends SizeRememberingFrame {
    private static final long serialVersionUID = -6101574131801321819L;
    private Generator gen;
    private JLabel texturePackLabel;
    private JComboBox<String> ditherComboBox;
    private JRadioButton sideViewRadioButton;
    private JRadioButton topViewRadioButton;
    private CheckBoxedBorder allBlocksBorder;
    private IconPanel sideIconPanel;
    private IconPanel topIconPanel;
    private MaterialsPanel[] materialsPanels;

    public OptionsFrame(JFrame parent, Generator generator) {
        super("OptionsFrame", new Dimension(800, 600));
        this.setTitle("Spritecraft Options");
        this.setIconImage(ImageManager.getIcon().getImage());
        this.gen = generator;
        JLabel saysTexturePackLabel = new JLabel("Resource Pack:");
        saysTexturePackLabel.setFont(new Font(saysTexturePackLabel.getFont().getName(), 1, saysTexturePackLabel.getFont().getSize()));
        this.texturePackLabel = new JLabel("Default");
        JButton browseButton = new JButton("Browse");
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(1);
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.setMultiSelectionEnabled(false);
                if (StateKeeper.getLastTerrainDir() != null) {
                    chooser.setCurrentDirectory(new File(StateKeeper.getLastTerrainDir()));
                }
                if (chooser.showOpenDialog(OptionsFrame.this) == 0) {
                    File file = chooser.getSelectedFile();
                    StateKeeper.setLastTerrainDir(file.getParentFile().getAbsolutePath());
                    try {
                        OptionsFrame.this.gen.getMaterialSet().setTerrainURL(file.getAbsolutePath());
                        OptionsFrame.this.texturePackLabel.setText(file.getName());
                        OptionsFrame.this.refreshCheckBoxes();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(OptionsFrame.this, "Whoops... uh, sorry, but something bad just happened: " + ex.getMessage(), "Whoops!", 0);
                    }
                }
            }
        });
        HelpLabel texturePackHelpLabel = new HelpLabel("<html>Use this to select an alternate resource pack. Spritecraft<br/>can handle normal and high def resource packs!</html>");
        JLabel saysSideOrTopViewLabel = new JLabel("Side or Top View:");
        saysSideOrTopViewLabel.setFont(new Font(saysSideOrTopViewLabel.getFont().getName(), 1, saysSideOrTopViewLabel.getFont().getSize()));
        this.sideViewRadioButton = new JRadioButton("Side View");
        this.sideViewRadioButton.setSelected(this.gen.getSideView());
        this.sideViewRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsFrame.this.sideViewChanged();
            }
        });
        this.topViewRadioButton = new JRadioButton("Top View");
        this.topViewRadioButton.setSelected(!this.gen.getSideView());
        this.topViewRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsFrame.this.sideViewChanged();
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.sideViewRadioButton);
        group.add(this.topViewRadioButton);
        Material woodMaterial = this.gen.getMaterialSet().getMaterialByName("Wood");
        this.sideIconPanel = new IconPanel(woodMaterial.getImage(true));
        this.topIconPanel = new IconPanel(woodMaterial.getImage(false));
        HelpLabel topSideHelpLabel = new HelpLabel("<html>'Side View' will generate the blueprint as if you are looking from the<br/>side, and 'Top View' will create it as if you are looking at the top.</html>");
        JLabel saysDitherLabel = new JLabel("Dither:");
        saysDitherLabel.setFont(new Font(saysDitherLabel.getFont().getName(), 1, saysDitherLabel.getFont().getSize()));
        this.ditherComboBox = new JComboBox<String>(new String[]{"Auto", "On", "Off"});
        if (this.gen.getDither() == Generator.DitherOption.Auto) {
            this.ditherComboBox.setSelectedIndex(0);
        } else if (this.gen.getDither() == Generator.DitherOption.On) {
            this.ditherComboBox.setSelectedIndex(1);
        } else if (this.gen.getDither() == Generator.DitherOption.Off) {
            this.ditherComboBox.setSelectedIndex(2);
        }
        this.ditherComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OptionsFrame.this.ditherComboBox.getSelectedIndex() == 0) {
                    OptionsFrame.this.gen.setDither(Generator.DitherOption.Auto);
                } else if (OptionsFrame.this.ditherComboBox.getSelectedIndex() == 1) {
                    OptionsFrame.this.gen.setDither(Generator.DitherOption.On);
                } else if (OptionsFrame.this.ditherComboBox.getSelectedIndex() == 2) {
                    OptionsFrame.this.gen.setDither(Generator.DitherOption.Off);
                }
                StateKeeper.setDither(OptionsFrame.this.gen.getDither().toString());
            }
        });
        HelpLabel ditherHelpLabel = new HelpLabel("<html>Set to 'On' to use dithering, 'Off' to not use dithering. Or, you can set it<br/>to 'Auto' and Spritecraft will use dithering only if its appropriate- it's<br/>like magic! If you don't know what dithering is... well google is your friend.</html>");
        JPanel texturePackPanel = new JPanel(new FlowLayout(0, 15, 0));
        texturePackPanel.add(this.texturePackLabel);
        texturePackPanel.add(browseButton);
        JPanel sideOrTopViewPanel = new JPanel(new FlowLayout(0, 15, 0));
        JPanel temp1Panel = new JPanel(new FlowLayout(0, 0, 0));
        temp1Panel.add(this.sideViewRadioButton);
        temp1Panel.add(this.sideIconPanel);
        sideOrTopViewPanel.add(temp1Panel);
        JPanel temp2Panel = new JPanel(new FlowLayout(0, 0, 0));
        temp2Panel.add(this.topViewRadioButton);
        temp2Panel.add(this.topIconPanel);
        sideOrTopViewPanel.add(temp2Panel);
        JPanel ditherPanel = new JPanel(new FlowLayout(0, 15, 0));
        ditherPanel.add(this.ditherComboBox);
        JPanel optionsPanel = new JPanel(new SpringLayout());
        optionsPanel.setBorder(BorderFactory.createTitledBorder("Options"));
        optionsPanel.add(saysTexturePackLabel);
        optionsPanel.add(texturePackPanel);
        optionsPanel.add(texturePackHelpLabel);
        optionsPanel.add(saysSideOrTopViewLabel);
        optionsPanel.add(sideOrTopViewPanel);
        optionsPanel.add(topSideHelpLabel);
        optionsPanel.add(saysDitherLabel);
        optionsPanel.add(ditherPanel);
        optionsPanel.add(ditherHelpLabel);
        Utils.makeCompactGrid(optionsPanel, 3, 3, 5, 5, 5, 5);
        JPanel blocksPanel = new JPanel();
        blocksPanel.setLayout(new BoxLayout(blocksPanel, 0));
        this.allBlocksBorder = new CheckBoxedBorder("Blocks", blocksPanel);
        this.allBlocksBorder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsFrame.this.selectAllBlocks(OptionsFrame.this.allBlocksBorder.isSelected());
            }
        });
        blocksPanel.setBorder(this.allBlocksBorder);
        this.setupBlockCheckBoxes(blocksPanel);
        JButton resetDefaultsButton = new JButton("Reset Defaults");
        resetDefaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsFrame.this.gen.setDither(Generator.DitherOption.Auto);
                OptionsFrame.this.ditherComboBox.setSelectedIndex(0);
                StateKeeper.setDither(OptionsFrame.this.gen.getDither().toString());
                OptionsFrame.this.texturePackLabel.setText("Default");
                OptionsFrame.this.gen.setSideView(true);
                OptionsFrame.this.sideViewRadioButton.setSelected(true);
                OptionsFrame.this.topViewRadioButton.setSelected(false);
                StateKeeper.setSideView(OptionsFrame.this.gen.getSideView());
                OptionsFrame.this.gen.getMaterialSet().setDefaults();
                MaterialsPanel[] materialsPanelArray = OptionsFrame.this.materialsPanels;
                int n = materialsPanelArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MaterialsPanel panel = materialsPanelArray[n2];
                    panel.persistUse();
                    ++n2;
                }
                OptionsFrame.this.refreshCheckBoxes();
            }
        });
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsFrame.this.setVisible(false);
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(resetDefaultsButton);
        buttonPanel.add(closeButton);
        JPanel blocksOuterPanel = new JPanel(new BorderLayout());
        blocksOuterPanel.add((Component)blocksPanel, "North");
        JScrollPane blocksScrollPane = new JScrollPane(blocksOuterPanel);
        blocksScrollPane.setBorder(null);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)optionsPanel, "North");
        this.getContentPane().add((Component)blocksScrollPane, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
    }

    private void sideViewChanged() {
        this.gen.setSideView(this.sideViewRadioButton.isSelected());
        StateKeeper.setSideView(this.gen.getSideView());
        this.refreshCheckBoxes();
    }

    private void refreshCheckBoxes() {
        Material woodMaterial = this.gen.getMaterialSet().getMaterialByName("Wood");
        this.sideIconPanel.setImage(woodMaterial.getImage(true));
        this.topIconPanel.setImage(woodMaterial.getImage(false));
        MaterialsPanel[] materialsPanelArray = this.materialsPanels;
        int n = this.materialsPanels.length;
        int n2 = 0;
        while (n2 < n) {
            MaterialsPanel panel = materialsPanelArray[n2];
            panel.refresh();
            ++n2;
        }
        this.repaint();
    }

    private void selectAllBlocks(boolean select) {
        MaterialsPanel[] materialsPanelArray = this.materialsPanels;
        int n = this.materialsPanels.length;
        int n2 = 0;
        while (n2 < n) {
            MaterialsPanel panel = materialsPanelArray[n2];
            panel.setSelected(select);
            ++n2;
        }
    }

    private void updateAllCheckBox() {
        boolean allChecked = true;
        MaterialsPanel[] materialsPanelArray = this.materialsPanels;
        int n = this.materialsPanels.length;
        int n2 = 0;
        while (n2 < n) {
            MaterialsPanel panel = materialsPanelArray[n2];
            if (!panel.isSelected()) {
                allChecked = false;
                break;
            }
            ++n2;
        }
        this.allBlocksBorder.setSelected(allChecked);
    }

    private void setupBlockCheckBoxes(JPanel blocksPanel) {
        this.materialsPanels = new MaterialsPanel[]{new MaterialsPanel(this.gen, Material.MaterialType.Common), new MaterialsPanel(this.gen, Material.MaterialType.Rare), new MaterialsPanel(this.gen, Material.MaterialType.Wool), new MaterialsPanel(this.gen, Material.MaterialType.Clay), new MaterialsPanel(this.gen, Material.MaterialType.Unusual), new MaterialsPanel(this.gen, Material.MaterialType.Special)};
        JPanel[] outerPanels = new JPanel[this.materialsPanels.length];
        int i = 0;
        while (i < this.materialsPanels.length) {
            outerPanels[i] = new JPanel(new BorderLayout());
            outerPanels[i].add((Component)this.materialsPanels[i], "North");
            blocksPanel.add(outerPanels[i]);
            this.materialsPanels[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    OptionsFrame.this.updateAllCheckBox();
                }
            });
            ++i;
        }
        this.standardizePreferredWidth(outerPanels);
        this.updateAllCheckBox();
    }

    private void standardizePreferredWidth(JPanel[] panels) {
        JPanel panel;
        int maxWidth = 0;
        JPanel[] jPanelArray = panels;
        int n = panels.length;
        int n2 = 0;
        while (n2 < n) {
            panel = jPanelArray[n2];
            if (panel.getMinimumSize().width > maxWidth) {
                maxWidth = panel.getMinimumSize().width;
            }
            ++n2;
        }
        jPanelArray = panels;
        n = panels.length;
        n2 = 0;
        while (n2 < n) {
            panel = jPanelArray[n2];
            panel.setPreferredSize(new Dimension(maxWidth, panel.getMinimumSize().height));
            ++n2;
        }
    }
}

