/*
 * Decompiled with CFR 0.152.
 */
package com.diamondpants.spritecraft.frontend;

import com.diamondpants.helpfulstuff.Utils;
import com.diamondpants.spritecraft.Blueprint;
import com.diamondpants.spritecraft.ResourceItem;
import com.diamondpants.spritecraft.frontend.IconPanel;
import com.diamondpants.spritecraft.frontend.ImageManager;
import com.diamondpants.spritecraft.frontend.ImagePanel;
import com.diamondpants.spritecraft.frontend.MainFrame;
import com.diamondpants.spritecraft.frontend.PNGFilter;
import com.diamondpants.spritecraft.frontend.SchematicFilter;
import com.diamondpants.spritecraft.frontend.SizeRememberingDialog;
import com.diamondpants.spritecraft.frontend.StateKeeper;
import com.diamondpants.spritecraft.ticators.Imageticator;
import com.diamondpants.spritecraft.ticators.ResourceListicator;
import com.diamondpants.spritecraft.ticators.Schematicator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;

public class PreviewDialog
extends SizeRememberingDialog {
    private static final long serialVersionUID = 71960388814091224L;
    private Blueprint blueprint;
    private BufferedImage image;
    private LinkedList<ResourceItem> resourceList;
    private LinkedList<JPanel> fillerPanels = new LinkedList();
    private JPanel materialsPanel;
    private JPanel materialsWrapperPanel;

    public PreviewDialog(Blueprint blueprint, JFrame parentFrame) {
        super(parentFrame, "PreviewDialog", new Dimension(800, 600));
        this.setDefaultCloseOperation(2);
        this.blueprint = blueprint;
        this.image = Imageticator.imageticate(blueprint, MainFrame.TESTIMAGEMODE);
        this.resourceList = ResourceListicator.resourceListicate(blueprint);
        this.setTitle("Your Minecraft Creation");
        ImagePanel previewPanel = new ImagePanel(true);
        previewPanel.setImage(this.image);
        this.materialsPanel = new JPanel(new SpringLayout());
        for (ResourceItem item : this.resourceList) {
            JPanel materialPanel = new JPanel(new FlowLayout(0));
            materialPanel.add(new IconPanel(item.getImage()));
            materialPanel.add(new JLabel(String.valueOf(item.getName()) + " x " + item.getNumItems()));
            this.materialsPanel.add(materialPanel);
        }
        JButton saveItButton = new JButton("Save Image");
        saveItButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                PNGFilter filter = new PNGFilter();
                fileChooser.addChoosableFileFilter(filter);
                fileChooser.setFileFilter(filter);
                fileChooser.setMultiSelectionEnabled(false);
                if (StateKeeper.getLastPreviewDir() != null) {
                    fileChooser.setCurrentDirectory(new File(StateKeeper.getLastPreviewDir()));
                }
                if (fileChooser.showSaveDialog(PreviewDialog.this) == 0) {
                    File file = PreviewDialog.this.getFileWithProperExtension(fileChooser, ".png");
                    StateKeeper.setLastPreviewDir(file.getParentFile().getAbsolutePath());
                    try {
                        ImageIO.write((RenderedImage)PreviewDialog.this.image, "png", file);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(PreviewDialog.this, "Whoops... uh, sorry, but something bad just happened: " + ex.getMessage(), "Whoops!", 0);
                    }
                }
            }
        });
        JButton saveSchematicButton = new JButton("Save Schematic");
        saveSchematicButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewDialog.this.saveSchematic();
            }
        });
        JButton goToHomePageButton = new JButton("Spritecraft Home Page");
        goToHomePageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String url = "http://www.diamondpants.com/spritecraft";
                    Desktop.getDesktop().browse(URI.create(url));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
        JLabel donateLabel = new JLabel(ImageManager.getDonateButton());
        donateLabel.setCursor(Cursor.getPredefinedCursor(12));
        donateLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    String url = "http://www.diamondpants.com/spritecraft/DonatePlease.aspx";
                    Desktop.getDesktop().browse(URI.create(url));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
        JPanel previewWrapperPanel = new JPanel(new BorderLayout());
        previewWrapperPanel.add((Component)previewPanel, "Center");
        JPanel savePanel = new JPanel(new FlowLayout(1));
        savePanel.add(saveItButton);
        savePanel.add(saveSchematicButton);
        previewWrapperPanel.add((Component)savePanel, "South");
        previewWrapperPanel.setBorder(BorderFactory.createTitledBorder("Preview"));
        this.materialsWrapperPanel = new JPanel(new BorderLayout());
        JPanel ahhPanel = new JPanel(new BorderLayout());
        ahhPanel.add((Component)this.materialsPanel, "North");
        ahhPanel.add((Component)new JPanel(), "Center");
        JScrollPane scrollPane = new JScrollPane(ahhPanel);
        scrollPane.setBorder(null);
        this.materialsWrapperPanel.add((Component)scrollPane, "Center");
        this.materialsWrapperPanel.setBorder(BorderFactory.createTitledBorder("Materials"));
        Dimension d = new Dimension(5000, 150);
        this.materialsWrapperPanel.setMaximumSize(d);
        this.materialsWrapperPanel.setPreferredSize(d);
        JPanel middlePanel = new JPanel(new BorderLayout());
        middlePanel.add((Component)previewWrapperPanel, "Center");
        middlePanel.add((Component)this.materialsWrapperPanel, "South");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(goToHomePageButton);
        buttonPanel.add(donateLabel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)middlePanel, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                PreviewDialog.this.updateMaterialsListLayout();
            }
        });
        this.updateMaterialsListLayout();
    }

    private void saveSchematic() {
        JFileChooser fileChooser = new JFileChooser();
        SchematicFilter filter = new SchematicFilter();
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.setFileFilter(filter);
        fileChooser.setMultiSelectionEnabled(false);
        if (StateKeeper.getLastSchematicDir() != null) {
            fileChooser.setCurrentDirectory(new File(StateKeeper.getLastSchematicDir()));
        }
        if (fileChooser.showSaveDialog(this) == 0) {
            try {
                File file = this.getFileWithProperExtension(fileChooser, ".schematic");
                StateKeeper.setLastSchematicDir(file.getParentFile().getAbsolutePath());
                Schematicator.schematicate(this.blueprint, file);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this, "Whoops... uh, sorry, but something bad just happened: " + ex.getMessage(), "Whoops!", 0);
            }
        }
    }

    private File getFileWithProperExtension(JFileChooser fileChooser, String extension) {
        File file = fileChooser.getSelectedFile();
        if (Utils.getExtension(file.getName()) == null) {
            file = new File(String.valueOf(file.getAbsolutePath()) + extension);
        }
        return file;
    }

    private void updateMaterialsListLayout() {
        for (JPanel fillerPanel : this.fillerPanels) {
            this.materialsPanel.remove(fillerPanel);
        }
        this.fillerPanels.clear();
        int cols = this.getWidth() / 200;
        if (cols > 0) {
            int rows = (this.resourceList.size() + (cols - 1)) / cols;
            int i = this.resourceList.size();
            while (i < rows * cols) {
                JPanel fillerPanel = new JPanel();
                this.materialsPanel.add(fillerPanel);
                this.fillerPanels.add(fillerPanel);
                ++i;
            }
            Utils.makeCompactGrid(this.materialsPanel, rows, cols, 5, 5, 5, 5);
            this.validate();
        }
    }
}

