/*
 * Decompiled with CFR 0.152.
 */
package com.diamondpants.spritecraft.frontend;

import com.diamondpants.spritecraft.frontend.StateKeeper;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

public class SizeRememberingWindowHelper {
    private Window window;
    private String uniqueName;

    public SizeRememberingWindowHelper(Window w, String uniqueName, Dimension defaultSize) {
        this.window = w;
        this.uniqueName = uniqueName;
        Point location = StateKeeper.getLocation(uniqueName);
        Dimension size = StateKeeper.getSize(uniqueName);
        int extendedStateValue = StateKeeper.getExtendedState(uniqueName);
        if (location.x == -1 && location.y == -1 || size.width == -1 && size.height == -1) {
            this.setDefaultSize(defaultSize);
        } else {
            this.checkSizeBounds(size);
            this.window.setSize(size);
            this.checkLocationBounds(location, size);
            this.window.setLocation(location);
            if (this.window instanceof Frame) {
                ((Frame)this.window).setExtendedState(extendedStateValue);
            }
        }
        this.window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SizeRememberingWindowHelper.this.saveSize();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                SizeRememberingWindowHelper.this.saveLocation();
            }
        });
    }

    private void checkSizeBounds(Dimension size) {
        int minSize = 150;
        if (size.width < minSize) {
            size.width = minSize;
        }
        if (size.height < minSize) {
            size.height = minSize;
        }
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        if (size.width > dim.width) {
            size.width = dim.width;
        }
        if (size.height > dim.height) {
            size.height = dim.height;
        }
    }

    private void checkLocationBounds(Point location, Dimension size) {
        int minBuffer = 100;
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        if (location.x + minBuffer > dim.width) {
            location.x = dim.width - size.width;
        }
        if (location.y + minBuffer > dim.height) {
            location.y = dim.height - size.height;
        }
    }

    private void saveSize() {
        if (this.saveExtendedState()) {
            StateKeeper.setSize(this.window.getSize(), this.uniqueName);
        }
    }

    private void saveLocation() {
        if (this.saveExtendedState()) {
            StateKeeper.setLocation(this.window.getLocation(), this.uniqueName);
        }
    }

    private boolean saveExtendedState() {
        int extendedStateValue = this.window instanceof Frame ? ((Frame)this.window).getExtendedState() : 0;
        StateKeeper.setExtendedState(extendedStateValue, this.uniqueName);
        return extendedStateValue == 0;
    }

    private void setDefaultSize(Dimension defaultSize) {
        this.window.setSize(defaultSize);
        this.window.setLocationRelativeTo(null);
    }
}

