/*
 * Decompiled with CFR 0.152.
 */
package com.diamondpants.spritecraft.frontend;

import java.awt.Dimension;
import java.awt.Point;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class StateKeeper {
    private static Preferences prefs = Preferences.userNodeForPackage(StateKeeper.class);
    private static final String maxWidthStr = "maxWidthStr";
    private static final String maxHeightStr = "maxHeightStr";
    private static final String lastImageDirStr = "lastImageDirStr";
    private static final String lastPreviewDirStr = "lastPreviewDirStr";
    private static final String lastTerrainDir = "lastTerrainDir";
    private static final String lastSchematicDirStr = "lastSchematicDirStr";
    private static final String sideViewStr = "sideViewStr";
    private static final String ditherStr = "ditherStr";
    private static final String materialPrefixStr = "materialPrefixStr";
    private static final String extendedStatePrefix = "extendedStatePrefix";
    private static final String locationXStr = "locationXStr";
    private static final String locationYStr = "locationYStr";
    private static final String widthStr = "widthStr";
    private static final String heightStr = "heightStr";

    public static void clearPrefs() throws BackingStoreException {
        prefs.clear();
    }

    public static int getMaxWidth() {
        return prefs.getInt(maxWidthStr, 0);
    }

    public static void setMaxWidth(int value) {
        prefs.putInt(maxWidthStr, value);
    }

    public static int getMaxHeight() {
        return prefs.getInt(maxHeightStr, 0);
    }

    public static void setMaxHeight(int value) {
        prefs.putInt(maxHeightStr, value);
    }

    public static String getLastImageDir() {
        return prefs.get(lastImageDirStr, null);
    }

    public static void setLastImageDir(String value) {
        prefs.put(lastImageDirStr, value);
    }

    public static String getLastPreviewDir() {
        return prefs.get(lastPreviewDirStr, null);
    }

    public static void setLastPreviewDir(String value) {
        prefs.put(lastPreviewDirStr, value);
    }

    public static String getLastTerrainDir() {
        return prefs.get(lastTerrainDir, null);
    }

    public static void setLastTerrainDir(String value) {
        prefs.put(lastTerrainDir, value);
    }

    public static String getLastSchematicDir() {
        return prefs.get(lastSchematicDirStr, null);
    }

    public static void setLastSchematicDir(String value) {
        prefs.put(lastSchematicDirStr, value);
    }

    public static boolean getSideView() {
        return prefs.getBoolean(sideViewStr, true);
    }

    public static void setSideView(boolean value) {
        prefs.putBoolean(sideViewStr, value);
    }

    public static String getDither() {
        return prefs.get(ditherStr, null);
    }

    public static void setDither(String value) {
        prefs.put(ditherStr, value);
    }

    public static String getUseMaterial(String materialName) {
        return prefs.get(materialPrefixStr + materialName, null);
    }

    public static void setUseMaterial(boolean value, String materialName) {
        prefs.put(materialPrefixStr + materialName, new Boolean(value).toString());
    }

    public static int getExtendedState(String uniqueName) {
        return prefs.getInt(extendedStatePrefix + uniqueName, 0);
    }

    public static void setExtendedState(int value, String uniqueName) {
        prefs.putInt(extendedStatePrefix + uniqueName, value);
    }

    public static Point getLocation(String uniqueName) {
        return new Point(prefs.getInt(locationXStr + uniqueName, -1), prefs.getInt(locationYStr + uniqueName, -1));
    }

    public static void setLocation(Point value, String uniqueName) {
        prefs.putInt(locationXStr + uniqueName, value.x);
        prefs.putInt(locationYStr + uniqueName, value.y);
    }

    public static Dimension getSize(String uniqueName) {
        return new Dimension(prefs.getInt(widthStr + uniqueName, -1), prefs.getInt(heightStr + uniqueName, -1));
    }

    public static void setSize(Dimension value, String uniqueName) {
        prefs.putInt(widthStr + uniqueName, value.width);
        prefs.putInt(heightStr + uniqueName, value.height);
    }
}

