/*
 * Decompiled with CFR 0.152.
 */
package com.diamondpants.spritecraft.ticators;

import com.diamondpants.spritecraft.Blueprint;
import com.diamondpants.spritecraft.Material;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class Imageticator {
    public static BufferedImage imageticate(Blueprint blueprint, boolean printDebugs) {
        byte[][] usedMaterials = blueprint.getUsedMaterials();
        int squareWidth = Imageticator.getSquareWidth(blueprint);
        int w = blueprint.getWidth();
        int h = blueprint.getHeight();
        BufferedImage blankImage = Imageticator.createBlankImage(squareWidth);
        BufferedImage output = new BufferedImage(w * squareWidth, h * squareWidth, 5);
        WritableRaster outputRaster = output.getRaster();
        if (printDebugs) {
            System.out.println("======  MATERIALS LIST AFTER START  ======");
        }
        int i = 0;
        while (i < h) {
            int j = 0;
            while (j < w) {
                BufferedImage toCopy;
                WritableRaster child = outputRaster.createWritableChild(j * squareWidth, i * squareWidth, squareWidth, squareWidth, 0, 0, null);
                byte index = usedMaterials[i][j];
                if (index > -1) {
                    Material material = blueprint.getMaterialSet().getMaterials().get(index);
                    if (printDebugs) {
                        System.out.println(material.getName());
                    }
                    toCopy = material.getImage(blueprint.getSideView(), squareWidth);
                } else {
                    toCopy = blankImage;
                }
                toCopy.copyData(child);
                ++j;
            }
            ++i;
        }
        if (printDebugs) {
            System.out.println("====== MATERIALS LIST AFTER IS DONE ======");
        }
        return output;
    }

    private static BufferedImage createBlankImage(int squareWidth) {
        BufferedImage blankImage = new BufferedImage(squareWidth, squareWidth, 5);
        Graphics g = blankImage.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, squareWidth, squareWidth);
        return blankImage;
    }

    private static int getSquareWidth(Blueprint blueprint) {
        int maxSquareWidth = Imageticator.getMaxSquareWidthForMemory(blueprint);
        int squareWidth = 0;
        for (Material material : blueprint.getMaterialsList()) {
            int origWidth = material.getOrigSquareWidth(blueprint.getSideView());
            if (squareWidth >= origWidth) continue;
            squareWidth = Math.min(origWidth, maxSquareWidth);
        }
        return squareWidth;
    }

    private static int getMaxSquareWidthForMemory(Blueprint blueprint) {
        double max = Math.min(Math.round((double)Runtime.getRuntime().maxMemory() * 0.5), Integer.MAX_VALUE);
        int maxSquareWidth = (int)Math.sqrt(max / (double)(blueprint.getHeight() * blueprint.getWidth() * 3));
        return maxSquareWidth;
    }
}

