/*
 * Decompiled with CFR 0.152.
 */
package com.diamondpants.spritecraft.ticators;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.GZIPOutputStream;

public class NBTWriter {
    private BufferedOutputStream out;

    public NBTWriter(File fileToWriteTo) throws IOException {
        this.out = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(fileToWriteTo)));
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void writeCompoundTagHeader(String name) throws IOException {
        this.out.write(10);
        this.writeName(name);
    }

    public void writeShort(String name, int value) throws IOException {
        this.out.write(2);
        this.writeName(name);
        this.writeShortValue(value);
    }

    public void writeString(String name, String value) throws IOException {
        this.out.write(8);
        this.writeName(name);
        this.writeShortValue(value.length());
        this.out.write(value.getBytes());
    }

    public void writeCompoundListHeader(String name, int length) throws IOException {
        this.out.write(9);
        this.writeName(name);
        this.out.write(10);
        this.writeIntValue(length);
    }

    public void writeByteArrayHeader(String name, int length) throws IOException {
        this.out.write(7);
        this.writeName(name);
        this.writeIntValue(length);
    }

    public void writeTagEnd() throws IOException {
        this.out.write(0);
    }

    public void writeByteValue(int value) throws IOException {
        this.out.write(value);
    }

    private void writeShortValue(int value) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(2);
        bb.putShort((short)value);
        bb.array();
        this.out.write(bb.array());
    }

    private void writeIntValue(int value) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(value);
        bb.array();
        this.out.write(bb.array());
    }

    private void writeName(String name) throws IOException {
        this.out.write(0);
        this.out.write(name.length());
        this.out.write(name.getBytes());
    }
}

