/*
 * Decompiled with CFR 0.152.
 */
package com.diamondpants.spritecraft.ticators;

import com.diamondpants.spritecraft.Blueprint;
import com.diamondpants.spritecraft.MaterialSet;
import com.diamondpants.spritecraft.ResourceItem;
import java.util.LinkedList;
import java.util.Vector;

public class ResourceListicator {
    public static LinkedList<ResourceItem> resourceListicate(Blueprint blueprint) {
        Vector<ResourceItem> resourceVector = ResourceListicator.countResources(blueprint);
        LinkedList<ResourceItem> resourceList = new LinkedList<ResourceItem>();
        for (ResourceItem item : resourceVector) {
            if (item == null) continue;
            resourceList.addLast(item);
        }
        return resourceList;
    }

    private static Vector<ResourceItem> countResources(Blueprint blueprint) {
        byte[][] usedMaterials = blueprint.getUsedMaterials();
        MaterialSet materialSet = blueprint.getMaterialSet();
        Vector<ResourceItem> resourceVector = new Vector<ResourceItem>();
        int i = 0;
        while (i < usedMaterials.length) {
            int j = 0;
            while (j < usedMaterials[i].length) {
                byte index = usedMaterials[i][j];
                if (index > -1) {
                    ResourceListicator.increaseSizeIfNecessary(resourceVector, index);
                    if (resourceVector.get(index) == null) {
                        resourceVector.set(index, new ResourceItem(materialSet.getMaterials().get(index), blueprint.getSideView()));
                    }
                    resourceVector.get(index).incrementCount();
                }
                ++j;
            }
            ++i;
        }
        return resourceVector;
    }

    private static void increaseSizeIfNecessary(Vector items, int index) {
        while (items.size() <= index) {
            items.add(null);
        }
    }
}

