/*
 * Decompiled with CFR 0.152.
 */
package com.diamondpants.spritecraft.ticators;

import com.diamondpants.spritecraft.Blueprint;
import com.diamondpants.spritecraft.MaterialSet;
import com.diamondpants.spritecraft.ticators.NBTWriter;
import java.io.File;
import java.io.IOException;

public class Schematicator {
    private static NBTWriter writer;
    private static Blueprint blueprint;

    public static void schematicate(Blueprint blueprint, File file) throws IOException {
        Schematicator.blueprint = blueprint;
        writer = new NBTWriter(file);
        Schematicator.writeBlueprint();
        writer.close();
    }

    private static void writeBlueprint() throws IOException {
        writer.writeCompoundTagHeader("Schematic");
        writer.writeShort("Width", blueprint.getWidth());
        writer.writeShort("Length", Schematicator.getLength());
        writer.writeShort("Height", Schematicator.getHeight());
        writer.writeString("Materials", "Alpha");
        Schematicator.writeBlockIDs();
        Schematicator.writeBlockData();
        Schematicator.writeEntities();
        Schematicator.writeTileEntities();
        writer.writeTagEnd();
    }

    private static void writeEntities() throws IOException {
        writer.writeCompoundListHeader("Entities", 0);
    }

    private static void writeTileEntities() throws IOException {
        writer.writeCompoundListHeader("TileEntities", 0);
    }

    private static void writeBlockIDs() throws IOException {
        MaterialSet materialSet = blueprint.getMaterialSet();
        byte[][] usedMaterials = blueprint.getUsedMaterials();
        writer.writeByteArrayHeader("Blocks", usedMaterials.length * usedMaterials[0].length);
        int i = usedMaterials.length - 1;
        while (i >= 0) {
            int j = usedMaterials[i].length - 1;
            while (j >= 0) {
                byte index = usedMaterials[i][j];
                if (index > -1) {
                    writer.writeByteValue(materialSet.getMaterials().get(index).getBlockID());
                } else {
                    writer.writeByteValue(0);
                }
                --j;
            }
            --i;
        }
    }

    private static void writeBlockData() throws IOException {
        MaterialSet materialSet = blueprint.getMaterialSet();
        byte[][] usedMaterials = blueprint.getUsedMaterials();
        writer.writeByteArrayHeader("Data", usedMaterials.length * usedMaterials[0].length);
        int i = usedMaterials.length - 1;
        while (i >= 0) {
            int j = usedMaterials[i].length - 1;
            while (j >= 0) {
                byte index = usedMaterials[i][j];
                if (index > -1) {
                    writer.writeByteValue(materialSet.getMaterials().get(index).getBlockData());
                } else {
                    writer.writeByteValue(0);
                }
                --j;
            }
            --i;
        }
    }

    private static int getLength() {
        if (blueprint.getSideView()) {
            return 1;
        }
        return blueprint.getHeight();
    }

    private static int getHeight() {
        if (blueprint.getSideView()) {
            return blueprint.getHeight();
        }
        return 1;
    }
}

