/*
 * Decompiled with CFR 0.152.
 */
package translator;

import com.ibm.icu.util.GregorianCalendar;
import com.inet.jortho.FileUserDictionary;
import com.inet.jortho.SpellChecker;
import com.inet.jortho.UserDictionaryProvider;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.swing.JideTabbedPane;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.SystemColor;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.Normalizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.nimbus.NimbusLookAndFeel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.components.ProtectedTextComponent;
import org.jmeld.ui.JMeldPanel;
import org.jw.menage.ui.components.TextLineNumber;
import translator.About;
import translator.Options;
import translator.Search;
import translator.Translator;

public class MainView
extends JFrame {
    static final long serialVersionUID = 1710447645687634671L;
    private HashMap<String, String> languages;
    private Image image = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/translator/resources/images/translation.png"));
    private final TrayIcon trayIcon = new TrayIcon(this.image);
    private Translator tran = new Translator("", "", "", "");
    Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    private JComboBox<String> fromCombo;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenu jMenu5;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JMenuItem jMenuItem8;
    private JMenuItem jMenuItem9;
    private JMenuItem jMenuItem10;
    private JProgressBar progressBar;
    private JComboBox<String> toCombo;
    private JButton translateButton;
    private JCheckBoxMenuItem checkBoxMenu;
    private JSeparator separator;
    private JMenuItem jMenuItem11;
    private JSeparator separator_1;
    private JMenu jMenu6;
    private JMenu jMenu7;
    private JRadioButtonMenuItem jRadioButton1;
    private JRadioButtonMenuItem jRadioButton2;
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private TextLineNumber textLineNumber;
    private JideTabbedPane tabbedPane;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTextArea textArea;
    private JMeldPanel jMeldPanel;
    private ProtectedTextComponent ptcArea;
    private UndoManager undo;
    private Document undoDoc;
    private JMenuItem jMenuItem12;
    private JMenuItem jMenuItem13;
    private JMenuItem jMenuItem14;
    private JTable jTableView;
    private JSpinner spinner;
    private JSpinner spinner_4;
    private JLabel lblHh;
    private JLabel lblHrs;
    private SpinnerDateModel model;
    private SpinnerDateModel model_4;
    private Date dateValue;
    private JButton syncButton;
    private JLabel lblNewLabel;
    private DefaultTableModel dtm;

    public MainView(Frame parent) {
        try {
            Color ctrl = new Color(SystemColor.control.getRed(), SystemColor.control.getGreen(), SystemColor.control.getBlue());
            UIManager.put("control", ctrl);
            UIManager.setLookAndFeel(new NimbusLookAndFeel());
        }
        catch (Exception e) {
            System.out.println("Error: " + e.toString());
        }
        LookAndFeelFactory.installJideExtension();
        SwingUtilities.updateComponentTreeUI(this);
        this.initComponents();
        this.initMyComponents();
    }

    private void initMyComponents() {
        BufferedImage viewImage = null;
        try {
            viewImage = ImageIO.read(this.getClass().getResource("/translator/resources/images/viewImage.png"));
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
        this.setIconImage(viewImage);
        this.fillLanguagesMap();
        this.initSystemTray();
    }

    private void initSystemTray() {
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            final JPopupMenu trayPopup = new JPopupMenu();
            JMenuItem exitItem = new JMenuItem("Exit", new ImageIcon(this.getClass().getResource("/translator/resources/images/exit_tray.png")));
            exitItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainView.this.jMenuItem1ActionPerformed(e);
                }
            });
            JMenuItem openItem = new JMenuItem("Restore", new ImageIcon(this.getClass().getResource("/translator/resources/images/restore.png")));
            openItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainView.this.formWindowDeiconified(null);
                }
            });
            trayPopup.add(openItem);
            trayPopup.addSeparator();
            trayPopup.add(exitItem);
            this.trayIcon.setImage(this.image);
            this.trayIcon.setPopupMenu(null);
            this.trayIcon.setToolTip("SRT Translator");
            this.trayIcon.setImageAutoSize(true);
            this.trayIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    trayPopup.setLocation(e.getX() - 50, e.getY() - 70);
                    trayPopup.setInvoker(trayPopup);
                    if (trayPopup.isEnabled()) {
                        trayPopup.setEnabled(false);
                        trayPopup.setVisible(false);
                    } else {
                        trayPopup.setEnabled(true);
                        trayPopup.setVisible(true);
                    }
                }
            });
            try {
                tray.add(this.trayIcon);
            }
            catch (Exception ex) {
                System.err.println("TrayIcon could not be added: " + ex.getLocalizedMessage());
            }
        }
    }

    private void fillLanguagesMap() {
        this.languages = new LinkedHashMap<String, String>();
        this.languages.put("Afrikaans", "af");
        this.languages.put("Albanian", "sq");
        this.languages.put("Arabic", "ar");
        this.languages.put("Armenian", "hy");
        this.languages.put("Azerbaijani", "az");
        this.languages.put("Basque", "eu");
        this.languages.put("Belarusian", "be");
        this.languages.put("Bulgarian", "bg");
        this.languages.put("Catalan", "ca");
        this.languages.put("Chinese", "zh");
        this.languages.put("Chinese_simplified", "zh-CN");
        this.languages.put("Chinese_traditional", "zh-TW");
        this.languages.put("Croatian", "hr");
        this.languages.put("Czech", "cs");
        this.languages.put("Danish", "da");
        this.languages.put("Dutch", "nl");
        this.languages.put("English", "en");
        this.languages.put("Esperanto", "eo");
        this.languages.put("Estonian", "et");
        this.languages.put("Filipino", "tl");
        this.languages.put("Finnish", "fi");
        this.languages.put("French", "fr");
        this.languages.put("Galician", "gl");
        this.languages.put("Georgian", "ka");
        this.languages.put("German", "de");
        this.languages.put("Greek", "el");
        this.languages.put("Hebrew", "iw");
        this.languages.put("Hindi", "hi");
        this.languages.put("Hungarian", "hu");
        this.languages.put("Icelandic", "is");
        this.languages.put("Indonesian", "id");
        this.languages.put("Irish", "ga");
        this.languages.put("Italian", "it");
        this.languages.put("Japanese", "ja");
        this.languages.put("Korean", "ko");
        this.languages.put("Latvian", "lv");
        this.languages.put("Lithuanian", "lt");
        this.languages.put("Macedonian", "mk");
        this.languages.put("Malay", "ms");
        this.languages.put("Maltese", "mt");
        this.languages.put("Norwegian", "no");
        this.languages.put("Persian", "fa");
        this.languages.put("Polish", "pl");
        this.languages.put("Portuguese", "pt");
        this.languages.put("Romanian", "ro");
        this.languages.put("Russian", "ru");
        this.languages.put("Serbian", "sr");
        this.languages.put("Slovak", "sk");
        this.languages.put("Slovenian", "sl");
        this.languages.put("Spanish", "es");
        this.languages.put("Swahili", "sw");
        this.languages.put("Swedish", "sv");
        this.languages.put("Tagalog", "tl");
        this.languages.put("Thai", "th");
        this.languages.put("Turkish", "tr");
        this.languages.put("Ukrainian", "uk");
        this.languages.put("Urdu", "ur");
        this.languages.put("Vietnamese", "vi");
        this.languages.put("Welsh", "cy");
        this.languages.put("Yiddish", "yi");
        this.fromCombo.removeAllItems();
        this.toCombo.removeAllItems();
        for (String value : this.languages.keySet()) {
            this.fromCombo.addItem(value);
            this.toCombo.addItem(value);
        }
        this.fromCombo.setSelectedItem("English");
        this.toCombo.setSelectedItem("Russian");
    }

    public boolean isInternetReachable() {
        try {
            URL url = new URL("http://www.google.com");
            HttpURLConnection urlConnect = (HttpURLConnection)url.openConnection();
            Object object = urlConnect.getContent();
        }
        catch (UnknownHostException uhe) {
            return false;
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }

    private void initComponents() {
        MouseListener[] listeners;
        this.undo = new UndoManager();
        this.translateButton = new JButton();
        this.jButton2 = new JButton();
        this.fromCombo = new JComboBox();
        this.toCombo = new JComboBox();
        this.progressBar = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenu1.setMnemonic(70);
        this.jMenuItem1 = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenu2.setMnemonic(69);
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.jMenuItem4 = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        this.jMenuItem6 = new JMenuItem();
        this.jMenuItem6.setIcon(new ImageIcon(MainView.class.getResource("/translator/resources/images/select_all.png")));
        this.jMenu3 = new JMenu();
        this.jMenu3.setMnemonic(72);
        this.jMenuItem7 = new JMenuItem();
        this.jMenuItem7.setIcon(new ImageIcon(MainView.class.getResource("/translator/resources/images/about.png")));
        this.setTitle("SRT Translator");
        this.setCursor(new Cursor(0));
        this.setMinimumSize(new Dimension(500, 480));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeiconified(WindowEvent evt) {
                MainView.this.formWindowDeiconified(evt);
            }

            @Override
            public void windowIconified(WindowEvent evt) {
                MainView.this.formWindowIconified(evt);
            }
        });
        this.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent evt) {
                MainView.this.formWindowStateChanged(evt);
            }
        });
        this.translateButton.setText("Translate");
        this.translateButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainView.this.translateButtonMouseClicked(evt);
            }
        });
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/translator/resources/images/refresh.png")));
        this.jButton2.setToolTipText("Swap languages");
        this.jButton2.setAlignmentX(0.5f);
        this.jButton2.setBorder(null);
        this.jButton2.setHorizontalTextPosition(0);
        this.jButton2.setRolloverIcon(new ImageIcon(this.getClass().getResource("/translator/resources/images/refresh-reverse.png")));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainView.this.jButton2ActionPerformed(evt);
            }
        });
        this.fromCombo.setFont(new Font("Tahoma", 0, 12));
        this.fromCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"English", "French", "Serbian", "Croatian", "Slovenian"}));
        this.fromCombo.setBorder(null);
        this.fromCombo.setMinimumSize(new Dimension(76, 19));
        this.fromCombo.setPreferredSize(new Dimension(77, 21));
        this.toCombo.setFont(new Font("Tahoma", 0, 12));
        this.toCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"English", "French", "Serbian", "Croatian", "Slovenian"}));
        this.toCombo.setBorder(null);
        this.toCombo.setCursor(new Cursor(0));
        this.toCombo.setMinimumSize(new Dimension(76, 19));
        this.toCombo.setPreferredSize(new Dimension(77, 21));
        this.fromCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MainView.this.selectComboItemStateChanged(evt);
            }
        });
        this.jLabel1.setText("Translate from:");
        this.jLabel2.setText("Translate to:");
        this.jMenu1.setText("File");
        this.jMenu1.setDisplayedMnemonicIndex(0);
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.jMenuItem1.setIcon(new ImageIcon(MainView.class.getResource("/translator/resources/images/exit.png")));
        this.jMenuItem1.setText("Exit");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainView.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenuItem8 = new JMenuItem("Open");
        this.jMenuItem8.setDisplayedMnemonicIndex(0);
        this.jMenuItem8.setIcon(new ImageIcon(MainView.class.getResource("/translator/resources/images/open.png")));
        this.jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainView.this.jMenuItem8ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem8);
        this.jMenuItem9 = new JMenuItem("Save As");
        this.jMenuItem9.setDisplayedMnemonicIndex(0);
        this.jMenuItem9.setIcon(new ImageIcon(MainView.class.getResource("/translator/resources/images/save_as.png")));
        this.jMenuItem9.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainView.this.jMenuItem9ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem9);
        this.jMenuItem10 = new JMenuItem("Options");
        this.jMenuItem10.setIcon(new ImageIcon(MainView.class.getResource("/translator/resources/images/options.png")));
        this.jMenuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainView.this.jMenuItem10ActionPerformed(evt);
            }
        });
        JSeparator separator_2 = new JSeparator();
        this.jMenu1.add(separator_2);
        this.jMenu1.add(this.jMenuItem10);
        JSeparator separator_3 = new JSeparator();
        this.jMenu1.add(separator_3);
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Edit");
        this.jMenu2.setDisplayedMnemonicIndex(0);
        this.jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.jMenuItem2.setIcon(new ImageIcon(this.getClass().getResource("/translator/resources/images/cut.png")));
        this.jMenuItem2.setText("Cut");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainView.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenuItem12 = new JMenuItem("Undo");
        this.jMenuItem12.setIcon(new ImageIcon(MainView.class.getResource("/translator/resources/images/undo.png")));
        this.jMenuItem12.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.jMenuItem12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (MainView.this.undo.canUndo()) {
                        MainView.this.undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        this.jMenu2.add(this.jMenuItem12);
        this.jMenuItem13 = new JMenuItem("Redo");
        this.jMenuItem13.setIcon(new ImageIcon(MainView.class.getResource("/translator/resources/images/redo.png")));
        this.jMenuItem13.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.jMenuItem13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (MainView.this.undo.canRedo()) {
                        MainView.this.undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        this.jMenu2.add(this.jMenuItem13);
        JSeparator separator_4 = new JSeparator();
        this.jMenu2.add(separator_4);
        this.jMenu2.add(this.jMenuItem2);
        this.jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.jMenuItem3.setIcon(new ImageIcon(this.getClass().getResource("/translator/resources/images/copy.png")));
        this.jMenuItem3.setText("Copy");
        this.jMenuItem3.setDisplayedMnemonicIndex(0);
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainView.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem3);
        this.jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.jMenuItem4.setIcon(new ImageIcon(this.getClass().getResource("/translator/resources/images/paste.png")));
        this.jMenuItem4.setText("Paste");
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainView.this.jMenuItem4ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem4);
        this.jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.jMenuItem5.setIcon(new ImageIcon(this.getClass().getResource("/translator/resources/images/delete.png")));
        this.jMenuItem5.setText("Delete");
        this.jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainView.this.jMenuItem5ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem5);
        this.jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.jMenuItem6.setText("Select All");
        this.jMenuItem6.setDisplayedMnemonicIndex(7);
        this.jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainView.this.jMenuItem6ActionPerformed(evt);
            }
        });
        this.separator = new JSeparator();
        this.jMenu2.add(this.separator);
        this.jMenu2.add(this.jMenuItem6);
        this.jMenuBar1.add(this.jMenu2);
        this.separator_1 = new JSeparator();
        this.jMenu2.add(this.separator_1);
        this.jMenuItem11 = new JMenuItem("Find / Replace");
        this.jMenuItem11.setDisplayedMnemonicIndex(0);
        this.jMenuItem11.setIcon(new ImageIcon(MainView.class.getResource("/translator/resources/images/find_replace.png")));
        this.jMenuItem11.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.jMenuItem11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainView.this.jMenuItem11ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem11);
        this.jMenu3.setText("Help");
        this.jMenu3.setDisplayedMnemonicIndex(0);
        this.jMenuItem7.setText("About");
        this.jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainView.this.jMenuItem7ActionPerformed(evt);
            }
        });
        this.jMenu4 = new JMenu("Spell");
        this.jMenu4.setMnemonic(83);
        this.jMenu4.setDisplayedMnemonicIndex(0);
        this.jMenuBar1.add(this.jMenu4);
        this.jMenu3.add(this.jMenuItem7);
        this.jMenuBar1.add(this.jMenu3);
        this.setJMenuBar(this.jMenuBar1);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setPreferredSize(new Dimension(34, 10));
        cancelButton.setMinimumSize(new Dimension(34, 10));
        cancelButton.setMaximumSize(new Dimension(34, 10));
        this.tabbedPane = new JideTabbedPane();
        this.tabbedPane.setFocusable(false);
        this.tabbedPane.setShowCloseButtonOnTab(false);
        this.tabbedPane.setShowCloseButtonOnSelectedTab(false);
        this.tabbedPane.setTabShape(4);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane, -1, 553, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.progressBar, -1, 327, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.translateButton, -2, 107, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(cancelButton, -2, 103, -2)).addGroup(layout.createSequentialGroup().addGap(12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fromCombo, 0, 210, Short.MAX_VALUE).addComponent(this.jLabel1, -1, 210, Short.MAX_VALUE)).addGap(43).addComponent(this.jButton2, -2, 39, -2).addGap(47).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toCombo, 0, 210, Short.MAX_VALUE).addComponent(this.jLabel2, -1, 210, Short.MAX_VALUE)).addGap(2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton2, -2, 31, -2).addComponent(this.toCombo, -2, 27, -2).addComponent(this.fromCombo, -2, 27, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabbedPane, -1, 326, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.progressBar, -2, 25, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(cancelButton, -2, 25, -2).addComponent(this.translateButton, -2, 25, -2))).addContainerGap()));
        this.textArea = new JTextArea();
        this.textArea.setTabSize(5);
        this.textArea.setRows(5);
        this.textArea.setMargin(new Insets(5, 5, 5, 2));
        this.textArea.setFont(new Font("Monospaced", 0, 14));
        this.textArea.setDragEnabled(true);
        this.textArea.setColumns(25);
        this.undoDoc = this.textArea.getDocument();
        this.undoDoc.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                MainView.this.undo.addEdit(evt.getEdit());
            }
        });
        this.textArea.getActionMap().put("Undo", new AbstractAction("Undo"){
            static final long serialVersionUID = 1710447645687634671L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (MainView.this.undo.canUndo()) {
                        MainView.this.undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        this.textArea.getActionMap().put("Redo", new AbstractAction("Redo"){
            static final long serialVersionUID = 1710447645687634671L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (MainView.this.undo.canRedo()) {
                        MainView.this.undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
        this.ptcArea = new ProtectedTextComponent((JTextComponent)this.textArea);
        this.jScrollPane1 = new JScrollPane(this.textArea);
        ImageIcon subIcon = new ImageIcon(this.getClass().getResource("/translator/resources/images/subtitles.png"));
        this.tabbedPane.addTab("Subtitles", subIcon, this.jScrollPane1, null);
        this.textLineNumber = new TextLineNumber((JTextComponent)this.textArea);
        this.jScrollPane1.setRowHeaderView((Component)this.textLineNumber);
        this.jScrollPane1.setViewportView(this.textArea);
        this.jMeldPanel = new JMeldPanel();
        this.jScrollPane2 = new JScrollPane(this.jMeldPanel);
        ImageIcon diffIcon = new ImageIcon(this.getClass().getResource("/translator/resources/images/diff.png"));
        this.tabbedPane.addTab("Diff Tool", diffIcon, this.jScrollPane2, null);
        Object[] colName = new String[]{"Number", "StartTime", "EndTime", "Text"};
        Object[][] rowData = new Object[][]{new Object[4]};
        this.dtm = new DefaultTableModel(rowData, colName);
        this.jTableView = new JTable(this.dtm){
            static final long serialVersionUID = 1710447645687634671L;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int Index_row, int Index_col) {
                Component comp = super.prepareRenderer(renderer, Index_row, Index_col);
                if (Index_row % 2 == 0 && !this.isCellSelected(Index_row, Index_col)) {
                    comp.setBackground(new Color(233, 236, 242));
                } else {
                    comp.setBackground(Color.white);
                }
                if (Index_row == 0) {
                    comp.setBackground(new Color(0xBBFFBB));
                }
                if (Index_row == MainView.this.dtm.getRowCount() - 1) {
                    comp.setBackground(new Color(0xFFBBBB));
                }
                return comp;
            }
        };
        this.jTableView.setSelectionMode(0);
        this.jTableView.setCellSelectionEnabled(false);
        this.dtm.removeRow(0);
        this.jTableView.setTableHeader(null);
        DefaultTableCellRenderer rightRenderer = new DefaultTableCellRenderer();
        rightRenderer.setHorizontalAlignment(4);
        this.jTableView.getColumn("Number").setCellRenderer(rightRenderer);
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        this.jTableView.getColumn("StartTime").setCellRenderer(centerRenderer);
        this.jTableView.getColumn("EndTime").setCellRenderer(centerRenderer);
        this.jTableView.getColumn("Number").setMinWidth(50);
        this.jTableView.getColumn("Number").setMaxWidth(50);
        this.jTableView.getColumn("StartTime").setMinWidth(100);
        this.jTableView.getColumn("StartTime").setMaxWidth(100);
        this.jTableView.getColumn("EndTime").setMinWidth(100);
        this.jTableView.getColumn("EndTime").setMaxWidth(100);
        MouseListener[] mouseListenerArray = listeners = this.jTableView.getMouseListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            MouseListener l = mouseListenerArray[n2];
            this.jTableView.removeMouseListener(l);
            ++n2;
        }
        this.jScrollPane3 = new JScrollPane(this.jTableView);
        JPanel jPanel = new JPanel();
        ImageIcon syncIcon = new ImageIcon(this.getClass().getResource("/translator/resources/images/subsync.png"));
        this.tabbedPane.addTab("SubSync", syncIcon, jPanel, null);
        this.spinner = new JSpinner();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(11, 24);
        this.dateValue = calendar.getTime();
        try {
            this.dateValue = new SimpleDateFormat("HH:mm:ss.SSS").parse("00:00:00.000");
        }
        catch (ParseException e2) {
            e2.printStackTrace();
        }
        this.model = new SpinnerDateModel();
        this.model.setValue(this.dateValue);
        this.spinner.setModel(this.model);
        this.spinner.setEditor(new JSpinner.DateEditor(this.spinner, "HH:mm:ss.SSS"));
        this.spinner_4 = new JSpinner();
        try {
            this.dateValue = new SimpleDateFormat("HH:mm:ss.SSS").parse("00:00:00.000");
        }
        catch (ParseException e2) {
            e2.printStackTrace();
        }
        this.model_4 = new SpinnerDateModel();
        this.model_4.setValue(this.dateValue);
        this.spinner_4.setModel(this.model_4);
        this.spinner_4.setEditor(new JSpinner.DateEditor(this.spinner_4, "HH:mm:ss.SSS"));
        this.lblHh = new JLabel("hrs : mins : secs . msecs", 0);
        this.lblHrs = new JLabel("hrs : mins : secs . msecs", 0);
        this.syncButton = new JButton("Sync");
        this.syncButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainView.this.syncButtonMouseClicked(evt);
            }
        });
        JLabel lblStartTime = new JLabel("Start Time", 2);
        this.lblNewLabel = new JLabel("End Time", 4);
        GroupLayout gl_jPanel = new GroupLayout(jPanel);
        gl_jPanel.setHorizontalGroup(gl_jPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_jPanel.createSequentialGroup().addContainerGap().addGroup(gl_jPanel.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.spinner, -1, 153, Short.MAX_VALUE).addComponent(this.lblHh, -1, 152, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lblStartTime, -1, 63, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.syncButton, -2, 85, -2).addGap(6).addComponent(this.lblNewLabel, -1, 48, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_jPanel.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.lblHrs, -1, -1, Short.MAX_VALUE).addComponent(this.spinner_4, -1, 150, Short.MAX_VALUE)).addContainerGap()).addComponent(this.jScrollPane3, -1, 547, Short.MAX_VALUE));
        gl_jPanel.setVerticalGroup(gl_jPanel.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_jPanel.createSequentialGroup().addComponent(this.jScrollPane3, -1, 245, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(gl_jPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblHh).addGroup(gl_jPanel.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.syncButton, -2, 23, -2).addGroup(gl_jPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spinner, -2, -1, -2).addComponent(lblStartTime)).addGroup(gl_jPanel.createSequentialGroup().addComponent(this.lblHrs).addGap(1).addGroup(gl_jPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spinner_4, -2, -1, -2).addComponent(this.lblNewLabel))))).addContainerGap()));
        jPanel.setLayout(gl_jPanel);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MainView.this.tabbedPaneStateChanged(evt);
            }
        });
        this.getContentPane().setLayout(layout);
        cancelButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainView.this.cancelButtonMouseClicked(evt);
            }
        });
        SpellChecker.setUserDictionaryProvider((UserDictionaryProvider)new FileUserDictionary("dic"));
        File fileApp = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toString());
        String appPath = fileApp.getPath();
        appPath = String.valueOf(appPath.substring(0, appPath.lastIndexOf(File.separator) + 1)) + "dic/";
        try {
            SpellChecker.registerDictionaries((URL)new URL(appPath), (String)"en");
            SpellChecker.register((JTextComponent)this.textArea);
            SpellChecker.enableAutoSpell((JTextComponent)this.textArea, (boolean)false);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        this.jMenu5 = SpellChecker.createLanguagesMenu();
        this.checkBoxMenu = new JCheckBoxMenuItem("On / Off");
        this.checkBoxMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainView.this.checkBoxMenuActionPerformed(evt);
            }
        });
        this.jMenuItem14 = new JMenuItem("Interactive");
        this.jMenuItem14.setIcon(new ImageIcon(MainView.class.getResource("/translator/resources/images/interactive.png")));
        this.jMenuItem14.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        this.jMenuItem14.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    Robot robot = new Robot();
                    robot.keyPress(118);
                    robot.setAutoDelay(1000);
                    robot.keyRelease(118);
                }
                catch (AWTException e) {
                    e.printStackTrace();
                }
            }
        });
        this.jMenu6 = new JMenu("Manual");
        this.jMenu6.setIcon(new ImageIcon(MainView.class.getResource("/translator/resources/images/spellcheck.png")));
        this.jMenu6.add(this.jMenuItem14);
        this.jMenu6.add(this.jMenu5);
        this.jMenu6.add(this.checkBoxMenu);
        this.jMenu4.add(this.jMenu6);
        this.jMenu7 = new JMenu("Auto");
        this.jMenu7.setIcon(new ImageIcon(MainView.class.getResource("/translator/resources/images/spellcheck_auto.png")));
        this.jMenu4.add(this.jMenu7);
        this.jRadioButton1 = new JRadioButtonMenuItem("Poor Quality (Fast)");
        this.buttonGroup.add(this.jRadioButton1);
        this.jMenu7.add(this.jRadioButton1);
        this.jRadioButton2 = new JRadioButtonMenuItem("High Quality (Slow)");
        this.buttonGroup.add(this.jRadioButton2);
        this.jRadioButton2.setSelected(true);
        this.jMenu7.add(this.jRadioButton2);
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                MainView.this.textArea.requestFocusInWindow();
            }
        });
        this.pack();
    }

    private void translateButtonMouseClicked(MouseEvent evt) {
        String originalText = this.textArea.getText();
        if (originalText.length() > 0) {
            this.tabbedPane.setSelectedIndex(0);
            this.textArea.setEditable(false);
            SpellChecker.enableAutoSpell((JTextComponent)this.textArea, (boolean)false);
            String fromLangName = (String)this.fromCombo.getSelectedItem();
            String toLangName = (String)this.toCombo.getSelectedItem();
            if (fromLangName.equals(toLangName)) {
                return;
            }
            if (toLangName.equals("Arabic") || toLangName.equals("Hebrew") || toLangName.equals("Yiddish") || toLangName.equals("Persian") || toLangName.equals("Urdu")) {
                this.textArea.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            } else {
                this.textArea.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            }
            String fromLang = this.languages.get(fromLangName);
            String toLang = this.languages.get(toLangName);
            String spellType = "1";
            if (this.jRadioButton1.isSelected()) {
                spellType = "0";
            }
            try {
                this.tran = new Translator(originalText, fromLang, toLang, this.textArea, this.progressBar, this.translateButton, this.checkBoxMenu, spellType, this.trayIcon, this, this.ptcArea);
                this.tran.start();
            }
            catch (Exception ex) {
                if (!this.isInternetReachable()) {
                    JOptionPane.showConfirmDialog(null, "Please, connect to the Internet.");
                }
                JOptionPane.showConfirmDialog(null, "Error occured. Please, try again.");
            }
            this.textArea.setEditable(true);
        }
    }

    private void syncButtonMouseClicked(MouseEvent evt) {
        long correctStart = this.model.getDate().getTime();
        long correctEnd = this.model_4.getDate().getTime();
        String sStart = this.jTableView.getValueAt(0, 1).toString().replaceAll("\\,", "\\.");
        String sEnd = this.jTableView.getValueAt(this.dtm.getRowCount() - 1, 1).toString().replaceAll("\\,", "\\.");
        Date dateStart = null;
        Date dateEnd = null;
        try {
            dateStart = new SimpleDateFormat("HH:mm:ss.SSS").parse(sStart);
            dateEnd = new SimpleDateFormat("HH:mm:ss.SSS").parse(sEnd);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        long selectedStart = dateStart.getTime();
        long selectedEnd = dateEnd.getTime();
        double a = (double)(correctEnd - correctStart) / (double)(selectedEnd - selectedStart);
        double b = (double)correctStart - a * (double)selectedStart;
        int count = 0;
        while (count <= this.dtm.getRowCount() - 1) {
            String sFirst = this.jTableView.getValueAt(count, 1).toString().replaceAll("\\,", "\\.");
            String sNext = this.jTableView.getValueAt(count, 2).toString().replaceAll("\\,", "\\.");
            Date dateFirst = null;
            Date dateNext = null;
            try {
                dateFirst = new SimpleDateFormat("HH:mm:ss.SSS").parse(sFirst);
                dateNext = new SimpleDateFormat("HH:mm:ss.SSS").parse(sNext);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            double destTimeStart = (double)dateFirst.getTime() * a + b;
            double destTimeEnd = (double)dateNext.getTime() * a + b;
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
            String sNewFirst = sdf.format(new Date(Math.round(destTimeStart))).replaceAll("\\.", "\\,");
            String sNewNext = sdf.format(new Date(Math.round(destTimeEnd))).replaceAll("\\.", "\\,");
            this.dtm.setValueAt(sNewFirst, count, 1);
            this.dtm.setValueAt(sNewNext, count, 2);
            ++count;
        }
    }

    private void tabbedPaneStateChanged(ChangeEvent evt) {
        if (this.tabbedPane.getSelectedIndex() == 2 && this.translateButton.isEnabled()) {
            this.dtm.getDataVector().removeAllElements();
            this.dtm.fireTableDataChanged();
            String originalText = this.textArea.getText();
            String[] txtSplit = originalText.split("\n\n");
            int g = 0;
            while (g < txtSplit.length) {
                String nl = "\\\n";
                String sp = "[ \\t]*";
                Pattern pat = Pattern.compile("(?s)(\\d+)[ \\t]*\\\n(\\d{1,2}):(\\d\\d):(\\d\\d),(\\d\\d\\d)[ \\t]*-->[ \\t]*(\\d\\d):(\\d\\d):(\\d\\d),(\\d\\d\\d)[ \\t]*(X1:\\d.*?)??\\\n", 74);
                Matcher mat = pat.matcher(txtSplit[g]);
                mat.find();
                int iStart = mat.start();
                int iEnd = mat.end();
                String sCounterANDTimeStamp = txtSplit[g].substring(iStart, iEnd);
                String[] sCounterStamp = sCounterANDTimeStamp.split("[ \\t]*\\\n");
                String[] sStartANDEndTime = sCounterStamp[1].replaceAll("\\\n", "").split(" --> ");
                String sSubtitleTextOnly = txtSplit[g].substring(iEnd, txtSplit[g].length());
                this.dtm.addRow(new Object[]{sCounterStamp[0], sStartANDEndTime[0], sStartANDEndTime[1], sSubtitleTextOnly});
                if (g == 0) {
                    try {
                        this.dateValue = new SimpleDateFormat("HH:mm:ss.SSS").parse(sStartANDEndTime[0].replaceAll("\\,", "\\."));
                    }
                    catch (ParseException e2) {
                        e2.printStackTrace();
                    }
                    this.model.setValue(this.dateValue);
                }
                if (g == txtSplit.length - 1) {
                    try {
                        this.dateValue = new SimpleDateFormat("HH:mm:ss.SSS").parse(sStartANDEndTime[0].replaceAll("\\,", "\\."));
                    }
                    catch (ParseException e2) {
                        e2.printStackTrace();
                    }
                    this.model_4.setValue(this.dateValue);
                }
                ++g;
            }
            int c = 0;
            while (c < this.jTableView.getColumnCount()) {
                Class<?> col_class = this.jTableView.getColumnClass(c);
                this.jTableView.setDefaultEditor(col_class, null);
                ++c;
            }
        }
        if (this.tabbedPane.getSelectedIndex() == 0 && this.translateButton.isEnabled() && this.dtm.getRowCount() > 1) {
            this.ptcArea = new ProtectedTextComponent((JTextComponent)this.textArea);
            this.textArea.setText("");
            int count = 0;
            while (count <= this.dtm.getRowCount() - 1) {
                this.textArea.append(String.valueOf(this.jTableView.getValueAt(count, 0).toString()) + "\n");
                this.textArea.append(String.valueOf(this.jTableView.getValueAt(count, 1).toString()) + " --> " + this.jTableView.getValueAt(count, 2).toString() + "\n");
                if (count == this.dtm.getRowCount() - 1) {
                    this.textArea.append(this.jTableView.getValueAt(count, 3).toString());
                } else {
                    this.textArea.append(String.valueOf(this.jTableView.getValueAt(count, 3).toString()) + "\n\n");
                }
                ++count;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(this.textArea.getText().getBytes());
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            int ln = 0;
            ArrayList<Integer> ptcNumber = new ArrayList<Integer>();
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    if (line.equals("")) {
                        ptcNumber.add(ln);
                    }
                    ++ln;
                }
                br.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.ptcArea.protectLines(0, 1);
            int rx = 0;
            while (rx < ptcNumber.size()) {
                ln = (Integer)ptcNumber.get(rx);
                this.ptcArea.protectLines(ln, ln + 2);
                ++rx;
            }
        }
    }

    private void cancelButtonMouseClicked(MouseEvent evt) {
        this.tran.shutdown();
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        this.textArea.cut();
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        this.textArea.copy();
    }

    private void jMenuItem4ActionPerformed(ActionEvent evt) {
        this.textArea.paste();
    }

    private void jMenuItem6ActionPerformed(ActionEvent evt) {
        this.textArea.selectAll();
    }

    private void jMenuItem7ActionPerformed(ActionEvent evt) {
        About ad = new About((Frame)this, true);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle abounds = ad.getBounds();
        ad.setLocation((dim.width - abounds.width) / 2, (dim.height - abounds.height) / 2);
        ad.setVisible(true);
        ad.requestFocus();
    }

    private void jMenuItem8ActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        chooser.setMultiSelectionEnabled(false);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("SubRip files (*.srt)", "srt");
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(filter);
        this.tabbedPane.setSelectedIndex(0);
        int r = chooser.showOpenDialog(new JFrame());
        if (r == 0) {
            String fPath = chooser.getSelectedFile().getPath();
            String sEncoding = this.prefs.get("inputCharset", "UTF-8");
            try {
                String strLine;
                FileInputStream fstream = new FileInputStream(fPath);
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, sEncoding));
                String allText = "";
                ArrayList<Integer> ptcNumber = new ArrayList<Integer>();
                int ln = 0;
                while ((strLine = br.readLine()) != null) {
                    allText = String.valueOf(allText) + strLine + "\n";
                    if (strLine.equals("")) {
                        ptcNumber.add(ln);
                    }
                    ++ln;
                }
                br.close();
                allText = MainView.replaceLast(allText.trim(), "\n\n+", "\n");
                allText = allText.replaceFirst("\ufeff", "").replaceFirst("\uefbbBF", "");
                allText = Normalizer.normalize(allText, Normalizer.Form.NFC);
                this.ptcArea = new ProtectedTextComponent((JTextComponent)this.textArea);
                this.textArea.setText(allText);
                this.ptcArea.protectLines(0, 1);
                int rx = 0;
                while (rx < ptcNumber.size()) {
                    ln = (Integer)ptcNumber.get(rx);
                    this.ptcArea.protectLines(ln, ln + 2);
                    ++rx;
                }
                if (this.fromCombo.getSelectedIndex() == this.fromCombo.getItemCount() - 1) {
                    this.fromCombo.setSelectedIndex(this.fromCombo.getSelectedIndex() - 1);
                    this.fromCombo.setSelectedIndex(this.fromCombo.getSelectedIndex() + 1);
                } else {
                    this.fromCombo.setSelectedIndex(this.fromCombo.getSelectedIndex() + 1);
                    this.fromCombo.setSelectedIndex(this.fromCombo.getSelectedIndex() - 1);
                }
            }
            catch (Exception e) {
                System.err.println("Error: " + e.getMessage());
            }
        }
    }

    private void jMenuItem9ActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        FileNameExtensionFilter filter = new FileNameExtensionFilter("SubRip files (*.srt)", "srt");
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(filter);
        this.tabbedPane.setSelectedIndex(0);
        int r = chooser.showSaveDialog(new JFrame());
        if (r == 0) {
            try {
                String sEncoding = this.prefs.get("outputCharset", "UTF-8");
                File sfile = chooser.getSelectedFile();
                String spath = sfile.getPath();
                int iext = spath.indexOf(".srt");
                if (iext < 0) {
                    spath = String.valueOf(spath) + ".srt";
                }
                FileOutputStream fostream = new FileOutputStream(spath);
                PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)fostream, sEncoding));
                if (sEncoding.equals("UTF-8")) {
                    String UTF8_HEADER = new String(new byte[]{-17, -69, -65}, sEncoding);
                    out.print(UTF8_HEADER);
                }
                if (sEncoding.equals("UTF-16BE") || sEncoding.equals("UTF-16LE")) {
                    String UTF16BELE_HEADER = "\ufeff";
                    out.print(UTF16BELE_HEADER);
                }
                if (sEncoding.equals("UTF-32BE") || sEncoding.equals("UTF-32LE") || sEncoding.equals("UTF-32")) {
                    String UTF32_HEADER = "\ufeff";
                    out.print(UTF32_HEADER);
                }
                out.print(this.textArea.getText().replaceAll("\n\n+", "\n\n").trim());
                out.close();
            }
            catch (Exception e) {
                System.err.println("Error: " + e.getMessage());
            }
        }
    }

    private void jMenuItem10ActionPerformed(ActionEvent evt) {
        Options optform = new Options();
        optform.setModal(true);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int x = (screenSize.width - optform.getWidth()) / 2;
        int y = (screenSize.height - optform.getHeight()) / 2;
        optform.setLocation(x, y);
        optform.setVisible(true);
    }

    private void jMenuItem11ActionPerformed(ActionEvent evt) {
        Search findform = new Search(this.textArea);
        findform.setModal(false);
        findform.setAlwaysOnTop(true);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int x = (screenSize.width - findform.getWidth()) / 2;
        int y = (screenSize.height - findform.getHeight()) / 2;
        findform.setLocation(x, y);
        findform.setVisible(true);
    }

    private void checkBoxMenuActionPerformed(ActionEvent evt) {
        AbstractButton aButton = (AbstractButton)evt.getSource();
        boolean selected = aButton.getModel().isSelected();
        if (selected) {
            SpellChecker.enableAutoSpell((JTextComponent)this.textArea, (boolean)true);
        } else {
            SpellChecker.enableAutoSpell((JTextComponent)this.textArea, (boolean)false);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        String item1 = (String)this.fromCombo.getSelectedItem();
        String item2 = (String)this.toCombo.getSelectedItem();
        this.fromCombo.setSelectedItem(item2);
        this.toCombo.setSelectedItem(item1);
    }

    private void jMenuItem5ActionPerformed(ActionEvent evt) {
        this.textArea.replaceSelection("");
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void formWindowIconified(WindowEvent evt) {
        this.setVisible(false);
    }

    private void formWindowDeiconified(WindowEvent evt) {
        this.setVisible(true);
        this.toFront();
    }

    private void formWindowStateChanged(WindowEvent evt) {
    }

    private void selectComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            Object item = evt.getItem();
            String itemValue = item.toString();
            if (itemValue.equals("Arabic") || itemValue.equals("Hebrew") || itemValue.equals("Yiddish") || itemValue.equals("Persian") || itemValue.equals("Urdu")) {
                this.textArea.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            } else {
                this.textArea.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            }
            this.textArea.append(" ");
            int start = this.textArea.getText().lastIndexOf(" ");
            if (start >= 0) {
                this.textArea.replaceRange("", start, start + 1);
            }
        }
    }

    public static String replaceLast(String string, String toReplace, String replacement) {
        int pos = string.lastIndexOf(toReplace);
        if (pos > -1) {
            return String.valueOf(string.substring(0, pos)) + replacement + string.substring(pos + toReplace.length(), string.length());
        }
        return string;
    }
}

