/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.prefs.Preferences;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import translator.Main;

public class Options
extends JDialog {
    private String appPath = ManagementFactory.getRuntimeMXBean().getClassPath();
    private final ImageIcon staticIcon = new ImageIcon(this.getClass().getResource("/translator/resources/images/loader52.gif"));
    private final ImageIcon loadingIcon = new ImageIcon(this.getClass().getResource("/translator/resources/images/loader5.gif"));
    private HashMap<String, String> lngAvailable;
    private HashMap<String, String> lngInstalled;
    private String[] cnfLang = new String[0];
    static final long serialVersionUID = 1710447645687634671L;
    Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    private JComboBox comboBox1;
    private JLabel lblLabel2;
    private JComboBox comboBox2;
    private JButton okButton;
    private JButton cancelButton;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JLabel jLabelPort;
    private JLabel jLabelHost;
    private JCheckBox jCheckBox2;
    private JScrollPane scrollPane2;
    private JList jList2;
    private JList jList1;
    private JScrollPane scrollPane1;
    private DefaultListModel listModel1;
    private DefaultListModel listModel2;
    private JButton btnApply;
    private JLabel jLabelLoader;

    public static void main(String[] args) {
        try {
            Options dialog = new Options();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Options() {
        this.setType(Window.Type.UTILITY);
        this.setResizable(false);
        this.setTitle("Options");
        this.setBounds(100, 100, 462, 371);
        JLabel lblLabel1 = new JLabel("Default Input Charset");
        this.comboBox1 = new JComboBox<Object>(Charset.availableCharsets().values().toArray());
        this.comboBox1.setSelectedItem(Charset.forName(this.prefs.get("inputCharset", "UTF-8")));
        this.comboBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                Charset selInputCharset = (Charset)Options.this.comboBox1.getSelectedItem();
                Options.this.prefs.put("tmpInputCharset", selInputCharset.name());
            }
        });
        this.lblLabel2 = new JLabel("Default Output Charset");
        this.comboBox2 = new JComboBox<Object>(Charset.availableCharsets().values().toArray());
        this.comboBox2.setSelectedItem(Charset.forName(this.prefs.get("outputCharset", "UTF-8")));
        this.comboBox2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Charset selOutputCharset = (Charset)Options.this.comboBox2.getSelectedItem();
                Options.this.prefs.put("tmpOutputCharset", selOutputCharset.name().toString());
            }
        });
        this.okButton = new JButton("OK");
        this.okButton.setPreferredSize(new Dimension(90, 23));
        this.okButton.setMaximumSize(new Dimension(75, 23));
        this.okButton.setMinimumSize(new Dimension(75, 23));
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Options.this.saveOptions(evt);
            }
        });
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setPreferredSize(new Dimension(90, 23));
        this.cancelButton.setMaximumSize(new Dimension(75, 23));
        this.cancelButton.setMinimumSize(new Dimension(75, 23));
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Options.this.cancelUpdate(evt);
            }
        });
        JCheckBox jCheckBox1 = new JCheckBox("Use Proxy");
        if (this.prefs.get("useProxy", "2").equals("1")) {
            jCheckBox1.setSelected(true);
        } else {
            jCheckBox1.setSelected(false);
        }
        jCheckBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Options.this.prefs.put("tmpUseProxy", Integer.toString(e.getStateChange()));
            }
        });
        this.jTextField1 = new JTextField();
        this.jTextField1.setColumns(10);
        this.jTextField1.setText(this.prefs.get("proxyHost", "127.0.0.1"));
        this.jTextField1.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                Options.this.prefs.put("tmpProxyHost", Options.this.jTextField1.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                Options.this.prefs.put("tmpProxyHost", Options.this.jTextField1.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                Options.this.prefs.put("tmpProxyHost", Options.this.jTextField1.getText());
            }
        });
        this.jTextField2 = new JTextField();
        this.jTextField2.setColumns(10);
        this.jTextField2.setText(this.prefs.get("proxyPort", "9050"));
        this.jTextField2.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                Options.this.prefs.put("tmpProxyPort", Options.this.jTextField2.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                Options.this.prefs.put("tmpProxyPort", Options.this.jTextField2.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                Options.this.prefs.put("tmpProxyPort", Options.this.jTextField2.getText());
            }
        });
        this.jLabelPort = new JLabel("Port");
        this.jLabelHost = new JLabel("Host");
        this.jCheckBox2 = new JCheckBox("Socks Proxy");
        if (this.prefs.get("socksProxy", "1").equals("1")) {
            this.jCheckBox2.setSelected(true);
        } else {
            this.jCheckBox2.setSelected(false);
        }
        this.jCheckBox2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Options.this.prefs.put("tmpSocksProxy", Integer.toString(e.getStateChange()));
            }
        });
        JButton btnAdd = new JButton("<--");
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    Options.this.addDict(evt);
                }
                catch (GeneralSecurityException e) {
                    e.printStackTrace();
                }
            }
        });
        JButton btnDel = new JButton("-->");
        btnDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Options.this.delDict(evt);
            }
        });
        JLabel jLabelInst = new JLabel("Installed Dictionaries");
        JLabel jLabelDel = new JLabel("Available Dictionaries");
        this.scrollPane2 = new JScrollPane();
        this.scrollPane2.setVerticalScrollBarPolicy(22);
        this.scrollPane1 = new JScrollPane();
        this.scrollPane1.setVerticalScrollBarPolicy(22);
        this.btnApply = new JButton("...");
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Options.this.appRestart(evt);
            }
        });
        this.jLabelLoader = new JLabel("", this.staticIcon, 0);
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(lblLabel1).addGroup(groupLayout.createSequentialGroup().addComponent(jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabelHost)).addComponent(this.comboBox1, 0, 175, Short.MAX_VALUE)).addComponent(this.jTextField1, 175, 175, Short.MAX_VALUE).addComponent(this.scrollPane1, -2, 175, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(btnDel, -1, 55, Short.MAX_VALUE).addComponent(this.btnApply, -1, 55, Short.MAX_VALUE).addComponent(btnAdd, -1, 55, Short.MAX_VALUE).addComponent(this.jLabelLoader, -1, 55, Short.MAX_VALUE))).addComponent(jLabelInst, -2, 175, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane2, -1, 178, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.okButton, -1, 83, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelButton, -2, 85, -2)).addComponent(this.jTextField2, GroupLayout.Alignment.TRAILING, -1, 178, Short.MAX_VALUE).addComponent(this.lblLabel2).addComponent(this.comboBox2, GroupLayout.Alignment.TRAILING, 0, 178, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jLabelPort).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 75, Short.MAX_VALUE).addComponent(this.jCheckBox2)).addComponent(jLabelDel, GroupLayout.Alignment.TRAILING, -1, 178, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(20).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblLabel1).addComponent(this.lblLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboBox1, -2, -1, -2).addComponent(this.comboBox2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jCheckBox1).addComponent(this.jLabelHost)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelPort).addComponent(this.jCheckBox2, -2, 23, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelLoader).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField2, -2, -1, -2).addComponent(this.jTextField1, -2, -1, -2))))).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10).addComponent(jLabelDel, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane2, -2, 128, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton, -2, -1, -2).addComponent(this.cancelButton, -2, -1, -2))).addGroup(groupLayout.createSequentialGroup().addGap(11).addComponent(jLabelInst, -2, 13, -2)).addGroup(groupLayout.createSequentialGroup().addGap(44).addComponent(btnAdd).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(btnDel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnApply)).addGroup(groupLayout.createSequentialGroup().addGap(30).addComponent(this.scrollPane1, -2, 130, -2))).addContainerGap(36, Short.MAX_VALUE)));
        this.jList1 = new JList();
        this.scrollPane1.setViewportView(this.jList1);
        this.jList2 = new JList();
        this.jList2.setSelectionMode(0);
        this.scrollPane2.setViewportView(this.jList2);
        this.getContentPane().setLayout(groupLayout);
        this.appPath = this.appPath.substring(0, this.appPath.lastIndexOf(File.separator) + 1);
        this.fillLangAvailableMap();
    }

    private void fillLangAvailableMap() {
        this.lngAvailable = new LinkedHashMap<String, String>();
        this.lngAvailable.put("Afrikaans", "af");
        this.lngAvailable.put("Arabic", "ar");
        this.lngAvailable.put("Belarusian", "be");
        this.lngAvailable.put("Bulgarian", "bg");
        this.lngAvailable.put("Croatian", "hr");
        this.lngAvailable.put("Czech", "cs");
        this.lngAvailable.put("Danish", "da");
        this.lngAvailable.put("Dutch", "nl");
        this.lngAvailable.put("English", "en");
        this.lngAvailable.put("Estonian", "et");
        this.lngAvailable.put("Finnish", "fi");
        this.lngAvailable.put("French", "fr");
        this.lngAvailable.put("German", "de");
        this.lngAvailable.put("Greek", "el");
        this.lngAvailable.put("Hebrew", "iw");
        this.lngAvailable.put("Hindi", "hi");
        this.lngAvailable.put("Hungarian", "hu");
        this.lngAvailable.put("Indonesian", "id");
        this.lngAvailable.put("Irish", "ga");
        this.lngAvailable.put("Italian", "it");
        this.lngAvailable.put("Latvian", "lv");
        this.lngAvailable.put("Lithuanian", "lt");
        this.lngAvailable.put("Macedonian", "mk");
        this.lngAvailable.put("Malay", "ms");
        this.lngAvailable.put("Norwegian", "no");
        this.lngAvailable.put("Polish", "pl");
        this.lngAvailable.put("Portuguese", "pt");
        this.lngAvailable.put("Romanian", "ro");
        this.lngAvailable.put("Russian", "ru");
        this.lngAvailable.put("Serbian", "sr");
        this.lngAvailable.put("Slovak", "sk");
        this.lngAvailable.put("Slovenian", "sl");
        this.lngAvailable.put("Spanish", "es");
        this.lngAvailable.put("Swedish", "sv");
        this.lngAvailable.put("Turkish", "tr");
        this.lngAvailable.put("Ukrainian", "uk");
        this.lngInstalled = new LinkedHashMap<String, String>();
        this.lngInstalled.put("af", "Afrikaans");
        this.lngInstalled.put("ar", "Arabic");
        this.lngInstalled.put("be", "Belarusian");
        this.lngInstalled.put("bg", "Bulgarian");
        this.lngInstalled.put("hr", "Croatian");
        this.lngInstalled.put("cs", "Czech");
        this.lngInstalled.put("da", "Danish");
        this.lngInstalled.put("nl", "Dutch");
        this.lngInstalled.put("en", "English");
        this.lngInstalled.put("et", "Estonian");
        this.lngInstalled.put("fi", "Finnish");
        this.lngInstalled.put("fr", "French");
        this.lngInstalled.put("de", "German");
        this.lngInstalled.put("el", "Greek");
        this.lngInstalled.put("iw", "Hebrew");
        this.lngInstalled.put("hi", "Hindi");
        this.lngInstalled.put("hu", "Hungarian");
        this.lngInstalled.put("id", "Indonesian");
        this.lngInstalled.put("ga", "Irish");
        this.lngInstalled.put("it", "Italian");
        this.lngInstalled.put("lv", "Latvian");
        this.lngInstalled.put("lt", "Lithuanian");
        this.lngInstalled.put("mk", "Macedonian");
        this.lngInstalled.put("ms", "Malay");
        this.lngInstalled.put("no", "Norwegian");
        this.lngInstalled.put("pl", "Polish");
        this.lngInstalled.put("pt", "Portuguese");
        this.lngInstalled.put("ro", "Romanian");
        this.lngInstalled.put("ru", "Russian");
        this.lngInstalled.put("sr", "Serbian");
        this.lngInstalled.put("sk", "Slovak");
        this.lngInstalled.put("sl", "Slovenian");
        this.lngInstalled.put("es", "Spanish");
        this.lngInstalled.put("sv", "Swedish");
        this.lngInstalled.put("tr", "Turkish");
        this.lngInstalled.put("uk", "Ukrainian");
        Iterator<String> it = this.lngAvailable.keySet().iterator();
        this.listModel1 = new DefaultListModel();
        this.listModel2 = new DefaultListModel();
        while (it.hasNext()) {
            String value = it.next();
            this.listModel2.addElement(value);
        }
        this.jList2.setModel(this.listModel2);
        try {
            BufferedReader input = new BufferedReader(new FileReader(new File(String.valueOf(this.appPath) + "dic/dictionaries.cnf")));
            try {
                String line = null;
                while ((line = input.readLine()) != null) {
                    int pos = line.indexOf("languages=");
                    if (pos <= -1) continue;
                    line = line.replaceFirst("languages=", "");
                    this.cnfLang = line.split("\\,");
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        int y = 0;
        while (y < this.cnfLang.length) {
            String lngVal = this.lngInstalled.get(this.cnfLang[y]);
            this.listModel1.addElement(lngVal);
            this.listModel2.removeElement(lngVal);
            ++y;
        }
        this.jList1.setModel(this.listModel1);
        this.jList2.setModel(this.listModel2);
    }

    private void cancelUpdate(ActionEvent evt) {
        this.dispose();
    }

    private void saveOptions(ActionEvent evt) {
        this.prefs.put("inputCharset", this.prefs.get("tmpInputCharset", "UTF-8"));
        this.prefs.put("outputCharset", this.prefs.get("tmpOutputCharset", "UTF-8"));
        this.prefs.put("useProxy", this.prefs.get("tmpUseProxy", "2"));
        this.prefs.put("proxyHost", this.prefs.get("tmpProxyHost", "127.0.0.1"));
        this.prefs.put("proxyPort", this.prefs.get("tmpProxyPort", "9050"));
        this.prefs.put("socksProxy", this.prefs.get("tmpSocksProxy", "1"));
        this.dispose();
    }

    private void addDict(ActionEvent evt) throws GeneralSecurityException {
        String selVal = (String)this.jList2.getSelectedValue();
        if (!selVal.equals("")) {
            this.listModel1.addElement(selVal);
            this.listModel2.removeElement(selVal);
            this.jList1.setModel(this.listModel1);
            Object[] modelList1 = this.listModel1.toArray();
            Arrays.sort(modelList1);
            this.jList1.setListData(modelList1);
            this.jList2.setModel(this.listModel2);
            Object[] modelList2 = this.listModel2.toArray();
            Arrays.sort(modelList2);
            this.jList2.setListData(modelList2);
            String currVal = this.lngAvailable.get(selVal);
            String cnfLangList = "";
            int x = 0;
            while (x < this.cnfLang.length) {
                cnfLangList = String.valueOf(cnfLangList) + this.cnfLang[x] + ",";
                ++x;
            }
            cnfLangList = "languages=" + cnfLangList + currVal;
            try {
                BufferedWriter cnfOut = new BufferedWriter(new FileWriter(String.valueOf(this.appPath) + "dic/dictionaries.cnf"));
                try {
                    cnfOut.write("extension=.ortho");
                    cnfOut.newLine();
                    cnfOut.write(cnfLangList);
                }
                finally {
                    cnfOut.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.fillLangAvailableMap();
            try {
                URL url = new URL("http://netcologne.dl.sourceforge.net/project/srt-tran/dic/dictionary_" + currVal + ".ortho");
                url.openConnection();
                InputStream reader = url.openStream();
                FileOutputStream writer = new FileOutputStream(String.valueOf(this.appPath) + "dic/dictionary_" + currVal + ".ortho");
                byte[] buffer = new byte[153600];
                int totalBytesRead = 0;
                int bytesRead = 0;
                while ((bytesRead = reader.read(buffer)) > 0) {
                    this.jLabelLoader.setIcon(this.loadingIcon);
                    this.jLabelLoader.revalidate();
                    this.jLabelLoader.paint(this.jLabelLoader.getGraphics());
                    writer.write(buffer, 0, bytesRead);
                    buffer = new byte[153600];
                    totalBytesRead += bytesRead;
                }
                writer.close();
                reader.close();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.jLabelLoader.setIcon(this.staticIcon);
            this.jLabelLoader.revalidate();
            this.jLabelLoader.paint(this.jLabelLoader.getGraphics());
        }
    }

    private void delDict(ActionEvent evt) {
        String selVal = (String)this.jList1.getSelectedValue();
        if (!selVal.equals("") && !selVal.equals("English")) {
            this.jLabelLoader.setIcon(this.loadingIcon);
            this.jLabelLoader.revalidate();
            this.jLabelLoader.paint(this.jLabelLoader.getGraphics());
            this.listModel2.addElement(selVal);
            this.listModel1.removeElement(selVal);
            this.jList1.setModel(this.listModel1);
            Object[] modelList1 = this.listModel1.toArray();
            Arrays.sort(modelList1);
            this.jList1.setListData(modelList1);
            this.jList2.setModel(this.listModel2);
            Object[] modelList2 = this.listModel2.toArray();
            Arrays.sort(modelList2);
            this.jList2.setListData(modelList2);
            String currVal = this.lngAvailable.get(selVal);
            String cnfLangList = "";
            int x = 0;
            while (x < this.cnfLang.length) {
                if (!this.cnfLang[x].equals(currVal)) {
                    String sepComma = this.cnfLang.length - 1 == x ? "" : ",";
                    cnfLangList = String.valueOf(cnfLangList) + this.cnfLang[x] + sepComma;
                }
                ++x;
            }
            cnfLangList = "languages=" + cnfLangList;
            try {
                BufferedWriter cnfOut = new BufferedWriter(new FileWriter(String.valueOf(this.appPath) + "dic/dictionaries.cnf"));
                try {
                    cnfOut.write("extension=.ortho");
                    cnfOut.newLine();
                    cnfOut.write(cnfLangList);
                }
                finally {
                    cnfOut.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.fillLangAvailableMap();
            String fileName = String.valueOf(this.appPath) + "dic/dictionary_" + currVal + ".ortho";
            File fileDict = new File(fileName);
            if (fileDict.exists()) {
                fileDict.setWritable(true);
                fileDict.delete();
            }
            this.jLabelLoader.setIcon(this.staticIcon);
            this.jLabelLoader.revalidate();
            this.jLabelLoader.paint(this.jLabelLoader.getGraphics());
        }
    }

    private void appRestart(ActionEvent evt) {
        StringBuilder cmd = new StringBuilder();
        cmd.append(String.valueOf(System.getProperty("java.home")) + File.separator + "bin" + File.separator + "java ");
        for (String jvmArg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            cmd.append(String.valueOf(jvmArg) + " ");
        }
        cmd.append("-cp ").append(ManagementFactory.getRuntimeMXBean().getClassPath()).append(" ");
        cmd.append(Main.class.getName()).append(" ");
        try {
            Runtime.getRuntime().exec(cmd.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

