/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class Search
extends JDialog {
    static final long serialVersionUID = 1710447645687634671L;
    private JTextField jText1;
    private JTextField jText2;
    private JCheckBox jCheckBox1;
    private JTextArea textArea;
    private Pattern pattern = null;
    private Matcher m = null;

    public Search(JTextArea textArea) {
        this.textArea = textArea;
        this.setType(Window.Type.UTILITY);
        this.setResizable(false);
        this.setTitle("Find / Replace");
        this.setBounds(100, 100, 486, 150);
        this.jText1 = new JTextField();
        this.jText1.setHorizontalAlignment(2);
        this.jText1.setColumns(10);
        this.jText1.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent evt) {
                Search.this.jText1Changed(evt);
            }

            @Override
            public void removeUpdate(DocumentEvent evt) {
                Search.this.jText1Changed(evt);
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                Search.this.jText1Changed(evt);
            }
        });
        this.jText2 = new JTextField();
        this.jText2.setHorizontalAlignment(2);
        this.jText2.setColumns(10);
        JLabel jLabel1 = new JLabel("Find what:");
        JLabel jLabel2 = new JLabel("Replace with:");
        JButton jButton1 = new JButton("Find");
        jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Search.this.textFinder(arg0);
            }
        });
        JButton jButton2 = new JButton("Replace");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Search.this.textReplacer(arg0);
            }
        });
        JButton jButton3 = new JButton("Replace All");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Search.this.textReplacerForAll(arg0);
            }
        });
        JButton jButton4 = new JButton("Close");
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Search.this.closeFinder(arg0);
            }
        });
        this.jCheckBox1 = new JCheckBox("Case sensitive");
        this.jCheckBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Search.this.jCheckBox1ActionPerformed(evt);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel2).addComponent(jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jText1, -1, 250, Short.MAX_VALUE).addComponent(this.jText2, -1, 250, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jCheckBox1).addGap(18).addComponent(jButton4, -1, 137, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jButton3, -1, 135, Short.MAX_VALUE).addComponent(jButton1, GroupLayout.Alignment.LEADING, -1, 135, Short.MAX_VALUE).addComponent(jButton2, -1, 135, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jText1, -2, 28, -2).addComponent(jButton1).addComponent(jLabel1)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(18).addComponent(jLabel2)).addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jText2, -2, 28, -2).addComponent(jButton2)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jButton3).addComponent(jButton4).addComponent(this.jCheckBox1)).addContainerGap(14, Short.MAX_VALUE)));
        this.getContentPane().setLayout(groupLayout);
    }

    private void closeFinder(ActionEvent evt) {
        this.dispose();
    }

    private void textFinder(ActionEvent evt) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.jText1.getText(), this.jCheckBox1.isSelected() ? 0 : 74);
            this.m = this.pattern.matcher(this.textArea.getText());
        }
        int endPos = this.textArea.getSelectionEnd();
        this.m.find(endPos);
        int startPos = this.m.start();
        endPos = this.m.end();
        if (startPos > -1) {
            this.textArea.setSelectionStart(startPos);
            this.textArea.setSelectionEnd(endPos);
        }
    }

    private void textReplacer(ActionEvent evt) {
        int selFlag;
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.jText1.getText(), this.jCheckBox1.isSelected() ? 0 : 74);
            this.m = this.pattern.matcher(this.textArea.getText());
            this.textFinder(evt);
        }
        if ((selFlag = this.textArea.getSelectedText().length()) > 0) {
            int startPos = this.textArea.getSelectionStart();
            this.textArea.replaceSelection(this.jText2.getText());
            this.m = this.pattern.matcher(this.textArea.getText());
            this.m.find(startPos += this.jText2.getText().length());
            startPos = this.m.start();
            int endPos = this.m.end();
            if (startPos > -1) {
                this.textArea.setSelectionStart(startPos);
                this.textArea.setSelectionEnd(endPos);
            }
        } else {
            this.textFinder(evt);
        }
    }

    private void textReplacerForAll(ActionEvent evt) {
        this.textArea.setCaretPosition(0);
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.jText1.getText(), this.jCheckBox1.isSelected() ? 0 : 74);
            this.m = this.pattern.matcher(this.textArea.getText());
        }
        int startPos = -1;
        int endPos = -1;
        while (this.m.find()) {
            startPos = this.m.start();
            endPos = this.m.end();
            if (startPos <= -1) continue;
            this.textArea.setSelectionStart(startPos);
            this.textArea.setSelectionEnd(endPos);
            this.textArea.replaceSelection(this.jText2.getText());
            this.m = this.pattern.matcher(this.textArea.getText());
        }
    }

    private void jCheckBox1ActionPerformed(ItemEvent evt) {
        this.pattern = Pattern.compile(this.jText1.getText(), this.jCheckBox1.isSelected() ? 0 : 74);
        this.m = this.pattern.matcher(this.textArea.getText());
    }

    private void jText1Changed(DocumentEvent evt) {
        this.pattern = Pattern.compile(this.jText1.getText(), this.jCheckBox1.isSelected() ? 0 : 74);
        this.m = this.pattern.matcher(this.textArea.getText());
    }
}

