/*
 * Decompiled with CFR 0.152.
 */
package translator;

import com.inet.jortho.SpellChecker;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.text.WordUtils;
import org.components.ProtectedTextComponent;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;

public class Translator
extends Thread {
    private String originalText;
    private String fromLang;
    private String toLang;
    private String spellType;
    private JTextArea textArea;
    private JProgressBar progressBar;
    private JButton translateButton;
    private JCheckBoxMenuItem checkBoxMenu;
    private TrayIcon trayIcon;
    private JFrame mView;
    private long startTime;
    private long endTime;
    private long elapsedTime;
    private boolean bResult;
    private SimpleDateFormat dateFormat;
    private ProtectedTextComponent ptcArea;
    Preferences prefs = Preferences.userNodeForPackage(this.getClass());

    public Translator(String originalText, String fromLang, String toLang, JTextArea textArea, JProgressBar progressBar, JButton translateButton, JCheckBoxMenuItem checkBoxMenu, String spellType, TrayIcon trayIcon, JFrame mView, ProtectedTextComponent ptcArea) {
        this.originalText = originalText.replaceAll("\r", "");
        this.fromLang = fromLang;
        this.toLang = toLang;
        this.textArea = textArea;
        this.progressBar = progressBar;
        this.translateButton = translateButton;
        this.checkBoxMenu = checkBoxMenu;
        this.spellType = spellType;
        this.trayIcon = trayIcon;
        this.mView = mView;
        this.ptcArea = ptcArea;
    }

    public Translator(String originalText, String fromLang, String toLang, String spellType) {
        this.originalText = originalText;
        this.fromLang = fromLang;
        this.toLang = toLang;
        this.spellType = spellType;
    }

    @Override
    public void run() {
        this.bResult = false;
        this.startTime = System.currentTimeMillis();
        this.dateFormat = new SimpleDateFormat("HH:mm:ss");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.translateButton.setEnabled(false);
        this.checkBoxMenu.setEnabled(false);
        this.textArea.setEditable(false);
        String[] txtSplit = this.originalText.split("\n\n");
        Proxy prxProxy = null;
        if (this.prefs.get("useProxy", "2").equals("1")) {
            InetSocketAddress addr = new InetSocketAddress(this.prefs.get("proxyHost", "127.0.0.1"), Integer.parseInt(this.prefs.get("proxyPort", "9050")));
            prxProxy = new Proxy(this.prefs.get("socksProxy", "1").equals("1") ? Proxy.Type.SOCKS : Proxy.Type.HTTP, addr);
        }
        int g = 0;
        while (g < txtSplit.length) {
            try {
                String nl = "\\\n";
                String sp = "[ \\t]*";
                Pattern pat = Pattern.compile("(?s)(\\d+)[ \\t]*\\\n(\\d{1,2}):(\\d\\d):(\\d\\d),(\\d\\d\\d)[ \\t]*-->[ \\t]*(\\d\\d):(\\d\\d):(\\d\\d),(\\d\\d\\d)[ \\t]*(X1:\\d.*?)??\\\n", 74);
                Matcher mat = pat.matcher(txtSplit[g]);
                mat.find();
                int iStart = mat.start();
                int iEnd = mat.end();
                String sCounterANDTimeStamp = txtSplit[g].substring(iStart, iEnd);
                String sSubtitleTextOnly = txtSplit[g].substring(iEnd, txtSplit[g].length());
                String txtorig = sSubtitleTextOnly.replaceAll("\\<.*?\\>", "").replaceAll("\\*", "").replaceAll("\"", "").replaceAll("\\\\", "");
                String srcLang = this.fromLang;
                String trgLang = this.toLang;
                String ienc = "UTF-8";
                String oenc = "UTF-8";
                String subtitle_trn = "";
                String iSpace = new String(" ".getBytes(), "UTF-8");
                HttpURLConnection urlConnection = null;
                txtorig = Normalizer.normalize(txtorig, Normalizer.Form.NFC);
                txtorig = txtorig.replaceAll("\\s+", iSpace).replaceAll("\\.\\.\\.", "\\.").replaceAll("\n", iSpace).replaceAll("\r", iSpace);
                txtorig = txtorig.replaceAll("\\." + iSpace, "\\.").replaceAll("\\!" + iSpace, "\\!").replaceAll("\\?" + iSpace, "\\?").replaceAll("\\-" + iSpace, "\\-").replaceAll("\\;" + iSpace, "\\;");
                txtorig = txtorig.toLowerCase().trim();
                txtorig = txtorig.replaceAll("\\.", "\\." + iSpace).replaceAll("\\!", "\\!" + iSpace).replaceAll("\\?", "\\?" + iSpace).replaceAll("\\-", "\\-" + iSpace).replaceAll("\\;", "\\;" + iSpace).replaceAll("\\s+$", "").replaceAll("\\%", "percent").replaceAll("\\&", "").replaceAll("\\+", "").replaceAll("\\@", "").replaceAll("\\#", "").replaceAll("\\$", "dollar").replaceAll("\\/", "").replaceAll("\\*", "").replaceAll("\\=", "");
                if (!(srcLang.equals("ar") || srcLang.equals("iw") || srcLang.equals("yi") || srcLang.equals("fa") || srcLang.equals("ur"))) {
                    if (!(txtorig.endsWith(".") || txtorig.endsWith("!") || txtorig.endsWith("?") || txtorig.endsWith(",") || txtorig.endsWith(":") || txtorig.endsWith("-") || txtorig.endsWith(";"))) {
                        txtorig = String.valueOf(txtorig) + ".";
                    }
                } else if (!(txtorig.startsWith(".") || txtorig.startsWith("!") || txtorig.startsWith("?") || txtorig.startsWith(",") || txtorig.startsWith(":") || txtorig.startsWith("-") || txtorig.startsWith(";"))) {
                    txtorig = "." + txtorig;
                }
                if (srcLang.equals("el")) {
                    txtorig = txtorig.replaceAll("\\;", "\\?");
                }
                if (this.spellType.equals("1")) {
                    String[] sentences = txtorig.split("(?<=[.!?])\\s*");
                    String txtSentences = "";
                    int d = 0;
                    while (d < sentences.length) {
                        String xmlText = "";
                        String bodyXML = "http://www.google.com/search?q=" + URLEncoder.encode(sentences[d], ienc) + "&hl=" + srcLang + "&output=xml&ie=" + ienc + "&oe=" + oenc + "&client=google-csbe&cx=00255077836266642015%3au-scht7a-8i";
                        URL urlXML = new URL(bodyXML);
                        URLConnection urlConnectionXML = this.prefs.get("useProxy", "2").equals("1") ? urlXML.openConnection(prxProxy) : urlXML.openConnection();
                        urlConnectionXML.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                        urlConnectionXML.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:31.0) Gecko/20100101 Firefox/31.0");
                        urlConnectionXML.setRequestProperty("Accept-Encoding", "gzip, x-gzip");
                        urlConnectionXML.setUseCaches(false);
                        urlConnectionXML.setDoInput(true);
                        urlConnectionXML.setDoOutput(true);
                        String contentEncodingXML = urlConnectionXML.getContentEncoding();
                        InputStream inStreamXML = urlConnectionXML.getInputStream();
                        if (contentEncodingXML != null && contentEncodingXML.indexOf("gzip") != -1) {
                            inStreamXML = new GZIPInputStream(inStreamXML);
                        }
                        BufferedReader rdXML = new BufferedReader(new InputStreamReader(inStreamXML, oenc));
                        String lineXML = "";
                        String pageXML = "";
                        while ((lineXML = rdXML.readLine()) != null) {
                            pageXML = String.valueOf(pageXML) + lineXML.trim();
                        }
                        rdXML.close();
                        Document docXML = Jsoup.parse((String)pageXML, (String)"", (Parser)Parser.xmlParser());
                        for (Element body_out_XML : docXML.select("suggestion")) {
                            xmlText = body_out_XML.text();
                            sentences[d] = xmlText = xmlText.replaceAll("\\<.*?\\>", "");
                        }
                        txtSentences = d == 0 ? String.valueOf(txtSentences) + sentences[d] : String.valueOf(txtSentences) + " " + sentences[d];
                        ++d;
                    }
                    txtorig = txtSentences.toLowerCase().trim();
                }
                String page_res = "";
                if (!this.bResult) {
                    CookieManager manager = new CookieManager();
                    manager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
                    CookieHandler.setDefault(manager);
                    Document doc_in = Jsoup.parseBodyFragment((String)txtorig);
                    Element body_in = doc_in.body();
                    String html_in = body_in.text();
                    String body = "hl=" + trgLang.trim() + "&ie=" + ienc + "&oe=" + oenc + "&submit=Translate&langpair=" + srcLang.trim() + "|" + trgLang.trim() + "&text=" + URLEncoder.encode(html_in, ienc);
                    URL url = new URL("http://translate.google.com");
                    urlConnection = this.prefs.get("useProxy", "2").equals("1") ? (HttpURLConnection)url.openConnection(prxProxy) : (HttpURLConnection)url.openConnection();
                    urlConnection.setRequestMethod("POST");
                    urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    urlConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:31.0) Gecko/20100101 Firefox/31.0");
                    urlConnection.setRequestProperty("Accept-Encoding", "gzip, x-gzip");
                    urlConnection.setRequestProperty("Content-Length", "" + body.length());
                    HttpURLConnection.setFollowRedirects(false);
                    urlConnection.setUseCaches(false);
                    urlConnection.setDoInput(true);
                    urlConnection.setDoOutput(true);
                    OutputStreamWriter wr = new OutputStreamWriter(urlConnection.getOutputStream());
                    wr.write(body);
                    wr.flush();
                    String contentEncoding = urlConnection.getContentEncoding();
                    InputStream inStream = urlConnection.getInputStream();
                    if (contentEncoding != null && contentEncoding.indexOf("gzip") != -1) {
                        inStream = new GZIPInputStream(inStream);
                    }
                    BufferedReader rd = new BufferedReader(new InputStreamReader(inStream, oenc));
                    String line_org = "";
                    String page = "";
                    while ((line_org = rd.readLine()) != null) {
                        page = String.valueOf(page) + line_org.trim();
                    }
                    wr.close();
                    rd.close();
                    urlConnection.disconnect();
                    Document doc = Jsoup.parse((String)page);
                    Element page_ext = doc.getElementById("result_box");
                    String page_dec = page_ext.text();
                    page_dec = page_dec.replaceAll("> <", "><");
                    page_dec = page_dec.replaceAll(" ;", ";");
                    page_dec = page_dec.replaceAll("</ ", "</");
                    page_dec = page_dec.replaceAll(" =", "=");
                    page_dec = page_dec.replaceAll("= ", "=");
                    page_dec = page_dec.replaceAll("\\s+", iSpace);
                    Document doc_out = Jsoup.parseBodyFragment((String)page_dec);
                    Element body_out = doc_out.body();
                    page_res = body_out.text();
                } else {
                    page_res = txtorig;
                }
                byte[] page_nex = page_res.getBytes(oenc);
                page_res = new String(page_nex, oenc);
                if (srcLang.equals("el") || trgLang.equals("el")) {
                    page_res = page_res.replaceAll("\\;", "\\?");
                }
                page_res = page_res.replaceAll("^\\s+", "").replaceAll("\\s+$", "").replaceAll("\"", "").replaceAll("\u00ab", "").replaceAll("\u00bb", "").replaceAll("\\-\\-", "\\-").replaceAll("percent", "\\%").replaceAll("dollar", "\\$");
                page_res = page_res.replaceAll(String.valueOf(iSpace) + "\\.", "\\.").replaceAll(String.valueOf(iSpace) + "\\,", "\\,");
                page_res = page_res.replaceAll("\\s+", iSpace).replaceAll(String.valueOf(iSpace) + "\\!", "\\!").replaceAll(String.valueOf(iSpace) + "\\?", "\\?");
                page_res = page_res.replaceAll("\\.\\.", "\\.").replaceAll("\\.\\.\\.", "\\.");
                page_res = page_res.replaceAll("\\!\\!", "\\!").replaceAll("\\!\\!\\!", "\\!");
                page_res = page_res.replaceAll("\\?\\?", "\\?").replaceAll("\\?\\?\\?", "\\?");
                subtitle_trn = page_res.replaceAll("^\\.", "\\-").replaceAll(String.valueOf(iSpace) + "\\." + iSpace, String.valueOf(iSpace) + "\\-" + iSpace);
                subtitle_trn = subtitle_trn.replaceAll(String.valueOf(iSpace) + "\\.", "\\.");
                subtitle_trn = subtitle_trn.trim().replaceAll("\\-\\s+\\-", "\\-");
                String[] toSentences = subtitle_trn.split("(?<=[.!?])\\s*");
                subtitle_trn = "";
                int c = 0;
                while (c < toSentences.length) {
                    toSentences[c] = WordUtils.capitalize(toSentences[c], '.', '!', '?', ':');
                    subtitle_trn = c == 0 ? String.valueOf(subtitle_trn) + toSentences[c] : String.valueOf(subtitle_trn) + " " + toSentences[c];
                    ++c;
                }
                if (subtitle_trn.indexOf(". ") > 2 && subtitle_trn.indexOf(". ") < subtitle_trn.length() - 2) {
                    subtitle_trn = String.valueOf(subtitle_trn.substring(0, subtitle_trn.indexOf(". ") + 1)) + "\n" + subtitle_trn.substring(subtitle_trn.indexOf(". ") + 2, subtitle_trn.length());
                }
                if (subtitle_trn.indexOf("! ") > 2 && subtitle_trn.indexOf("! ") < subtitle_trn.length() - 2) {
                    subtitle_trn = String.valueOf(subtitle_trn.substring(0, subtitle_trn.indexOf("! ") + 1)) + "\n" + subtitle_trn.substring(subtitle_trn.indexOf("! ") + 2, subtitle_trn.length());
                }
                if (subtitle_trn.indexOf("? ") > 2 && subtitle_trn.indexOf("? ") < subtitle_trn.length() - 2) {
                    subtitle_trn = String.valueOf(subtitle_trn.substring(0, subtitle_trn.indexOf("? ") + 1)) + "\n" + subtitle_trn.substring(subtitle_trn.indexOf("? ") + 2, subtitle_trn.length());
                }
                String[] lnTxt = subtitle_trn.split("\n");
                subtitle_trn = "";
                int v = 0;
                while (v < lnTxt.length) {
                    if (lnTxt[v].indexOf(", ") == 0) {
                        lnTxt[v] = lnTxt[v].substring(lnTxt[v].indexOf(", ") + 2, lnTxt[v].length());
                    }
                    if (lnTxt[v].indexOf(". ") == 0) {
                        lnTxt[v] = lnTxt[v].substring(lnTxt[v].indexOf(". ") + 2, lnTxt[v].length());
                    }
                    lnTxt[v] = WordUtils.wrap(lnTxt[v], 36);
                    subtitle_trn = String.valueOf(subtitle_trn) + (subtitle_trn.equals("") ? lnTxt[v] : "\n" + lnTxt[v]);
                    ++v;
                }
                subtitle_trn = Normalizer.normalize(subtitle_trn, Normalizer.Form.NFC);
                if (g == 0) {
                    this.ptcArea = new ProtectedTextComponent((JTextComponent)this.textArea);
                    this.textArea.setText(String.valueOf(sCounterANDTimeStamp) + subtitle_trn + "\n\n");
                    this.ptcArea.protectLines(0, 1);
                } else {
                    String[] lnStrArray = this.textArea.getText().split("\n");
                    int ln = lnStrArray.length;
                    this.textArea.append(String.valueOf(sCounterANDTimeStamp) + subtitle_trn + "\n\n");
                    this.ptcArea.protectLines(ln, ln + 2);
                }
                this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
                this.progressBar.setMaximum(txtSplit.length);
                this.progressBar.setValue(g + 1);
                this.progressBar.setStringPainted(true);
                this.progressBar.updateUI();
                this.progressBar.repaint();
                this.endTime = System.currentTimeMillis();
                this.elapsedTime = this.endTime - this.startTime;
                this.mView.setTitle("SRT Translator - elapsed time: " + this.dateFormat.format(new Date(this.elapsedTime)));
            }
            catch (Exception ex) {
                System.err.println("Error: " + ex.getMessage());
            }
            ++g;
        }
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(false);
        this.progressBar.updateUI();
        this.progressBar.repaint();
        this.translateButton.setEnabled(true);
        this.checkBoxMenu.setEnabled(true);
        this.textArea.setEditable(true);
        if (this.checkBoxMenu.isSelected()) {
            SpellChecker.enableAutoSpell((JTextComponent)this.textArea, (boolean)true);
        }
        if (SystemTray.isSupported()) {
            this.trayIcon.displayMessage("The translation was completed", "at 100%", TrayIcon.MessageType.INFO);
        }
    }

    public void shutdown() {
        this.stop();
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(false);
        this.progressBar.updateUI();
        this.progressBar.repaint();
        this.translateButton.setEnabled(true);
        this.checkBoxMenu.setEnabled(true);
        this.textArea.setEditable(true);
        if (this.checkBoxMenu.isSelected()) {
            SpellChecker.enableAutoSpell((JTextComponent)this.textArea, (boolean)true);
        }
    }
}

