/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.basic.BasicFileSystemTreeCellRenderer;
import com.jidesoft.plaf.basic.BasicFileSystemTreeModel;
import com.jidesoft.plaf.basic.BasicFileSystemTreeNode;
import com.jidesoft.swing.FolderChooser;
import com.jidesoft.swing.TreeSearchable;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

class BasicFileSystemTree
extends JTree {
    public BasicFileSystemTree(FolderChooser folderChooser) {
        super(new BasicFileSystemTreeModel(folderChooser));
        this.initComponents();
    }

    protected void initComponents() {
        this.setCellRenderer(new BasicFileSystemTreeCellRenderer());
        this.setShowsRootHandles(false);
        this.setRootVisible(false);
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.setRowHeight(17);
        this.expandRow(0);
        FolderTreeListener treeListener = new FolderTreeListener();
        this.addTreeWillExpandListener(treeListener);
        this.addTreeExpansionListener(treeListener);
        new TreeSearchable(this){

            protected String convertElementToString(Object object) {
                Object treeNode;
                if (object instanceof TreePath && (treeNode = ((TreePath)object).getLastPathComponent()) instanceof BasicFileSystemTreeNode) {
                    return ((BasicFileSystemTreeNode)treeNode).getName();
                }
                return super.convertElementToString(object);
            }
        };
    }

    public String getToolTipText(MouseEvent event) {
        TreePath path = this.getPathForLocation(event.getX(), event.getY());
        if (path != null && path.getLastPathComponent() instanceof BasicFileSystemTreeNode) {
            BasicFileSystemTreeNode node = (BasicFileSystemTreeNode)path.getLastPathComponent();
            String typeDescription = node.getTypeDescription();
            if (typeDescription == null || typeDescription.length() == 0) {
                return node.toString();
            }
            return node.toString() + " - " + typeDescription;
        }
        return null;
    }

    private class FolderTreeListener
    implements TreeWillExpandListener,
    TreeExpansionListener {
        private Cursor oldCursor;

        private FolderTreeListener() {
        }

        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            Window window = SwingUtilities.getWindowAncestor(BasicFileSystemTree.this);
            if (window != null) {
                this.oldCursor = window.getCursor();
                window.setCursor(Cursor.getPredefinedCursor(3));
            }
        }

        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        }

        public void treeExpanded(TreeExpansionEvent event) {
            Window window = SwingUtilities.getWindowAncestor(BasicFileSystemTree.this);
            if (window != null) {
                window.setCursor(this.oldCursor != null ? this.oldCursor : Cursor.getDefaultCursor());
            }
            this.oldCursor = null;
        }

        public void treeCollapsed(TreeExpansionEvent event) {
        }
    }
}

