/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.vsnet;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.TopLevelMenuContainer;
import com.jidesoft.utils.SecurityUtils;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class VsnetMenuItemUI
extends MenuItemUI {
    protected JMenuItem menuItem = null;
    protected Color selectionBackground;
    protected Color selectionForeground;
    protected Color disabledForeground;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    private String acceleratorDelimiter;
    protected int defaultTextIconGap;
    protected Font acceleratorFont;
    protected MouseInputListener mouseInputListener;
    protected MenuDragMouseListener menuDragMouseListener;
    protected MenuKeyListener menuKeyListener;
    private PropertyChangeListener propertyChangeListener;
    protected Icon arrowIcon = null;
    protected Icon checkIcon = null;
    protected boolean oldBorderPainted;
    protected InputMap windowInputMap;
    private static final boolean DEBUG = false;
    protected Color shadowColor;
    protected int defaultAccelEndGap;
    protected int defaultShadowWidth;
    protected Color borderColor;
    protected Color backgroundColor;
    static final String MAX_TEXT_WIDTH = "maxTextWidth";
    static final String MAX_ACC_WIDTH = "maxAccWidth";
    protected boolean _isFloatingIcon = false;
    private ThemePainter _painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
    protected static Rectangle zeroRect = new Rectangle(0, 0, 0, 0);
    protected static Rectangle iconRect = new Rectangle();
    protected static Rectangle textRect = new Rectangle();
    protected static Rectangle acceleratorRect = new Rectangle();
    protected static Rectangle checkIconRect = new Rectangle();
    protected static Rectangle arrowIconRect = new Rectangle();
    protected static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    static Rectangle r = new Rectangle();

    public static ComponentUI createUI(JComponent c) {
        return new VsnetMenuItemUI();
    }

    public void installUI(JComponent c) {
        this.menuItem = (JMenuItem)c;
        this.installDefaults();
        this.installComponents(this.menuItem);
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        String prefix = this.getPropertyPrefix();
        this.acceleratorFont = UIDefaultsLookup.getFont("MenuItem.acceleratorFont");
        this.menuItem.setOpaque(true);
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(UIDefaultsLookup.getInsets(prefix + ".margin"));
        }
        this.defaultTextIconGap = UIDefaultsLookup.getInt(prefix + ".textIconGap");
        this.defaultAccelEndGap = UIDefaultsLookup.getInt("MenuItem.accelEndGap");
        this.defaultShadowWidth = UIDefaultsLookup.getInt("MenuItem.shadowWidth");
        this.borderColor = UIDefaultsLookup.getColor("MenuItem.selectionBorderColor");
        this.backgroundColor = UIDefaultsLookup.getColor("MenuItem.background");
        this.shadowColor = UIDefaultsLookup.getColor("MenuItem.shadowColor");
        LookAndFeel.installBorder(this.menuItem, prefix + ".border");
        this.oldBorderPainted = this.menuItem.isBorderPainted();
        Object borderPainted = UIDefaultsLookup.get(prefix + ".borderPainted");
        if (borderPainted instanceof Boolean) {
            this.menuItem.setBorderPainted((Boolean)borderPainted);
        }
        LookAndFeel.installColorsAndFont(this.menuItem, prefix + ".background", prefix + ".foreground", prefix + ".font");
        if (this.selectionBackground == null || this.selectionBackground instanceof UIResource) {
            this.selectionBackground = UIDefaultsLookup.getColor(prefix + ".selectionBackground");
        }
        if (this.selectionForeground == null || this.selectionForeground instanceof UIResource) {
            this.selectionForeground = UIDefaultsLookup.getColor(prefix + ".selectionForeground");
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = UIDefaultsLookup.getColor(prefix + ".disabledForeground");
        }
        if (this.acceleratorForeground == null || this.acceleratorForeground instanceof UIResource) {
            this.acceleratorForeground = UIDefaultsLookup.getColor(prefix + ".acceleratorForeground");
        }
        if (this.acceleratorSelectionForeground == null || this.acceleratorSelectionForeground instanceof UIResource) {
            this.acceleratorSelectionForeground = UIDefaultsLookup.getColor(prefix + ".acceleratorSelectionForeground");
        }
        this.acceleratorDelimiter = UIDefaultsLookup.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "+";
        }
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIDefaultsLookup.getIcon(prefix + ".arrowIcon");
        }
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            this.checkIcon = UIDefaultsLookup.getIcon(prefix + ".checkIcon");
        }
        this._isFloatingIcon = UIDefaultsLookup.getBoolean("Icon.floating");
    }

    protected void installComponents(JMenuItem menuItem) {
        BasicHTML.updateRenderer(menuItem, menuItem.getText());
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        if (this.mouseInputListener != null) {
            this.menuItem.addMouseListener(this.mouseInputListener);
            this.menuItem.addMouseMotionListener(this.mouseInputListener);
        }
        if ((this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem)) != null) {
            this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        }
        if ((this.menuKeyListener = this.createMenuKeyListener(this.menuItem)) != null) {
            this.menuItem.addMenuKeyListener(this.menuKeyListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem)) != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.menuItem, actionMap);
        this.updateAcceleratorBinding();
    }

    public void uninstallUI(JComponent c) {
        this.menuItem = (JMenuItem)c;
        this.uninstallDefaults();
        this.uninstallComponents(this.menuItem);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        Container parent = this.menuItem.getParent();
        if (!(parent == null || !(parent instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            JComponent p = (JComponent)parent;
            p.putClientProperty(MAX_ACC_WIDTH, null);
            p.putClientProperty(MAX_TEXT_WIDTH, null);
        }
        this.menuItem = null;
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.menuItem);
        this.menuItem.setBorderPainted(this.oldBorderPainted);
        if (this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(null);
        }
        if (this.arrowIcon instanceof UIResource) {
            this.arrowIcon = null;
        }
        if (this.checkIcon instanceof UIResource) {
            this.checkIcon = null;
        }
    }

    protected void uninstallComponents(JMenuItem menuItem) {
        BasicHTML.updateRenderer(menuItem, "");
    }

    protected void uninstallListeners() {
        if (this.mouseInputListener != null) {
            this.menuItem.removeMouseListener(this.mouseInputListener);
            this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        }
        if (this.menuDragMouseListener != null) {
            this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        }
        if (this.menuKeyListener != null) {
            this.menuItem.removeMenuKeyListener(this.menuKeyListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.mouseInputListener = null;
        this.menuDragMouseListener = null;
        this.menuKeyListener = null;
        this.propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.menuItem, null);
        if (this.windowInputMap != null) {
            SwingUtilities.replaceUIInputMap(this.menuItem, 2, null);
            this.windowInputMap = null;
        }
    }

    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputHandler();
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent c) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent c) {
        return new MenuKeyHandler();
    }

    private PropertyChangeListener createPropertyChangeListener(JComponent c) {
        return new PropertyChangeHandler();
    }

    ActionMap getActionMap() {
        String propertyPrefix = this.getPropertyPrefix();
        String uiKey = propertyPrefix + ".actionMap";
        ActionMap am = (ActionMap)UIDefaultsLookup.get(uiKey);
        if (am == null) {
            am = this.createActionMap();
            UIManager.getLookAndFeelDefaults().put(uiKey, am);
        }
        return am;
    }

    protected ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("doClick", new ClickAction());
        return map;
    }

    protected InputMap createInputMap(int condition) {
        if (condition == 2) {
            return new ComponentInputMapUIResource(this.menuItem);
        }
        return null;
    }

    void updateAcceleratorBinding() {
        KeyStroke accelerator = this.menuItem.getAccelerator();
        if (this.windowInputMap != null) {
            this.windowInputMap.clear();
        }
        if (accelerator != null) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            this.windowInputMap.put(accelerator, "doClick");
        }
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension d = null;
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d = this.getPreferredSize(c);
            d.width = (int)((float)d.width - (v.getPreferredSpan(0) - v.getMinimumSpan(0)));
        }
        return d;
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getPreferredMenuItemSize(c, this.checkIcon, this.arrowIcon, this.defaultTextIconGap);
    }

    public Dimension getMaximumSize(JComponent c) {
        Dimension d = null;
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d = this.getPreferredSize(c);
            d.width = (int)((float)d.width + (v.getMaximumSpan(0) - v.getPreferredSpan(0)));
        }
        return d;
    }

    private void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int textIconGap) {
        Container parent;
        JMenuItem b = (JMenuItem)c;
        Icon icon = b.getIcon();
        String text = b.getText();
        KeyStroke accelerator = b.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + this.acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        FontMetrics fmAccel = b.getFontMetrics(this.acceleratorFont);
        this.resetRects();
        this.layoutMenuItem(fm, text, fmAccel, acceleratorText, icon, checkIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, text == null ? 0 : textIconGap, this.defaultTextIconGap);
        if (text != null && text.trim().length() != 0) {
            r.setBounds(textRect);
        }
        if (!iconRect.isEmpty()) {
            r = SwingUtilities.computeUnion(VsnetMenuItemUI.iconRect.x, VsnetMenuItemUI.iconRect.y, VsnetMenuItemUI.iconRect.width, VsnetMenuItemUI.iconRect.height, r);
        }
        if (!((parent = this.menuItem.getParent()) == null || !(parent instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            int maxAccValue;
            JComponent p = (JComponent)parent;
            Integer maxTextWidth = (Integer)p.getClientProperty(MAX_TEXT_WIDTH);
            Integer maxAccWidth = (Integer)p.getClientProperty(MAX_ACC_WIDTH);
            int maxTextValue = maxTextWidth != null ? maxTextWidth : 0;
            int n = maxAccValue = maxAccWidth != null ? maxAccWidth : 0;
            if (VsnetMenuItemUI.r.width < maxTextValue) {
                VsnetMenuItemUI.r.width = maxTextValue;
            } else {
                p.putClientProperty(MAX_TEXT_WIDTH, VsnetMenuItemUI.r.width);
            }
            if (VsnetMenuItemUI.acceleratorRect.width > maxAccValue) {
                maxAccValue = VsnetMenuItemUI.acceleratorRect.width;
                p.putClientProperty(MAX_ACC_WIDTH, VsnetMenuItemUI.acceleratorRect.width);
            }
            VsnetMenuItemUI.r.width += maxAccValue;
            VsnetMenuItemUI.r.width += textIconGap;
            VsnetMenuItemUI.r.width += this.defaultAccelEndGap;
        }
        if (text != null && text.trim().length() != 0 && icon != null) {
            VsnetMenuItemUI.r.width += textIconGap;
        }
        Insets insets = b.getInsets();
        if (this.useCheckAndArrow()) {
            VsnetMenuItemUI.r.width += 5;
        }
        if (this.isDownArrowVisible(parent)) {
            VsnetMenuItemUI.r.width += 7;
        }
        if (insets != null) {
            VsnetMenuItemUI.r.width += insets.left + insets.right;
            VsnetMenuItemUI.r.height += insets.top + insets.bottom;
        }
        if (VsnetMenuItemUI.r.width % 2 == 0) {
            ++VsnetMenuItemUI.r.width;
        }
        if (JideSwingUtilities.getOrientationOf(this.menuItem) == 0) {
            return r.getSize();
        }
        return new Dimension(VsnetMenuItemUI.r.height, VsnetMenuItemUI.r.width);
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    public void paint(Graphics g, JComponent c) {
        this.paintMenuItem(g, c, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, this.defaultTextIconGap);
    }

    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        JMenuItem b = (JMenuItem)c;
        ButtonModel model = b.getModel();
        int menuWidth = 0;
        int menuHeight = 0;
        if (JideSwingUtilities.getOrientationOf(this.menuItem) == 0) {
            menuWidth = b.getWidth();
            menuHeight = b.getHeight();
        } else {
            menuWidth = b.getHeight();
            menuHeight = b.getWidth();
            Graphics2D g2d = (Graphics2D)g;
            g2d.rotate(1.5707963267948966);
            g2d.translate(0, -menuHeight + 1);
        }
        Insets i = c.getInsets();
        this.resetRects();
        viewRect.setBounds(0, 0, menuWidth, menuHeight);
        VsnetMenuItemUI.viewRect.x += i.left;
        VsnetMenuItemUI.viewRect.width -= i.right + VsnetMenuItemUI.viewRect.x;
        if (this.isDownArrowVisible(b.getParent())) {
            VsnetMenuItemUI.viewRect.x += 3;
            VsnetMenuItemUI.viewRect.width -= 7;
        }
        VsnetMenuItemUI.viewRect.y += i.top;
        VsnetMenuItemUI.viewRect.height -= i.bottom + VsnetMenuItemUI.viewRect.y;
        Font holdf = g.getFont();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        FontMetrics fmAccel = g.getFontMetrics(this.acceleratorFont);
        KeyStroke accelerator = b.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + this.acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        String text = this.layoutMenuItem(fm, b.getText(), fmAccel, acceleratorText, b.getIcon(), checkIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, b.getText() == null ? 0 : defaultTextIconGap, defaultTextIconGap);
        this.paintBackground(g, b, background);
        Color holdc = g.getColor();
        if ((c.getUIClassID().indexOf("CheckBoxMenu") >= 0 || c.getUIClassID().indexOf("RadioButtonMenu") >= 0) && checkIcon != null) {
            this.paintCheckBox(b, g, checkIcon);
            g.setColor(holdc);
        }
        if (JideSwingUtilities.getOrientationOf(this.menuItem) == 1) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.rotate(-1.5707963267948966);
            g2d.translate(-menuHeight + 1, 0);
            int save = VsnetMenuItemUI.iconRect.x;
            VsnetMenuItemUI.iconRect.x = VsnetMenuItemUI.iconRect.y;
            VsnetMenuItemUI.iconRect.y = save;
        }
        this.paintIcon(b, g);
        if (JideSwingUtilities.getOrientationOf(this.menuItem) == 1) {
            int save = VsnetMenuItemUI.iconRect.x;
            VsnetMenuItemUI.iconRect.x = VsnetMenuItemUI.iconRect.y;
            VsnetMenuItemUI.iconRect.y = save;
            Graphics2D g2d = (Graphics2D)g;
            g2d.rotate(1.5707963267948966);
            g2d.translate(0, -menuHeight + 1);
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (acceleratorText != null && !acceleratorText.equals("")) {
            int accOffset = 0;
            Container parent = this.menuItem.getParent();
            if (parent != null && parent instanceof JComponent) {
                JComponent p = (JComponent)parent;
                Integer maxValueInt = (Integer)p.getClientProperty(MAX_ACC_WIDTH);
                int maxValue = maxValueInt != null ? maxValueInt : VsnetMenuItemUI.acceleratorRect.width;
                accOffset = maxValue - VsnetMenuItemUI.acceleratorRect.width;
            }
            g.setFont(this.acceleratorFont);
            if (!model.isEnabled()) {
                if (this.disabledForeground != null) {
                    g.setColor(this.disabledForeground);
                    JideSwingUtilities.drawString(this.menuItem, g, acceleratorText, VsnetMenuItemUI.acceleratorRect.x - accOffset, VsnetMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
                } else {
                    g.setColor(b.getBackground().brighter());
                    JideSwingUtilities.drawString(this.menuItem, g, acceleratorText, VsnetMenuItemUI.acceleratorRect.x - accOffset, VsnetMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
                    g.setColor(b.getBackground().darker());
                    JideSwingUtilities.drawString(this.menuItem, g, acceleratorText, VsnetMenuItemUI.acceleratorRect.x - accOffset - 1, VsnetMenuItemUI.acceleratorRect.y + fmAccel.getAscent() - 1);
                }
            } else {
                if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                    g.setColor(this.acceleratorSelectionForeground);
                } else {
                    g.setColor(this.acceleratorForeground);
                }
                JideSwingUtilities.drawString(this.menuItem, g, acceleratorText, VsnetMenuItemUI.acceleratorRect.x - accOffset, VsnetMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
            }
        }
        if (arrowIcon != null) {
            if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            }
            if (this.useCheckAndArrow()) {
                arrowIcon.paintIcon(c, g, VsnetMenuItemUI.arrowIconRect.x, VsnetMenuItemUI.arrowIconRect.y);
            }
        }
        g.setColor(holdc);
        g.setFont(holdf);
    }

    protected void paintCheckBox(JMenuItem b, Graphics g, Icon checkIcon) {
        ButtonModel model = b.getModel();
        boolean isSelected = false;
        if (b instanceof JCheckBoxMenuItem) {
            isSelected = b.isSelected();
        } else if (b instanceof JRadioButtonMenuItem) {
            isSelected = b.isSelected();
        }
        if (isSelected) {
            if (model.isArmed() || b instanceof JMenu && model.isSelected()) {
                this.getPainter().paintMenuItemBackground(b, g, checkIconRect, 0, 1);
                if (b.getIcon() == null) {
                    checkIcon.paintIcon(b, g, VsnetMenuItemUI.checkIconRect.x, VsnetMenuItemUI.checkIconRect.y);
                }
            } else {
                this.getPainter().paintMenuItemBackground(b, g, checkIconRect, 0, 3);
                if (b.getIcon() == null) {
                    checkIcon.paintIcon(b, g, VsnetMenuItemUI.checkIconRect.x, VsnetMenuItemUI.checkIconRect.y);
                }
            }
        }
    }

    protected void paintIcon(JMenuItem b, Graphics g) {
        if (b.getIcon() != null) {
            Icon icon = this.getIcon(b);
            ButtonModel model = b.getModel();
            if (icon != null) {
                if (this.isFloatingIcon()) {
                    if (model.isArmed() || b instanceof JMenu && model.isSelected()) {
                        if (icon instanceof ImageIcon) {
                            ImageIcon shadow = IconsFactory.createGrayImage(((ImageIcon)icon).getImage());
                            shadow.paintIcon(b, g, VsnetMenuItemUI.iconRect.x + 1, VsnetMenuItemUI.iconRect.y + 1);
                        } else {
                            ImageIcon shadow = IconsFactory.createGrayImage(b, icon);
                            shadow.paintIcon(b, g, VsnetMenuItemUI.iconRect.x + 1, VsnetMenuItemUI.iconRect.y + 1);
                        }
                        icon.paintIcon(b, g, VsnetMenuItemUI.iconRect.x - 1, VsnetMenuItemUI.iconRect.y - 1);
                    } else {
                        icon.paintIcon(b, g, VsnetMenuItemUI.iconRect.x, VsnetMenuItemUI.iconRect.y);
                    }
                } else {
                    icon.paintIcon(b, g, VsnetMenuItemUI.iconRect.x, VsnetMenuItemUI.iconRect.y);
                }
            }
        }
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = 0;
        int menuHeight = 0;
        if (JideSwingUtilities.getOrientationOf(menuItem) == 0) {
            menuWidth = menuItem.getWidth();
            menuHeight = menuItem.getHeight();
        } else {
            menuWidth = menuItem.getHeight();
            menuHeight = menuItem.getWidth();
        }
        if (menuItem.isOpaque()) {
            if (menuItem.getComponentOrientation().isLeftToRight()) {
                this.getPainter().paintMenuShadow(menuItem, g, new Rectangle(0, 0, this.defaultShadowWidth, menuHeight), 0, 0);
                if (menuItem.getBackground() instanceof UIResource) {
                    g.setColor(this.getPainter().getMenuItemBackground());
                } else {
                    g.setColor(menuItem.getBackground());
                }
                g.fillRect(this.defaultShadowWidth, 0, menuWidth - this.defaultShadowWidth, menuHeight);
                if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                    this.getPainter().paintMenuItemBackground(menuItem, g, new Rectangle(1, 0, menuWidth - 2, menuHeight), 0, 2);
                }
                if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                    JideSwingUtilities.fillSingleGradient(g, new Rectangle(0, 0, this.defaultShadowWidth, menuHeight), 3, 255);
                }
                g.setColor(oldColor);
            } else {
                g.setColor(this.shadowColor);
                g.fillRect(menuWidth - this.defaultShadowWidth, 0, this.defaultShadowWidth, menuHeight);
                if (menuItem.getBackground() instanceof UIResource) {
                    g.setColor(this.getPainter().getMenuItemBackground());
                } else {
                    g.setColor(menuItem.getBackground());
                }
                g.fillRect(0, 0, menuWidth - this.defaultShadowWidth, menuHeight);
                if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                    this.getPainter().paintMenuItemBackground(menuItem, g, new Rectangle(0, 0, menuWidth, menuHeight), 0, 2);
                }
                if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                    JideSwingUtilities.fillSingleGradient(g, new Rectangle(menuWidth - this.defaultShadowWidth, 0, this.defaultShadowWidth, menuHeight), 7, 255);
                }
                g.setColor(oldColor);
            }
        }
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel model = menuItem.getModel();
        FontMetrics fm = g.getFontMetrics();
        if (!model.isEnabled()) {
            WindowsGraphicsUtils.paintText((Graphics)g, (AbstractButton)menuItem, (Rectangle)textRect, (String)text, (int)0);
        } else {
            int mnemonicIndex = menuItem.getDisplayedMnemonicIndex();
            if (WindowsLookAndFeel.isMnemonicHidden()) {
                mnemonicIndex = -1;
            }
            Color oldColor = g.getColor();
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g.setColor(this.selectionForeground);
            }
            JideSwingUtilities.drawStringUnderlineCharAt(menuItem, g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
            g.setColor(oldColor);
        }
    }

    private String layoutMenuItem(FontMetrics fm, String text, FontMetrics fmAccel, String acceleratorText, Icon icon, Icon checkIcon, Icon arrowIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, Rectangle acceleratorRect, Rectangle checkIconRect, Rectangle arrowIconRect, int textIconGap, int menuItemGap) {
        if (icon != null && (icon.getIconHeight() == 0 || icon.getIconWidth() == 0)) {
            icon = null;
        }
        viewRect.width -= this.getRightMargin();
        String newText = SwingUtilities.layoutCompoundLabel(this.menuItem, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewRect, iconRect, textRect, textIconGap);
        if (this.getRightMargin() > 0) {
            text = newText;
        }
        viewRect.width += this.getRightMargin();
        Insets insets = this.menuItem.getInsets();
        viewRect.x = insets.left;
        viewRect.y = insets.top;
        if (JideSwingUtilities.getOrientationOf(this.menuItem) == 0) {
            viewRect.height = this.menuItem.getHeight() - insets.top - insets.bottom;
            viewRect.width = this.menuItem.getWidth() - insets.left - insets.right;
        } else {
            viewRect.height = this.menuItem.getWidth() - insets.top - insets.bottom;
            viewRect.width = this.menuItem.getHeight() - insets.left - insets.right;
        }
        if (acceleratorText == null || acceleratorText.equals("")) {
            acceleratorRect.height = 0;
            acceleratorRect.width = 0;
            acceleratorText = "";
        } else {
            acceleratorRect.width = SwingUtilities.computeStringWidth(fmAccel, acceleratorText);
            acceleratorRect.height = fmAccel.getHeight();
        }
        if (text == null || text.equals("")) {
            textRect.height = 0;
            textRect.width = 0;
            text = "";
        } else {
            View v = null;
            View view = v = this.menuItem != null ? (View)this.menuItem.getClientProperty("html") : null;
            if (v != null) {
                textRect.width = (int)v.getPreferredSpan(0);
                textRect.height = (int)v.getPreferredSpan(1);
            } else {
                textRect.width = SwingUtilities.computeStringWidth(fm, text);
                textRect.height = fm.getHeight();
            }
        }
        if (icon == null) {
            if (this.useCheckAndArrow()) {
                iconRect.height = 16;
                iconRect.width = 16;
            } else {
                iconRect.height = 0;
                iconRect.width = 0;
            }
        } else {
            iconRect.width = icon.getIconWidth();
            iconRect.height = icon.getIconHeight();
        }
        if (arrowIcon == null) {
            arrowIconRect.height = 0;
            arrowIconRect.width = 0;
        } else {
            arrowIconRect.width = arrowIcon.getIconWidth();
            arrowIconRect.height = arrowIcon.getIconHeight();
        }
        if (checkIcon == null) {
            checkIconRect.height = 0;
            checkIconRect.width = 0;
        } else {
            checkIconRect.width = checkIcon.getIconWidth();
            checkIconRect.height = checkIcon.getIconHeight();
        }
        if (this.menuItem.getComponentOrientation().isLeftToRight()) {
            if (this.useCheckAndArrow()) {
                iconRect.x = viewRect.x + (this.defaultShadowWidth - iconRect.width) >> 1;
                if (text != null && !text.equals("")) {
                    textRect.x = viewRect.x + this.defaultShadowWidth + textIconGap;
                }
            }
            acceleratorRect.x = viewRect.x + viewRect.width - menuItemGap - acceleratorRect.width;
            if (this.useCheckAndArrow()) {
                checkIconRect.x = viewRect.x + (this.defaultShadowWidth - checkIconRect.width) >> 1;
                arrowIconRect.x = viewRect.x + viewRect.width - menuItemGap - 5 - arrowIconRect.width;
            }
        } else {
            if (text != null && !text.equals("")) {
                textRect.x = textRect.x - (this.useCheckAndArrow() ? this.defaultShadowWidth + textIconGap : viewRect.width - textRect.width >> 1);
            }
            iconRect.x -= this.defaultShadowWidth - iconRect.width >> 1;
            if (this.useCheckAndArrow()) {
                checkIconRect.x = viewRect.x + viewRect.width - (this.defaultShadowWidth + checkIconRect.width >> 1);
                arrowIconRect.x = viewRect.x + menuItemGap;
            }
        }
        if (verticalTextPosition == 0) {
            if (text != null && !text.equals("")) {
                textRect.y = viewRect.y + (viewRect.height - textRect.height >> 1);
            }
            iconRect.y = viewRect.y + (viewRect.height - iconRect.height >> 1);
        }
        Rectangle labelRect = iconRect.union(textRect);
        acceleratorRect.y = labelRect.y + (labelRect.height >> 1) - (acceleratorRect.height >> 1);
        if (this.useCheckAndArrow()) {
            arrowIconRect.y = viewRect.y + (viewRect.height - arrowIconRect.height >> 1);
            checkIconRect.y = viewRect.y + (viewRect.height - checkIconRect.height >> 1);
        }
        return text;
    }

    protected boolean useCheckAndArrow() {
        boolean b = true;
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu()) {
            b = false;
        }
        return b;
    }

    public MenuElement[] getPath() {
        MenuElement[] newPath;
        MenuSelectionManager m = MenuSelectionManager.defaultManager();
        MenuElement[] oldPath = m.getSelectedPath();
        int i = oldPath.length;
        if (i == 0) {
            return new MenuElement[0];
        }
        Container parent = this.menuItem.getParent();
        if (oldPath[i - 1].getComponent() == parent) {
            newPath = new MenuElement[i + 1];
            System.arraycopy(oldPath, 0, newPath, 0, i);
            newPath[i] = this.menuItem;
        } else {
            int j;
            for (j = oldPath.length - 1; j >= 0 && oldPath[j].getComponent() != parent; --j) {
            }
            newPath = new MenuElement[j + 2];
            System.arraycopy(oldPath, 0, newPath, 0, j + 1);
            newPath[j + 1] = this.menuItem;
        }
        return newPath;
    }

    protected void doClick(MenuSelectionManager msm) {
        if (msm == null) {
            msm = MenuSelectionManager.defaultManager();
        }
        msm.clearSelectedPath();
        this.menuItem.doClick(0);
    }

    protected ThemePainter getPainter() {
        return this._painter;
    }

    protected boolean isDownArrowVisible(Container c) {
        if (c instanceof TopLevelMenuContainer && ((TopLevelMenuContainer)((Object)c)).isMenuBar()) {
            return false;
        }
        if (c instanceof TopLevelMenuContainer && !((TopLevelMenuContainer)((Object)c)).isMenuBar()) {
            return true;
        }
        return !(c instanceof JMenuBar);
    }

    protected boolean isFloatingIcon() {
        return this._isFloatingIcon;
    }

    protected Icon getIcon(AbstractButton b) {
        ButtonModel model = b.getModel();
        Icon icon = b.getIcon();
        Icon tmpIcon = null;
        if (!model.isEnabled()) {
            tmpIcon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
            if (tmpIcon == null) {
                icon = icon instanceof ImageIcon ? IconsFactory.createGrayImage(((ImageIcon)icon).getImage()) : IconsFactory.createGrayImage(b, icon);
            }
        } else if (model.isPressed() && model.isArmed()) {
            tmpIcon = b.getPressedIcon();
            if (tmpIcon != null) {
                // empty if block
            }
        } else if (b.isRolloverEnabled() && model.isRollover()) {
            tmpIcon = model.isSelected() ? b.getRolloverSelectedIcon() : b.getRolloverIcon();
        } else if (model.isSelected()) {
            tmpIcon = b.getSelectedIcon();
        }
        if (tmpIcon != null) {
            icon = tmpIcon;
        }
        return icon;
    }

    protected int getRightMargin() {
        return 0;
    }

    private static class ClickAction
    extends AbstractAction {
        private ClickAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem mi = (JMenuItem)e.getSource();
            MenuSelectionManager.defaultManager().clearSelectedPath();
            mi.doClick();
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("labelFor") || name.equals("displayedMnemonic") || name.equals("accelerator")) {
                VsnetMenuItemUI.this.updateAcceleratorBinding();
            } else if ("buttonStyle".equals(name) || "opaque".equals(name) || "contentAreaFilled".equals(name)) {
                JMenuItem lbl = (JMenuItem)e.getSource();
                lbl.repaint();
            } else if (name.equals("orientation")) {
                JMenuItem lbl = (JMenuItem)e.getSource();
                lbl.invalidate();
                lbl.repaint();
            } else if (name.equals("text") || "font".equals(name) || "foreground".equals(name)) {
                JMenuItem lbl = (JMenuItem)e.getSource();
                String text = lbl.getText();
                BasicHTML.updateRenderer(lbl, text);
            }
        }
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        private MenuKeyHandler() {
        }

        public void menuKeyTyped(MenuKeyEvent e) {
            if (VsnetMenuItemUI.this.menuItem != null && VsnetMenuItemUI.this.menuItem.isEnabled()) {
                int key = VsnetMenuItemUI.this.menuItem.getMnemonic();
                if (key == 0 || e.getPath().length != 2) {
                    return;
                }
                if (this.lower((char)key) == this.lower(e.getKeyChar())) {
                    MenuSelectionManager manager = e.getMenuSelectionManager();
                    VsnetMenuItemUI.this.doClick(manager);
                    e.consume();
                }
            }
        }

        public void menuKeyPressed(MenuKeyEvent e) {
        }

        public void menuKeyReleased(MenuKeyEvent e) {
        }

        private char lower(char keyChar) {
            return Character.toLowerCase(keyChar);
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private MenuDragMouseHandler() {
        }

        public void menuDragMouseEntered(MenuDragMouseEvent e) {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent e) {
            if (VsnetMenuItemUI.this.menuItem != null && VsnetMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager manager = e.getMenuSelectionManager();
                MenuElement[] path = e.getPath();
                manager.setSelectedPath(path);
            }
        }

        public void menuDragMouseExited(MenuDragMouseEvent e) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent e) {
            if (VsnetMenuItemUI.this.menuItem != null && VsnetMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager manager = e.getMenuSelectionManager();
                Point p = e.getPoint();
                if (p.x >= 0 && p.x < VsnetMenuItemUI.this.menuItem.getWidth() && p.y >= 0 && p.y < VsnetMenuItemUI.this.menuItem.getHeight()) {
                    VsnetMenuItemUI.this.doClick(manager);
                } else {
                    manager.clearSelectedPath();
                }
            }
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            if (VsnetMenuItemUI.this.menuItem != null && VsnetMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                Point p = e.getPoint();
                if (p.x >= 0 && p.x < VsnetMenuItemUI.this.menuItem.getWidth() && p.y >= 0 && p.y < VsnetMenuItemUI.this.menuItem.getHeight()) {
                    VsnetMenuItemUI.this.doClick(manager);
                } else {
                    manager.processMouseEvent(e);
                }
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (VsnetMenuItemUI.this.menuItem != null && VsnetMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                int modifiers = e.getModifiers();
                if ((modifiers & 0x1C) != 0) {
                    MenuSelectionManager.defaultManager().processMouseEvent(e);
                } else {
                    manager.setSelectedPath(VsnetMenuItemUI.this.getPath());
                }
            }
        }

        public void mouseExited(MouseEvent e) {
            if (VsnetMenuItemUI.this.menuItem != null && VsnetMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                int modifiers = e.getModifiers();
                if ((modifiers & 0x1C) != 0) {
                    MenuSelectionManager.defaultManager().processMouseEvent(e);
                } else {
                    MenuElement[] path = manager.getSelectedPath();
                    if (path.length > 1) {
                        MenuElement[] newPath = new MenuElement[path.length - 1];
                        int c = path.length - 1;
                        for (int i = 0; i < c; ++i) {
                            newPath[i] = path[i];
                        }
                        manager.setSelectedPath(newPath);
                    }
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

