/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.Timer;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class JideMenu
extends JMenu
implements Alignable {
    private int _preferredPopupHorizontalAlignment = 2;
    private int _preferredPopupVerticalAlignment = 3;
    private MenuCreator _menuCreator;
    private PopupMenuCustomizer _customizer;
    private PopupMenuOriginCalculator _originCalculator;
    public static int DELAY = 400;
    private int _orientation;
    private static JideMenu _pendingMenu;
    private static HideTimer _timer;
    private static final boolean DISABLE_TIMER = true;

    public JideMenu() {
        this.initMenu();
    }

    public JideMenu(String s) {
        super(s);
        this.initMenu();
    }

    public JideMenu(Action a) {
        super(a);
        this.initMenu();
    }

    public JideMenu(String s, boolean b) {
        super(s, b);
        this.initMenu();
    }

    protected void initMenu() {
        this.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                PopupMenuCustomizer customizer;
                MenuCreator menuCreator = JideMenu.this.getMenuCreator();
                if (menuCreator != null) {
                    menuCreator.createMenu();
                    if (JideMenu.this.getPopupMenu().getComponentCount() == 0) {
                        return;
                    }
                }
                if ((customizer = JideMenu.this.getPopupMenuCustomizer()) != null) {
                    customizer.customize(JideMenu.this.getPopupMenu());
                }
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuCanceled(MenuEvent e) {
            }
        });
    }

    public boolean isTopLevelMenu() {
        return this.getParent() == null || !(this.getParent() instanceof JPopupMenu);
    }

    public PopupMenuOriginCalculator getOriginCalculator() {
        return this._originCalculator;
    }

    public void setOriginCalculator(PopupMenuOriginCalculator originCalculator) {
        this._originCalculator = originCalculator;
    }

    @Deprecated
    public MenuCreator getMenuCreator() {
        return this._menuCreator;
    }

    @Deprecated
    public void setMenuCreator(MenuCreator menuCreator) {
        this._menuCreator = menuCreator;
    }

    public PopupMenuCustomizer getPopupMenuCustomizer() {
        return this._customizer;
    }

    public void setPopupMenuCustomizer(PopupMenuCustomizer customizer) {
        this._customizer = customizer;
    }

    protected Point getPopupMenuOrigin() {
        int yOffset;
        int xOffset;
        Container parent;
        GraphicsDevice[] gds;
        if (this._originCalculator != null) {
            return this._originCalculator.getPopupMenuOrigin(this);
        }
        int x = 0;
        int y = 0;
        JPopupMenu pm = this.getPopupMenu();
        Dimension s = this.getSize();
        Dimension pmSize = pm.getPreferredSize();
        Point position = this.getLocationOnScreen();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        Rectangle screenBounds = new Rectangle(toolkit.getScreenSize());
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gds = ge.getScreenDevices()) {
            GraphicsConfiguration dgc;
            if (gd.getType() != 0 || !(dgc = gd.getDefaultConfiguration()).getBounds().contains(position)) continue;
            gc = dgc;
            break;
        }
        if (gc != null) {
            screenBounds = gc.getBounds();
            Insets screenInsets = toolkit.getScreenInsets(gc);
            screenBounds.width -= Math.abs(screenInsets.left + screenInsets.right);
            screenBounds.height -= Math.abs(screenInsets.top + screenInsets.bottom);
            position.x -= Math.abs(screenInsets.left);
            position.y -= Math.abs(screenInsets.top);
        }
        if ((parent = this.getParent()) instanceof JPopupMenu) {
            xOffset = UIDefaultsLookup.getInt("Menu.submenuPopupOffsetX");
            yOffset = UIDefaultsLookup.getInt("Menu.submenuPopupOffsetY");
            if (this.getComponentOrientation().isLeftToRight()) {
                if (JideSwingUtilities.getOrientationOf(this) == 0) {
                    x = s.width + xOffset;
                    if (position.x + x + pmSize.width >= screenBounds.width + screenBounds.x && screenBounds.width - s.width < 2 * (position.x - screenBounds.x)) {
                        x = 0 - xOffset - pmSize.width;
                    }
                } else {
                    x = s.width + xOffset;
                    if (position.x + x + pmSize.width >= screenBounds.width + screenBounds.x && screenBounds.width - s.width < 2 * (position.x - screenBounds.x)) {
                        x = 0 - xOffset - pmSize.width;
                    }
                }
            } else {
                x = 0 - xOffset - pmSize.width;
                if (position.x + x < screenBounds.x && screenBounds.width - s.width > 2 * (position.x - screenBounds.x)) {
                    x = s.width + xOffset;
                }
            }
            if (position.y + (y = yOffset) + pmSize.height >= screenBounds.height + screenBounds.y && screenBounds.height - s.height < 2 * (position.y - screenBounds.y)) {
                y = s.height - yOffset - pmSize.height;
            }
        } else {
            xOffset = UIDefaultsLookup.getInt("Menu.menuPopupOffsetX");
            yOffset = UIDefaultsLookup.getInt("Menu.menuPopupOffsetY");
            if (this.getComponentOrientation().isLeftToRight()) {
                if (JideSwingUtilities.getOrientationOf(this) == 0) {
                    if (this.getPreferredPopupHorizontalAlignment() == 2) {
                        x = xOffset;
                        if (position.x + x + pmSize.width >= screenBounds.width + screenBounds.x && screenBounds.width - s.width < 2 * (position.x - screenBounds.x)) {
                            x = s.width - xOffset - pmSize.width;
                        }
                    } else {
                        x = -pmSize.width + xOffset + s.width;
                        if (position.x + x < screenBounds.x) {
                            x = screenBounds.x - position.x;
                        }
                    }
                } else {
                    x = 1 - xOffset - pmSize.width;
                    if (position.x + x < screenBounds.x && screenBounds.width - s.width > 2 * (position.x - screenBounds.x)) {
                        x = s.width + xOffset - 1;
                    }
                }
            } else {
                x = s.width - xOffset - pmSize.width;
                if (position.x + x < screenBounds.x && screenBounds.width - s.width > 2 * (position.x - screenBounds.x)) {
                    x = xOffset;
                }
            }
            if (JideSwingUtilities.getOrientationOf(this) == 0) {
                y = s.height + yOffset - 1;
                if (this.getPreferredPopupVerticalAlignment() == 1 || position.y + y + pmSize.height >= screenBounds.height && screenBounds.height - s.height < 2 * (position.y - screenBounds.y)) {
                    y = 1 - yOffset - pmSize.height;
                }
            } else {
                y = -yOffset;
                if (position.y + y + pmSize.height >= screenBounds.height && screenBounds.height - s.height < 2 * (position.y - screenBounds.y)) {
                    y = 0 - yOffset - pmSize.height;
                }
            }
        }
        return new Point(x, y);
    }

    public boolean isOpaque() {
        if (this.isTopLevelMenu()) {
            return false;
        }
        return super.isOpaque();
    }

    public boolean originalIsOpaque() {
        return super.isOpaque();
    }

    protected void hideMenu() {
        MenuSelectionManager msm = MenuSelectionManager.defaultManager();
        msm.clearSelectedPath();
    }

    public int getPreferredPopupHorizontalAlignment() {
        return this._preferredPopupHorizontalAlignment;
    }

    public void setPreferredPopupHorizontalAlignment(int preferredPopupHorizontalAlignment) {
        this._preferredPopupHorizontalAlignment = preferredPopupHorizontalAlignment;
    }

    public int getPreferredPopupVerticalAlignment() {
        return this._preferredPopupVerticalAlignment;
    }

    public void setPreferredPopupVerticalAlignment(int preferredPopupVerticalAlignment) {
        this._preferredPopupVerticalAlignment = preferredPopupVerticalAlignment;
    }

    public boolean supportVerticalOrientation() {
        return true;
    }

    public boolean supportHorizontalOrientation() {
        return true;
    }

    public void setOrientation(int orientation) {
        int old = this._orientation;
        if (old != orientation) {
            this._orientation = orientation;
            this.firePropertyChange("orientation", old, orientation);
        }
    }

    public int getOrientation() {
        return this._orientation;
    }

    public void setPopupMenuVisible(boolean b) {
        if (b && this.getPopupMenu().getComponentCount() == 0) {
            return;
        }
        this.setPopupMenuVisibleImmediately(b);
    }

    void setPopupMenuVisibleImmediately(boolean b) {
        super.setPopupMenuVisible(b);
    }

    private void startTimer() {
        if (_timer != null) {
            this.stopTimer();
        }
        _pendingMenu = this;
        _timer = new HideTimer();
        _timer.start();
    }

    private void stopTimer() {
        if (_timer != null) {
            if (_pendingMenu != null) {
                _pendingMenu.setPopupMenuVisibleImmediately(false);
                _pendingMenu = null;
            }
            _timer.stop();
            _timer = null;
        }
    }

    private class HideTimer
    extends Timer
    implements ActionListener {
        public HideTimer() {
            super(DELAY + 300, null);
            this.addActionListener(this);
            this.setRepeats(false);
        }

        public void actionPerformed(ActionEvent e) {
            JideMenu.this.stopTimer();
        }
    }

    public static interface PopupMenuOriginCalculator {
        public Point getPopupMenuOrigin(JideMenu var1);
    }

    public static interface PopupMenuCustomizer {
        public void customize(JPopupMenu var1);
    }

    @Deprecated
    public static interface MenuCreator {
        public void createMenu();
    }
}

