/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.DefaultSplitButtonModel;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.SplitButtonModel;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;

public class JideToggleSplitButton
extends JideSplitButton
implements Accessible {
    public JideToggleSplitButton() {
        this(null, null, false);
    }

    public JideToggleSplitButton(Icon icon) {
        this(null, icon, false);
    }

    public JideToggleSplitButton(Icon icon, boolean selected) {
        this(null, icon, selected);
    }

    public JideToggleSplitButton(String text) {
        this(text, null, false);
    }

    public JideToggleSplitButton(String text, boolean selected) {
        this(text, null, selected);
    }

    public JideToggleSplitButton(Action a) {
        this();
        this.setAction(a);
    }

    public JideToggleSplitButton(String text, Icon icon) {
        this(text, icon, false);
    }

    public JideToggleSplitButton(String text, Icon icon, boolean selected) {
        this.setModel(new ToggleSplitButtonModel());
        ((SplitButtonModel)this.model).setButtonSelected(selected);
        this.init(text, icon);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJToggleButton();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJToggleButton
    extends AbstractButton.AccessibleAbstractButton
    implements ItemListener {
        public AccessibleJToggleButton() {
            super(JideToggleSplitButton.this);
            JideToggleSplitButton.this.addItemListener(this);
        }

        public void itemStateChanged(ItemEvent e) {
            JideToggleSplitButton tb = (JideToggleSplitButton)e.getSource();
            if (JideToggleSplitButton.this.accessibleContext != null) {
                if (tb.isSelected()) {
                    JideToggleSplitButton.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.CHECKED);
                } else {
                    JideToggleSplitButton.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.CHECKED, null);
                }
            }
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TOGGLE_BUTTON;
        }
    }

    public static class ToggleSplitButtonModel
    extends DefaultSplitButtonModel {
        public boolean isButtonSelected() {
            return (this.stateMask & 0x40) != 0;
        }

        public void setButtonSelected(boolean b) {
            ButtonGroup group = this.getGroup();
            if (group != null) {
                group.setSelected(this, b);
                b = group.isSelected(this);
            }
            if (this.isButtonSelected() == b) {
                return;
            }
            this.stateMask = b ? (this.stateMask |= 0x40) : (this.stateMask &= 0xFFFFFFBF);
            this.fireStateChanged();
            this.fireItemStateChanged(new ItemEvent(this, 701, this, this.isSelected() ? 1 : 2));
        }

        public void setPressed(boolean b) {
            if (this.isPressed() == b || !this.isEnabled()) {
                return;
            }
            if (!b && this.isArmed()) {
                this.setButtonSelected(!this.isButtonSelected());
            }
            this.stateMask = b ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            this.fireStateChanged();
            if (!this.isPressed() && this.isArmed()) {
                int modifiers = 0;
                AWTEvent currentEvent = EventQueue.getCurrentEvent();
                if (currentEvent instanceof InputEvent) {
                    modifiers = ((InputEvent)currentEvent).getModifiers();
                } else if (currentEvent instanceof ActionEvent) {
                    modifiers = ((ActionEvent)currentEvent).getModifiers();
                }
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
            }
        }
    }
}

